/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2022 Richtek Technology Corp.
 *
 * Author: ChiYuan Huang <cy_huang@richtek.com>
 */

#ifndef __MFD_MT6370_H__
#define __MFD_MT6370_H__

/* IRQ definitions */
#define MT6370_IRQ_DIRCHGON		0
#define MT6370_IRQ_CHG_TREG		4
#define MT6370_IRQ_CHG_AICR		5
#define MT6370_IRQ_CHG_MIVR		6
#define MT6370_IRQ_PWR_RDY		7
#define MT6370_IRQ_FL_CHG_VINOVP	11
#define MT6370_IRQ_CHG_VSYSUV		12
#define MT6370_IRQ_CHG_VSYSOV		13
#define MT6370_IRQ_CHG_VBATOV		14
#define MT6370_IRQ_CHG_VINOVPCHG	15
#define MT6370_IRQ_TS_BAT_COLD		20
#define MT6370_IRQ_TS_BAT_COOL		21
#define MT6370_IRQ_TS_BAT_WARM		22
#define MT6370_IRQ_TS_BAT_HOT		23
#define MT6370_IRQ_TS_STATC		24
#define MT6370_IRQ_CHG_FAULT		25
#define MT6370_IRQ_CHG_STATC		26
#define MT6370_IRQ_CHG_TMR		27
#define MT6370_IRQ_CHG_BATABS		28
#define MT6370_IRQ_CHG_ADPBAD		29
#define MT6370_IRQ_CHG_RVP		30
#define MT6370_IRQ_TSHUTDOWN		31
#define MT6370_IRQ_CHG_IINMEAS		32
#define MT6370_IRQ_CHG_ICCMEAS		33
#define MT6370_IRQ_CHGDET_DONE		34
#define MT6370_IRQ_WDTMR		35
#define MT6370_IRQ_SSFINISH		36
#define MT6370_IRQ_CHG_RECHG		37
#define MT6370_IRQ_CHG_TERM		38
#define MT6370_IRQ_CHG_IEOC		39
#define MT6370_IRQ_ADC_DONE		40
#define MT6370_IRQ_PUMPX_DONE		41
#define MT6370_IRQ_BST_BATUV		45
#define MT6370_IRQ_BST_MIDOV		46
#define MT6370_IRQ_BST_OLP		47
#define MT6370_IRQ_ATTACH		48
#define MT6370_IRQ_DETACH		49
#define MT6370_IRQ_HVDCP_STPDONE	51
#define MT6370_IRQ_HVDCP_VBUSDET_DONE	52
#define MT6370_IRQ_HVDCP_DET		53
#define MT6370_IRQ_CHGDET		54
#define MT6370_IRQ_DCDT			55
#define MT6370_IRQ_DIRCHG_VGOK		59
#define MT6370_IRQ_DIRCHG_WDTMR		60
#define MT6370_IRQ_DIRCHG_UC		61
#define MT6370_IRQ_DIRCHG_OC		62
#define MT6370_IRQ_DIRCHG_OV		63
#define MT6370_IRQ_OVPCTRL_SWON		67
#define MT6370_IRQ_OVPCTRL_UVP_D	68
#define MT6370_IRQ_OVPCTRL_UVP		69
#define MT6370_IRQ_OVPCTRL_OVP_D	70
#define MT6370_IRQ_OVPCTRL_OVP		71
#define MT6370_IRQ_FLED_STRBPIN		72
#define MT6370_IRQ_FLED_TORPIN		73
#define MT6370_IRQ_FLED_TX		74
#define MT6370_IRQ_FLED_LVF		75
#define MT6370_IRQ_FLED2_SHORT		78
#define MT6370_IRQ_FLED1_SHORT		79
#define MT6370_IRQ_FLED2_STRB		80
#define MT6370_IRQ_FLED1_STRB		81
#define MT6370_IRQ_FLED2_STRB_TO	82
#define MT6370_IRQ_FLED1_STRB_TO	83
#define MT6370_IRQ_FLED2_TOR		84
#define MT6370_IRQ_FLED1_TOR		85
#define MT6370_IRQ_OTP			93
#define MT6370_IRQ_VDDA_OVP		94
#define MT6370_IRQ_VDDA_UV		95
#define MT6370_IRQ_LDO_OC		103
#define MT6370_IRQ_BLED_OCP		118
#define MT6370_IRQ_BLED_OVP		119
#define MT6370_IRQ_DSV_VNEG_OCP		123
#define MT6370_IRQ_DSV_VPOS_OCP		124
#define MT6370_IRQ_DSV_BST_OCP		125
#define MT6370_IRQ_DSV_VNEG_SCP		126
#define MT6370_IRQ_DSV_VPOS_SCP		127

enum {
	MT6370_USBC_I2C = 0,
	MT6370_PMU_I2C,
	MT6370_MAX_I2C
};

struct mt6370_info {
	struct i2c_client *i2c[MT6370_MAX_I2C];
	struct regmap_irq_chip_data *irq_data;
};

#endif /* __MFD_MT6375_H__ */
