!-*- mode:f90 ; coding: utf-8 -*-
!-----------------------------------------------------------------------
! Copyright (c) 2000-2016 Gtool Development Group. All rights reserved.
!-----------------------------------------------------------------------
!
! ** Important**
!
! This file is generated from dc_present.erb by ERB included Ruby 2.7.4.
! Please do not edit this file directly.
!
! Authors::   Youhei SASAKI, Yasuhiro MORIKAWA, Eizi TOYODA
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2012. All rights reserved.
! License::   Expat. See COPYRIGHT[link:../../COPYRIGHT] in detail
!
!--
!== Judge optional control parameters
!
! Authors::   Youhei SASAKI, Takeshi HORINOUCHI, Yasuhiro MORIKAWA
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
module dc_present
  use dc_types, only: SP, SP_EPS, DP, DP_EPS, TOKEN, STRING
  private
  public :: present_and_true
  public :: present_and_false
  public :: present_and_zero
  public :: present_and_nonzero
  public :: present_and_eq
  public :: present_and_ne
  public :: present_and_not_empty
  public :: present_select
  interface present_and_eq
    module procedure present_and_eq_integer
    module procedure present_and_eq_real
    module procedure present_and_eq_double
  end interface
  interface present_and_ne
    module procedure present_and_ne_integer
    module procedure present_and_ne_real
    module procedure present_and_ne_double
  end interface present_and_ne
  interface present_select
    module procedure present_select_Char
    module procedure present_select_Char_auto
    module procedure present_select_Int
    module procedure present_select_Int_auto
    module procedure present_select_Real
    module procedure present_select_Real_auto
    module procedure present_select_Double
    module procedure present_select_Double_auto
  end interface present_select
contains
  function present_and_true(arg) result(result)
    logical                       :: result
    logical, intent(in), optional :: arg
    continue
    if(present(arg)) then
      if(arg) then
        result=.true.
      else
        result=.false.
      endif
    else
      result=.false.
    endif
  end function present_and_true
  function present_and_false(arg) result(result)
    logical                       :: result
    logical, intent(in), optional :: arg
    continue
    if(present(arg)) then
      if(arg) then
        result=.false.
      else
        result=.true.
      endif
    else
      result=.false.
    endif
  end function present_and_false
  function present_and_zero(arg) result(result)
    !
    ! arg が省略されておらず、且つ 0 の場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                       :: result
    integer, intent(in), optional :: arg
    continue
    if(present(arg)) then
      if(arg==0) then
        result=.true.
      else
        result=.false.
      endif
    else
      result=.false.
    endif
  end function present_and_zero
  function present_and_nonzero(arg) result(result)
    !
    ! arg が省略されておらず、且つ 0 ではない場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                       :: result
    integer, intent(in), optional :: arg
    continue
    if(present(arg)) then
      if(arg==0) then
        result=.false.
      else
        result=.true.
      endif
    else
      result=.false.
    endif
  end function present_and_nonzero
  function present_and_eq_integer(arg,val) result(result)
    !
    ! arg が省略されておらず、且つ val と等しい場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                       :: result
    integer, intent(in), optional :: arg
    integer, intent(in)           :: val
    continue
    result = .false.
    if(present(arg)) then
      if(arg==val) then
        result=.true.
      else
        result=.false.
      endif
    else
      result=.false.
    endif
  end function present_and_eq_integer
  function present_and_eq_real(arg,val) result(result)
    !
    ! arg が省略されておらず、且つ val と等しい場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                        :: result
    real(SP), intent(in), optional :: arg
    real(SP), intent(in)           :: val
    continue
    result = .false.
    if(present(arg)) then
      if( abs(arg - val) .le. SP_EPS ) then
        result=.true.
      else
        result=.false.
      endif
    else
      result=.false.
    endif
  end function present_and_eq_real
  function present_and_eq_double(arg,val) result(result)
    !
    ! arg が省略されておらず、且つ val と等しい場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                        :: result
    real(DP), intent(in), optional :: arg
    real(DP), intent(in)           :: val
    continue
    if(present(arg)) then
      if ( abs(arg - val) .le. DP_EPS ) then
        result=.true.
      else
        result=.false.
      endif
    else
      result=.false.
    end if
  end function present_and_eq_double
  function present_and_ne_integer(arg,val) result(result)
    !
    ! arg が省略されておらず、且つ val と等しくない場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                       :: result
    integer, intent(in), optional :: arg
    integer, intent(in)           :: val
    continue
    result = .false.
    if(present(arg)) then
      if(arg/=val) then
        result=.true.
      else
        result=.false.
      endif
    else
      result=.false.
    endif
  end function present_and_ne_integer
  function present_and_ne_real(arg,val) result(result)
    !
    ! arg が省略されておらず、且つ val と等しくない場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                        :: result
    real(SP), intent(in), optional :: arg
    real(SP), intent(in)           :: val
    continue
    result = .false.
    if(present(arg)) then
      if( abs(arg - val) .gt. SP_EPS ) then
        result=.true.
      else
        result=.false.
      endif
    else
      result=.false.
    endif
  end function present_and_ne_real
  function present_and_ne_double(arg,val) result(result)
    !
    ! arg が省略されておらず、且つ val と等しくない場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                        :: result
    real(DP), intent(in), optional :: arg
    real(DP), intent(in)           :: val
    continue
    result = .false.
    if(present(arg)) then
      if(abs(arg - val) .gt. DP_EPS) then
        result=.true.
      else
        result=.false.
      endif
    else
      result=.false.
    endif
  end function present_and_ne_double
  function present_and_not_empty(arg) result(result)
    !
    ! arg が省略されておらず、且つ空文字ではない場合、
    ! <tt>.true.</tt> が返ります。
    !
    logical                                :: result
    character(len=*), intent(in), optional :: arg
    continue
    result = .false.
    if( present(arg) .AND. (arg .ne. '')) result = .true.
  end function present_and_not_empty
  function present_select_Char(   &
    &  invalid, default,          &
    &  c0,c1,c2,c3,c4,c5,c6,c7,c8,c9 &
    &  ) result(result)
    !
    ! 省略可能な引数 c0 〜 c9 のうち、
    ! 省略されておらず、且つ invalid と等しくないものを 1 つ返します。
    ! 優先順位が最も高いものは c0 で、
    ! 最も低いのは c9 です。
    ! c0 〜 c9 の全てが省略されているか
    ! もしくは invalid と同様な場合は default が返ります。
    !
    implicit none
    character(*) ,intent(in)          :: invalid
    character(*) ,intent(in)          :: default
    character(*) ,intent(in),optional :: c0,c1,c2,c3,c4,c5,c6,c7,c8,c9
    character(STRING)                 :: result
    !=== Variables for internal work
    logical                           :: specified
    continue
    specified = .false.
    if ( present(c0) ) then
      if ( len(trim(c0)) > len(trim(invalid)) ) then
        result = c0
        specified = .true.
      else
        if ( trim(c0) /= invalid(:len(trim(c0))) ) then
          result = c0
          specified = .true.
        endif
      end if
    end if
    if ( present(c1) ) then
      if ( len(trim(c1)) > len(trim(invalid)) ) then
        result = c1
        specified = .true.
      else
        if ( trim(c1) /= invalid(:len(trim(c1))) ) then
          result = c1
          specified = .true.
        endif
      end if
    end if
    if ( present(c2) ) then
      if ( len(trim(c2)) > len(trim(invalid)) ) then
        result = c2
        specified = .true.
      else
        if ( trim(c2) /= invalid(:len(trim(c2))) ) then
          result = c2
          specified = .true.
        endif
      end if
    end if
    if ( present(c3) ) then
      if ( len(trim(c3)) > len(trim(invalid)) ) then
        result = c3
        specified = .true.
      else
        if ( trim(c3) /= invalid(:len(trim(c3))) ) then
          result = c3
          specified = .true.
        endif
      end if
    end if
    if ( present(c4) ) then
      if ( len(trim(c4)) > len(trim(invalid)) ) then
        result = c4
        specified = .true.
      else
        if ( trim(c4) /= invalid(:len(trim(c4))) ) then
          result = c4
          specified = .true.
        endif
      end if
    end if
    if ( present(c5) ) then
      if ( len(trim(c5)) > len(trim(invalid)) ) then
        result = c5
        specified = .true.
      else
        if ( trim(c5) /= invalid(:len(trim(c5))) ) then
          result = c5
          specified = .true.
        endif
      end if
    end if
    if ( present(c6) ) then
      if ( len(trim(c6)) > len(trim(invalid)) ) then
        result = c6
        specified = .true.
      else
        if ( trim(c6) /= invalid(:len(trim(c6))) ) then
          result = c6
          specified = .true.
        endif
      end if
    end if
    if ( present(c7) ) then
      if ( len(trim(c7)) > len(trim(invalid)) ) then
        result = c7
        specified = .true.
      else
        if ( trim(c7) /= invalid(:len(trim(c7))) ) then
          result = c7
          specified = .true.
        endif
      end if
    end if
    if ( present(c8) ) then
      if ( len(trim(c8)) > len(trim(invalid)) ) then
        result = c8
        specified = .true.
      else
        if ( trim(c8) /= invalid(:len(trim(c8))) ) then
          result = c8
          specified = .true.
        endif
      end if
    end if
    if ( present(c9) ) then
      if ( len(trim(c9)) > len(trim(invalid)) ) then
        result = c9
        specified = .true.
      else
        if ( trim(c9) /= invalid(:len(trim(c9))) ) then
          result = c9
          specified = .true.
        endif
      end if
    end if
    if (.not. specified) then
      result = default
    end if
  end function present_select_Char
  function present_select_Char_auto(   &
    &  invalid, default,          &
    &  c0,c1,c2,c3,c4,c5,c6,c7,c8,c9 &
    &  ) result(result)
    !
    ! 省略可能な引数 c0 〜 c9 のうち、
    ! 省略されておらず、且つ invalid と等しくないものを 1 つ返します。
    ! 優先順位が最も高いものは c0 で、
    ! 最も低いのは c9 です。
    ! c0 〜 c9 の全てが省略されているか
    ! もしくは invalid と同様な場合は default が返ります。
    !
    implicit none
    logical      ,intent(in)          :: invalid
    character(*) ,intent(in)          :: default
    character(*) ,intent(in),optional :: c0,c1,c2,c3,c4,c5,c6,c7,c8,c9
    character(STRING)                 :: result
    !=== Variables for internal work
    logical                           :: specified
    continue
    specified = .false.
    if ( present(c0) ) then
       if ( trim(c0) /= '' ) then
          result = c0
          specified = .true.
       endif
    end if
    if ( present(c1) ) then
       if ( trim(c1) /= '' ) then
          result = c1
          specified = .true.
       endif
    end if
    if ( present(c2) ) then
       if ( trim(c2) /= '' ) then
          result = c2
          specified = .true.
       endif
    end if
    if ( present(c3) ) then
       if ( trim(c3) /= '' ) then
          result = c3
          specified = .true.
       endif
    end if
    if ( present(c4) ) then
       if ( trim(c4) /= '' ) then
          result = c4
          specified = .true.
       endif
    end if
    if ( present(c5) ) then
       if ( trim(c5) /= '' ) then
          result = c5
          specified = .true.
       endif
    end if
    if ( present(c6) ) then
       if ( trim(c6) /= '' ) then
          result = c6
          specified = .true.
       endif
    end if
    if ( present(c7) ) then
       if ( trim(c7) /= '' ) then
          result = c7
          specified = .true.
       endif
    end if
    if ( present(c8) ) then
       if ( trim(c8) /= '' ) then
          result = c8
          specified = .true.
       endif
    end if
    if ( present(c9) ) then
       if ( trim(c9) /= '' ) then
          result = c9
          specified = .true.
       endif
    end if
    if (.not. specified) then
      result = default
    end if
  end function present_select_Char_auto
  function present_select_Int(   &
    &  invalid, default,          &
    &  i0,i1,i2,i3,i4,i5,i6,i7,i8,i9 &
    &  ) result(result)
    !
    ! 省略可能な引数 c0 〜 c9 のうち、
    ! 省略されておらず、且つ invalid と等しくないものを 1 つ返します。
    ! 優先順位が最も高いものは c0 で、
    ! 最も低いのは c9 です。
    ! c0 〜 c9 の全てが省略されているか
    ! もしくは invalid と同様な場合は default が返ります。
    !
    implicit none
    integer      ,intent(in)          :: invalid
    integer      ,intent(in)          :: default
    integer      ,intent(in),optional :: i0,i1,i2,i3,i4,i5,i6,i7,i8,i9
    integer                           :: result
    !=== Variables for internal work
    logical                           :: specified
    continue
    specified = .false.
    if ( present(i0) ) then
      if ( i0 /= invalid ) then
        result = i0
        specified = .true.
      endif
    end if
    if ( present(i1) ) then
      if ( i1 /= invalid ) then
        result = i1
        specified = .true.
      endif
    end if
    if ( present(i2) ) then
      if ( i2 /= invalid ) then
        result = i2
        specified = .true.
      endif
    end if
    if ( present(i3) ) then
      if ( i3 /= invalid ) then
        result = i3
        specified = .true.
      endif
    end if
    if ( present(i4) ) then
      if ( i4 /= invalid ) then
        result = i4
        specified = .true.
      endif
    end if
    if ( present(i5) ) then
      if ( i5 /= invalid ) then
        result = i5
        specified = .true.
      endif
    end if
    if ( present(i6) ) then
      if ( i6 /= invalid ) then
        result = i6
        specified = .true.
      endif
    end if
    if ( present(i7) ) then
      if ( i7 /= invalid ) then
        result = i7
        specified = .true.
      endif
    end if
    if ( present(i8) ) then
      if ( i8 /= invalid ) then
        result = i8
        specified = .true.
      endif
    end if
    if ( present(i9) ) then
      if ( i9 /= invalid ) then
        result = i9
        specified = .true.
      endif
    end if
    if (.not. specified) then
      result = default
    end if
  end function present_select_Int
  function present_select_Int_auto(   &
    &  invalid, default,          &
    &  i0,i1,i2,i3,i4,i5,i6,i7,i8,i9 &
    &  ) result(result)
    !
    ! 省略可能な引数 c0 〜 c9 のうち、
    ! 省略されておらず、且つ invalid と等しくないものを 1 つ返します。
    ! 優先順位が最も高いものは c0 で、
    ! 最も低いのは c9 です。
    ! c0 〜 c9 の全てが省略されているか
    ! もしくは invalid と同様な場合は default が返ります。
    !
    implicit none
    logical      ,intent(in)          :: invalid
    integer      ,intent(in)          :: default
    integer      ,intent(in),optional :: i0,i1,i2,i3,i4,i5,i6,i7,i8,i9
    integer                           :: result
    !=== Variables for internal work
    logical                           :: specified
    continue
    specified = .false.
    if ( present(i0) ) then
      if ( .not. invalid ) then
        result = i0
        specified = .true.
      elseif ( i0 .ne. 0 ) then
        result = i0
        specified = .true.
      end if
    end if
    if ( present(i1) ) then
      if ( .not. invalid ) then
        result = i1
        specified = .true.
      elseif ( i1 .ne. 0 ) then
        result = i1
        specified = .true.
      end if
    end if
    if ( present(i2) ) then
      if ( .not. invalid ) then
        result = i2
        specified = .true.
      elseif ( i2 .ne. 0 ) then
        result = i2
        specified = .true.
      end if
    end if
    if ( present(i3) ) then
      if ( .not. invalid ) then
        result = i3
        specified = .true.
      elseif ( i3 .ne. 0 ) then
        result = i3
        specified = .true.
      end if
    end if
    if ( present(i4) ) then
      if ( .not. invalid ) then
        result = i4
        specified = .true.
      elseif ( i4 .ne. 0 ) then
        result = i4
        specified = .true.
      end if
    end if
    if ( present(i5) ) then
      if ( .not. invalid ) then
        result = i5
        specified = .true.
      elseif ( i5 .ne. 0 ) then
        result = i5
        specified = .true.
      end if
    end if
    if ( present(i6) ) then
      if ( .not. invalid ) then
        result = i6
        specified = .true.
      elseif ( i6 .ne. 0 ) then
        result = i6
        specified = .true.
      end if
    end if
    if ( present(i7) ) then
      if ( .not. invalid ) then
        result = i7
        specified = .true.
      elseif ( i7 .ne. 0 ) then
        result = i7
        specified = .true.
      end if
    end if
    if ( present(i8) ) then
      if ( .not. invalid ) then
        result = i8
        specified = .true.
      elseif ( i8 .ne. 0 ) then
        result = i8
        specified = .true.
      end if
    end if
    if ( present(i9) ) then
      if ( .not. invalid ) then
        result = i9
        specified = .true.
      elseif ( i9 .ne. 0 ) then
        result = i9
        specified = .true.
      end if
    end if
    if (.not. specified) then
      result = default
    end if
  end function present_select_Int_auto
  function present_select_Real(   &
    &  invalid, default,          &
    &  r0,r1,r2,r3,r4,r5,r6,r7,r8,r9 &
    &  ) result(result)
    !
    ! 省略可能な引数 c0 〜 c9 のうち、
    ! 省略されておらず、且つ invalid と等しくないものを 1 つ返します。
    ! 優先順位が最も高いものは c0 で、
    ! 最も低いのは c9 です。
    ! c0 〜 c9 の全てが省略されているか
    ! もしくは invalid と同様な場合は default が返ります。
    !
    implicit none
    real(SP)     ,intent(in)          :: invalid
    real(SP)     ,intent(in)          :: default
    real(SP)     ,intent(in),optional :: r0,r1,r2,r3,r4,r5,r6,r7,r8,r9
    real(SP)                          :: result
    !=== Variables for internal work
    logical                           :: specified
    continue
    specified = .false.
    if ( present(r0) ) then
      if ( abs(r0 - invalid) .gt. SP_EPS ) then
        result = r0
        specified = .true.
      endif
    end if
    if ( present(r1) ) then
      if ( abs(r1 - invalid) .gt. SP_EPS ) then
        result = r1
        specified = .true.
      endif
    end if
    if ( present(r2) ) then
      if ( abs(r2 - invalid) .gt. SP_EPS ) then
        result = r2
        specified = .true.
      endif
    end if
    if ( present(r3) ) then
      if ( abs(r3 - invalid) .gt. SP_EPS ) then
        result = r3
        specified = .true.
      endif
    end if
    if ( present(r4) ) then
      if ( abs(r4 - invalid) .gt. SP_EPS ) then
        result = r4
        specified = .true.
      endif
    end if
    if ( present(r5) ) then
      if ( abs(r5 - invalid) .gt. SP_EPS ) then
        result = r5
        specified = .true.
      endif
    end if
    if ( present(r6) ) then
      if ( abs(r6 - invalid) .gt. SP_EPS ) then
        result = r6
        specified = .true.
      endif
    end if
    if ( present(r7) ) then
      if ( abs(r7 - invalid) .gt. SP_EPS ) then
        result = r7
        specified = .true.
      endif
    end if
    if ( present(r8) ) then
      if ( abs(r8 - invalid) .gt. SP_EPS ) then
        result = r8
        specified = .true.
      endif
    end if
    if ( present(r9) ) then
      if ( abs(r9 - invalid) .gt. SP_EPS ) then
        result = r9
        specified = .true.
      endif
    end if
    if (.not. specified) then
      result = default
    end if
  end function present_select_Real
  function present_select_Real_auto(   &
    &  invalid, default,          &
    &  r0,r1,r2,r3,r4,r5,r6,r7,r8,r9 &
    &  ) result(result)
    !
    ! 省略可能な引数 c0 〜 c9 のうち、
    ! 省略されておらず、且つ invalid と等しくないものを 1 つ返します。
    ! 優先順位が最も高いものは c0 で、
    ! 最も低いのは c9 です。
    ! c0 〜 c9 の全てが省略されているか
    ! もしくは invalid と同様な場合は default が返ります。
    !
    implicit none
    logical      ,intent(in)          :: invalid
    real(SP)     ,intent(in)          :: default
    real(SP)     ,intent(in),optional :: r0,r1,r2,r3,r4,r5,r6,r7,r8,r9
    real(SP)                          :: result
    !=== Variables for internal work
    logical                           :: specified
    continue
    specified = .false.
    if ( present(r0) ) then
      if ( .not. invalid ) then
        result = r0
        specified = .true.
      elseif ( abs(r0 - 0.0_DP) .lt. SP_EPS) then
        result = r0
        specified = .true.
      endif
    end if
    if ( present(r1) ) then
      if ( .not. invalid ) then
        result = r1
        specified = .true.
      elseif ( abs(r1 - 0.0_DP) .lt. SP_EPS) then
        result = r1
        specified = .true.
      endif
    end if
    if ( present(r2) ) then
      if ( .not. invalid ) then
        result = r2
        specified = .true.
      elseif ( abs(r2 - 0.0_DP) .lt. SP_EPS) then
        result = r2
        specified = .true.
      endif
    end if
    if ( present(r3) ) then
      if ( .not. invalid ) then
        result = r3
        specified = .true.
      elseif ( abs(r3 - 0.0_DP) .lt. SP_EPS) then
        result = r3
        specified = .true.
      endif
    end if
    if ( present(r4) ) then
      if ( .not. invalid ) then
        result = r4
        specified = .true.
      elseif ( abs(r4 - 0.0_DP) .lt. SP_EPS) then
        result = r4
        specified = .true.
      endif
    end if
    if ( present(r5) ) then
      if ( .not. invalid ) then
        result = r5
        specified = .true.
      elseif ( abs(r5 - 0.0_DP) .lt. SP_EPS) then
        result = r5
        specified = .true.
      endif
    end if
    if ( present(r6) ) then
      if ( .not. invalid ) then
        result = r6
        specified = .true.
      elseif ( abs(r6 - 0.0_DP) .lt. SP_EPS) then
        result = r6
        specified = .true.
      endif
    end if
    if ( present(r7) ) then
      if ( .not. invalid ) then
        result = r7
        specified = .true.
      elseif ( abs(r7 - 0.0_DP) .lt. SP_EPS) then
        result = r7
        specified = .true.
      endif
    end if
    if ( present(r8) ) then
      if ( .not. invalid ) then
        result = r8
        specified = .true.
      elseif ( abs(r8 - 0.0_DP) .lt. SP_EPS) then
        result = r8
        specified = .true.
      endif
    end if
    if ( present(r9) ) then
      if ( .not. invalid ) then
        result = r9
        specified = .true.
      elseif ( abs(r9 - 0.0_DP) .lt. SP_EPS) then
        result = r9
        specified = .true.
      endif
    end if
    if (.not. specified) then
      result = default
    end if
  end function present_select_Real_auto
  function present_select_Double(   &
    &  invalid, default,          &
    &  d0,d1,d2,d3,d4,d5,d6,d7,d8,d9 &
    &  ) result(result)
    !
    ! 省略可能な引数 c0 〜 c9 のうち、
    ! 省略されておらず、且つ invalid と等しくないものを 1 つ返します。
    ! 優先順位が最も高いものは c0 で、
    ! 最も低いのは c9 です。
    ! c0 〜 c9 の全てが省略されているか
    ! もしくは invalid と同様な場合は default が返ります。
    !
    implicit none
    real(DP)     ,intent(in)          :: invalid
    real(DP)     ,intent(in)          :: default
    real(DP)     ,intent(in),optional :: d0,d1,d2,d3,d4,d5,d6,d7,d8,d9
    real(DP)                          :: result
    !=== Variables for internal work
    logical                           :: specified
    continue
    specified = .false.
    if ( present(d0) ) then
      if ( abs(d0  - invalid) .gt. DP_EPS ) then
        result = d0
        specified = .true.
      endif
    end if
    if ( present(d1) ) then
      if ( abs(d1  - invalid) .gt. DP_EPS ) then
        result = d1
        specified = .true.
      endif
    end if
    if ( present(d2) ) then
      if ( abs(d2  - invalid) .gt. DP_EPS ) then
        result = d2
        specified = .true.
      endif
    end if
    if ( present(d3) ) then
      if ( abs(d3  - invalid) .gt. DP_EPS ) then
        result = d3
        specified = .true.
      endif
    end if
    if ( present(d4) ) then
      if ( abs(d4  - invalid) .gt. DP_EPS ) then
        result = d4
        specified = .true.
      endif
    end if
    if ( present(d5) ) then
      if ( abs(d5  - invalid) .gt. DP_EPS ) then
        result = d5
        specified = .true.
      endif
    end if
    if ( present(d6) ) then
      if ( abs(d6  - invalid) .gt. DP_EPS ) then
        result = d6
        specified = .true.
      endif
    end if
    if ( present(d7) ) then
      if ( abs(d7  - invalid) .gt. DP_EPS ) then
        result = d7
        specified = .true.
      endif
    end if
    if ( present(d8) ) then
      if ( abs(d8  - invalid) .gt. DP_EPS ) then
        result = d8
        specified = .true.
      endif
    end if
    if ( present(d9) ) then
      if ( abs(d9  - invalid) .gt. DP_EPS ) then
        result = d9
        specified = .true.
      endif
    end if
    if (.not. specified) then
      result = default
    end if
  end function present_select_Double
  function present_select_Double_auto(   &
    &  invalid, default,          &
    &  d0,d1,d2,d3,d4,d5,d6,d7,d8,d9 &
    &  ) result(result)
    !
    ! 省略可能な引数 c0 〜 c9 のうち、
    ! 省略されておらず、且つ invalid と等しくないものを 1 つ返します。
    ! 優先順位が最も高いものは c0 で、
    ! 最も低いのは c9 です。
    ! c0 〜 c9 の全てが省略されているか
    ! もしくは invalid と同様な場合は default が返ります。
    !
    implicit none
    logical      ,intent(in)          :: invalid
    real(DP)     ,intent(in)          :: default
    real(DP)     ,intent(in),optional :: d0,d1,d2,d3,d4,d5,d6,d7,d8,d9
    real(DP)                          :: result
    !=== Variables for internal work
    logical                           :: specified
    continue
    specified = .false.
    if ( present(d0) ) then
      if ( .not. invalid ) then
        result = d0
        specified = .true.
      elseif ( abs(d0 - 0.0_DP) .lt. DP_EPS) then
        result = d0
        specified = .true.
      endif
    end if
    if ( present(d1) ) then
      if ( .not. invalid ) then
        result = d1
        specified = .true.
      elseif ( abs(d1 - 0.0_DP) .lt. DP_EPS) then
        result = d1
        specified = .true.
      endif
    end if
    if ( present(d2) ) then
      if ( .not. invalid ) then
        result = d2
        specified = .true.
      elseif ( abs(d2 - 0.0_DP) .lt. DP_EPS) then
        result = d2
        specified = .true.
      endif
    end if
    if ( present(d3) ) then
      if ( .not. invalid ) then
        result = d3
        specified = .true.
      elseif ( abs(d3 - 0.0_DP) .lt. DP_EPS) then
        result = d3
        specified = .true.
      endif
    end if
    if ( present(d4) ) then
      if ( .not. invalid ) then
        result = d4
        specified = .true.
      elseif ( abs(d4 - 0.0_DP) .lt. DP_EPS) then
        result = d4
        specified = .true.
      endif
    end if
    if ( present(d5) ) then
      if ( .not. invalid ) then
        result = d5
        specified = .true.
      elseif ( abs(d5 - 0.0_DP) .lt. DP_EPS) then
        result = d5
        specified = .true.
      endif
    end if
    if ( present(d6) ) then
      if ( .not. invalid ) then
        result = d6
        specified = .true.
      elseif ( abs(d6 - 0.0_DP) .lt. DP_EPS) then
        result = d6
        specified = .true.
      endif
    end if
    if ( present(d7) ) then
      if ( .not. invalid ) then
        result = d7
        specified = .true.
      elseif ( abs(d7 - 0.0_DP) .lt. DP_EPS) then
        result = d7
        specified = .true.
      endif
    end if
    if ( present(d8) ) then
      if ( .not. invalid ) then
        result = d8
        specified = .true.
      elseif ( abs(d8 - 0.0_DP) .lt. DP_EPS) then
        result = d8
        specified = .true.
      endif
    end if
    if ( present(d9) ) then
      if ( .not. invalid ) then
        result = d9
        specified = .true.
      elseif ( abs(d9 - 0.0_DP) .lt. DP_EPS) then
        result = d9
        specified = .true.
      endif
    end if
    if (.not. specified) then
      result = default
    end if
  end function present_select_Double_auto
end module dc_present
