!= dc_calendar ǻѤ, ѿ, ³
!= Internal parameters, variables, procedures used in "dc_calendar"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dc_calendar_internal.f90,v 1.7 2010-10-06 01:48:12 morikawa Exp $
! Tag Name::  $Name: gtool5-20101228-1 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module dc_calendar_internal
  !
  != dc_calendar ǻѤ, ѿ, ³
  != Internal parameters, variables, procedures used in "dc_calendar"
  !

  use dc_calendar_types, only: DC_CAL, DC_CAL_DATE
  use dc_types, only: DP
  implicit none
  private
  public:: default_cal_set, dccaldate_normalize, &
    &      dccaltype_str, dccaldate_str2ustr, &
    &      dccaldate_str2usym, dccaldate_ym2d

  type(DC_CAL), save, target, public:: default_cal
                               ! ǥեȤ. 
                               ! 
                               ! DCCal ǻϤޤ³Τ, 
                               ! "dc_calendar_types#DC_CAL" 
                               ! άǽͿʤˤϤ
                               ! ⤷Ѥ. 
                               ! 

  type(DC_CAL_DATE), save, target, public:: default_date
                               ! ǥեȤ. 
                               ! 
                               ! DCCalDate ǻϤޤ³Τ, 
                               ! "dc_calendar_types#DC_CAL_DATE" 
                               ! άǽͿʤˤϤ
                               ! ⤷Ѥ. 
                               ! 

contains
  subroutine default_cal_set
    ! 
    ! DCCal ǻϤޤ³ƤӽФ, "dc_calendar_types#DC_CAL" 
    ! ꤬ԤƤʤˤ, ޤμ³ƤӽФ, 
    ! ǥեȤ "default_cal" 򥰥쥴ꥪȤꤹ. 
    ! 
    !  "default_cal" ꤵƤˤϤμ³
    ! ǤȽꤷƲ⤻˼³λ뤿, 
    ! μ³ϲٸƤӽФƤɤ, ƤӽФ¦Ǿ̵֤ͭ
    ! ǧɬפϤʤ. 
    ! 
    use dc_calendar_types, only: CAL_GREGORIAN
    implicit none
    type(DC_CAL), pointer:: calp =>null()
  continue
    calp => default_cal

    if ( calp % initialized ) return

    calp % cal_type = CAL_GREGORIAN
    calp % month_in_year = 12
    calp % hour_in_day   = 24
    calp % min_in_hour   = 60
    calp % sec_in_min    = 60.0_DP
    allocate( calp % day_in_month(1:12) )
    calp % day_in_month(1:12) = &
      & (/ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /)

    calp % initialized = .true.
    nullify( calp )
  end subroutine default_cal_set


  function dccaldate_normalize( year, month, day, hour, min, sec, cal ) result(stat)
    !
    !  cal ˽, Ԥ. 
    ! dc_calender ⥸塼ǻѤ뤳ȤȤ. 
    ! Ūˤϰʲξ»ܤ. 
    !
    ! * sec  cal ꤵ1 ʬÿפĶƤ. 
    !   -> sec 1 ʬÿװǼ褦ǯʬ˷夲롥
    ! * min  cal ꤵ1 ֤ʬפĶƤ. 
    !   -> min 1 ֤ʬװǼ褦ǯ˷夲롥
    ! * hour  cal ꤵ1 λֿפĶƤ. 
    !   -> hour 1 λֿװǼ褦ǯ˷夲롥
    ! * day  cal ꤵ1 פĶƤ. 
    !   -> day 1 װǼ褦ǯ˷夲롥
    ! 
    ! * sec, min, hour, day ξ. 
    !   -> 줾ˤ褦ʬΰ̤˷夲롥
    !
    ! * day  0 ξ. 
    !   -> ˤ褦ΰ̤˷夲롥
    !
    ! Ԥ stat ˤ DC_NOERR (=0) ֤뤬, 
    ! ŪǤʤˤϥ顼 DC_EINCONSISTCALDATE 
    ! ֤. ŪǤ뤫ɤϰʲȽꤹ. 
    ! 
    ! * , ˴ޤޤ1ǯηפ
    !   ĶƤޤäƤ
    !
    use dc_error, only: DC_NOERR, DC_EINCONSISTCALDATE
    use dc_calendar_types, only: &
      & CAL_USER_DEFINED, &
      & CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN, CAL_360DAY
    implicit none
    integer:: stat                      ! ơ. Status.
    integer, intent(inout):: year       ! ǯ. Year.  
    integer, intent(inout):: month      ! . Month. 
    integer, intent(inout):: day        ! . Day. 
    integer, intent(inout):: hour       ! . Hour. 
    integer, intent(inout):: min        ! ʬ. Minute. 
    real(DP), intent(inout):: sec       ! . Sec. 
    type(DC_CAL), intent(in):: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 

    ! Ǥ 1 
    ! Days in months of previously-defined calendars
    !
    integer:: day_in_month_jg
    integer, pointer:: day_in_month(:) =>null()

    ! Ǥ 1 ֡ʬλ֡ʬÿ
    ! Hours, minutes, seconds in a day, a hour, a minute of previously-defined calendars
    !
    integer:: month_in_year   ! 1 λֿ. 
                              ! Hours in a day. 
    integer:: hour_in_day     ! 1 λֿ. 
                              ! Hours in a day. 
    integer:: min_in_hour     ! 1 ֤ʬ. 
                              ! Minutes in a hour. 
    real(DP):: sec_in_min     ! 1 ʬÿ. 
                              ! Seconds in a minute. 

    ! ѿ
    ! Work variables
    !
    real(DP):: wyear, wday, whour, wmin
    real(DP):: wdb, ychunk_e6, ychunk_e3, chunk_scale_e6, chunk_scale_e3
  continue
    stat = DC_NOERR

    ! å
    ! Check consistency calendar and date
    !
!!$    if ( min  > cal % min_in_hour ) stat = DC_EINCONSISTCALDATE
!!$    if ( hour > cal % hour_in_day ) stat = DC_EINCONSISTCALDATE
!!$    if ( all( day  > cal % day_in_month) ) stat = DC_EINCONSISTCALDATE
    select case( cal % cal_type )
    case( CAL_USER_DEFINED )
      if ( month > cal % month_in_year ) stat = DC_EINCONSISTCALDATE
    case default
      if ( month > 12 ) stat = DC_EINCONSISTCALDATE
    end select

    if ( stat /= DC_NOERR ) return

    ! áѴѥ᥿¾
    ! Set parameter for conversion of sec -- day, etc
    ! 
    month_in_year = cal % month_in_year
    hour_in_day   = cal % hour_in_day
    min_in_hour   = cal % min_in_hour
    sec_in_min    = cal % sec_in_min
    day_in_month => cal % day_in_month

    select case( cal % cal_type )
    case( CAL_JULIAN )
      chunk_scale_e6 = 4.0e+5
      ychunk_e6 = 146100000.0_DP

      chunk_scale_e3 = 4.0e+2
      ychunk_e3 = 146100.0_DP
    case( CAL_GREGORIAN )
      chunk_scale_e6 = 4.0e+5
      ychunk_e6 = 146097000.0_DP

      chunk_scale_e3 = 4.0e+2
      ychunk_e3 = 146097.0_DP
    case default
      chunk_scale_e6 = 1.0e+6
      ychunk_e6 = chunk_scale_e6 * sum( day_in_month(:) )

      chunk_scale_e3 = 1.0e+3
      ychunk_e3 = chunk_scale_e3 * sum( day_in_month(:) )
    end select

    ! ټ¿˰Ū˳Ǽ
    ! Store in double precision variable temporally
    !
    wyear  = real( year, DP )
    wday   = real( day, DP )
    whour  = real( hour, DP )
    wmin   = real( min, DP )


    !  -> ʬη夲
    ! Moving up sec -> min
    !
    if ( .not. sec < sec_in_min ) then
      wmin = wmin + aint( sec / sec_in_min )
      sec = mod( sec, sec_in_min )
    elseif ( sec < 0.0_DP ) then
      wdb = ceiling( abs(sec) / sec_in_min )
      wmin = wmin - wdb
      sec = sec + wdb * sec_in_min
    end if

    ! ʬ -> η夲
    ! Moving up min -> hour
    !
    if ( .not. wmin < min_in_hour ) then
      whour = whour + aint( wmin / min_in_hour )
      wmin = mod( wmin, real( min_in_hour, DP ) )
    elseif ( wmin < 0 ) then
      wdb = ceiling( abs(wmin) / real(min_in_hour) )
      whour = whour - wdb
      wmin = wmin + wdb * min_in_hour
    end if

    !  -> η夲
    ! Moving up hour -> day
    !
    if ( .not. whour < hour_in_day ) then
      wday = wday + aint( whour / hour_in_day )
      whour = mod( whour, real( hour_in_day, DP ) )
    elseif ( whour < 0 ) then
      wdb = ceiling( abs(whour) / real(hour_in_day) )
      wday = wday - wdb
      whour = whour + wdb * hour_in_day
    end if

    ! ⤷ 0 ξ硤ʬǯ˷夲Ѵ
    ! Negative or 0 part of day is moved up to year
    !
    if ( wday < 1.0_DP ) then
      select case( cal % cal_type )
      case( CAL_JULIAN )

        do while ( wday < 1.0_DP )

          if ( wday < - ychunk_e6 ) then
            wyear = wyear + chunk_scale_e6 * ( aint( wday / ychunk_e6 ) - 1.0_DP )
            wday = mod( wday, ychunk_e6 ) + ychunk_e6
          end if

          if ( wday < 1.0_DP ) then
            wyear = wyear + chunk_scale_e3 * ( aint( wday / ychunk_e3 ) - 1.0_DP )
            wday = mod( wday, ychunk_e3 ) + ychunk_e3
          end if

        end do

      case( CAL_GREGORIAN )

        do while ( wday < 1.0_DP )

          if ( wday < - ychunk_e6 ) then
            wyear = wyear + chunk_scale_e6 * ( aint( wday / ychunk_e6 ) - 1.0_DP )
            wday = mod( wday, ychunk_e6 ) + ychunk_e6
          end if

          if ( wday < 1.0_DP ) then
            wyear = wyear + chunk_scale_e3 * ( aint( wday / ychunk_e3 ) - 1.0_DP )
            wday = mod( wday, ychunk_e3 ) + ychunk_e3
          end if

        end do

      case default

        do while ( wday < 1.0_DP )

          if ( wday < - ychunk_e6 ) then
            wyear = wyear + chunk_scale_e6 * ( aint( wday / ychunk_e6 ) - 1.0_DP )
            wday = mod( wday, ychunk_e6 ) + ychunk_e6
          end if

          if ( wday < 1.0_DP ) then
            wyear = wyear + chunk_scale_e3 * ( aint( wday / ychunk_e3 ) - 1.0_DP )
            wday = mod( wday, ychunk_e3 ) + ychunk_e3
          end if

        end do

      end select

    end if

    !  -> ǯη夲
    ! Moving up day -> year and month
    !
    select case( cal % cal_type )
    case( CAL_JULIAN )

      if ( wday > ychunk_e6 ) then
        wyear = wyear + chunk_scale_e6 * aint( wday / ychunk_e6 )
        wday = mod( wday, ychunk_e6 )
      end if

      if ( wday > ychunk_e3 ) then
        wyear = wyear + chunk_scale_e3 * aint( wday / ychunk_e3 )
        wday = mod( wday, ychunk_e3 )
      end if

      do
        if ( month == 2 ) then
          if ( mod( wyear, 4.0_DP ) == 0 ) then
            day_in_month_jg = 29
          else
            day_in_month_jg = 28
          end if
        else
          day_in_month_jg = day_in_month(month)
        end if

        if ( .not. wday > day_in_month_jg ) exit

        wday = wday - day_in_month_jg
        month = month + 1
        if ( month > month_in_year ) then
          month = 1
          wyear = wyear + 1
        end if
      end do

    case( CAL_GREGORIAN )

      if ( wday > ychunk_e6 ) then
        wyear = wyear + chunk_scale_e6 * aint( wday / ychunk_e6 )
        wday = mod( wday, ychunk_e6 )
      end if

      if ( wday > ychunk_e3 ) then
        wyear = wyear + chunk_scale_e3 * aint( wday / ychunk_e3 )
        wday = mod( wday, ychunk_e3 )
      end if

      do
        if ( month == 2 ) then
          if ( mod( wyear, 400.0_DP ) == 0 ) then
            day_in_month_jg = 29
          elseif ( mod( wyear, 100.0_DP ) == 0 ) then
            day_in_month_jg = 28
          elseif ( mod( wyear, 4.0_DP ) == 0 ) then
            day_in_month_jg = 29
          else
            day_in_month_jg = 28
          end if
        else
          day_in_month_jg = day_in_month(month)
        end if

        if ( .not. wday > day_in_month_jg ) exit

        wday = wday - day_in_month_jg
        month = month + 1
        if ( month > month_in_year ) then
          month = 1
          wyear = wyear + 1
        end if
      end do

    case default

      if ( wday > ychunk_e6 ) then
        wyear = wyear + chunk_scale_e6 * aint( wday / ychunk_e6 )
        wday = mod( wday, ychunk_e6 )
      end if

      if ( wday > ychunk_e3 ) then
        wyear = wyear + chunk_scale_e3 * aint( wday / ychunk_e3 )
        wday = mod( wday, ychunk_e3 )
      end if

      do while ( wday > day_in_month(month) )
        wday = wday - day_in_month(month)
        month = month + 1
        if ( month > month_in_year ) then
          month = 1
          wyear = wyear + 1
        end if
      end do

    end select

    ! ᤹
    ! Return to integer
    !
    year  = wyear 
    day   = wday  
    hour  = whour 
    min   = wmin  

  end function dccaldate_normalize

  function dccaldate_ym2d( year, month, day, cal, day_of_year ) result(stat)
    !
    !  cal ˽, 򤽤ǯϤޤäѴ. 
    ! ̤ټ¿Ȥ *day_of_year* ֤. 
    ! dccaldate_normalize ˤä˸ƤӽФ. 
    !
    use dc_error, only: DC_NOERR, DC_EINCONSISTCALDATE
    use dc_calendar_types, only: &
      & CAL_USER_DEFINED, &
      & CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN, CAL_360DAY
    implicit none
    integer:: stat                      ! ơ. Status.
    integer, intent(in):: year          ! ǯ. Year.  
    integer, intent(in):: month         ! . Month. 
    integer, intent(in):: day           ! . Day. 
    real(DP), intent(out):: day_of_year ! ǯϤ. Day of year
    type(DC_CAL), intent(in):: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 

    ! ѿ
    ! Work variables
    !
    integer:: i

  continue
    stat = DC_NOERR

    ! å
    ! Check consistency calendar and date
    !
!!$    if ( min  > cal % min_in_hour ) stat = DC_EINCONSISTCALDATE
!!$    if ( hour > cal % hour_in_day ) stat = DC_EINCONSISTCALDATE
!!$    if ( all( day  > cal % day_in_month) ) stat = DC_EINCONSISTCALDATE
    select case( cal % cal_type )
    case( CAL_USER_DEFINED )
      if ( month > cal % month_in_year ) stat = DC_EINCONSISTCALDATE
    case default
      if ( month > 12 ) stat = DC_EINCONSISTCALDATE
    end select

    if ( stat /= DC_NOERR ) return

    ! ټ¿˰Ū˳Ǽ
    ! Store in double precision variable temporally
    !
    day_of_year  = real( day, DP )

    ! ǯ ->  η겼
    ! Moving doun year and month -> day
    !
    select case( cal % cal_type )
    case( CAL_JULIAN )

      do i = 1, month - 1
        if ( i == 2 ) then
          if ( mod( year, 4 ) == 0 ) then
            day_of_year = day_of_year + 29
          else
            day_of_year = day_of_year + 28
          end if
        else
          day_of_year = day_of_year + cal % day_in_month(i)
        end if
      end do

    case( CAL_GREGORIAN )

      do i = 1, month - 1
        if ( i == 2 ) then
          if ( mod( year, 400 ) == 0 ) then
            day_of_year = day_of_year + 29
          elseif ( mod( year, 100 ) == 0 ) then
            day_of_year = day_of_year + 28
          elseif ( mod( year, 4 ) == 0 ) then
            day_of_year = day_of_year + 29
          else
            day_of_year = day_of_year + 28
          end if
        else
          day_of_year = day_of_year + cal % day_in_month(i)
        end if

      end do

    case default

      do i = 1, month - 1
        day_of_year = day_of_year + cal % day_in_month(i)
      end do

    end select

  end function dccaldate_ym2d


  function dccaltype_str( cal_type ) result(str)
    !
    ! 񥿥 *cal_type* ʸ *str* Ѵ. 
    !  *cal_type* ξ϶ʸ֤. 
    ! 
    use dc_calendar_types, only: &
      & CAL_USER_DEFINED, &
      & CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN, CAL_360DAY
    use dc_types, only: TOKEN
    implicit none
    character(TOKEN):: str
    integer, intent(in):: cal_type

    ! ѿ
    ! Work variables
    !
  continue
    select case( cal_type )
    case(CAL_USER_DEFINED) ; str = 'user_defined'
    case(CAL_CYCLIC)       ; str = 'cyclic      '
    case(CAL_NOLEAP)       ; str = 'noleap      '
    case(CAL_JULIAN)       ; str = 'julian      '
    case(CAL_GREGORIAN)    ; str = 'gregorian   '
    case(CAL_360DAY)       ; str = '360day      '
    case default           ; str = '            '
    end select
  end function dccaltype_str


  function dccaldate_str2ustr(str) result(unit)
    !
    !  *str* Ϳ줿ʸᤷ, ñ̤ *unit* ֤. 
    ! 줾ʲʸñ̤ȤƲᤵ.
    ! ʸȾʸ϶̤ʤ. 
    ! ֤ʸϰʲʸƬʸȤʤ. 
    ! (: *str*  'hrs.' Ϳ, dc_calendar_types#UNIT_HOUR
    ! Ƭʸ UNIT_HOUR(1) ֤.)
    !
    ! ǯ         :: dc_calendar_types#UNIT_YEAR
    !          :: dc_calendar_types#UNIT_MONTH
    !          :: dc_calendar_types#UNIT_DAY
    !          :: dc_calendar_types#UNIT_HOUR
    ! ʬ         :: dc_calendar_types#UNIT_MIN
    !          :: dc_calendar_types#UNIT_SEC
    !
    ! ˳ʤʸ *str* Ϳ, ʸ֤. 
    !
    use dc_types, only: TOKEN
    use dc_calendar_types, only: UNIT_YEAR, UNIT_MONTH, UNIT_DAY, &
      & UNIT_HOUR, UNIT_MIN, UNIT_SEC
    use dc_string, only: StriEq
    implicit none
    character(*), intent(in):: str
    character(TOKEN):: unit
    integer :: unit_str_size, i
  continue
    unit = adjustl(str)

    unit_str_size = size(UNIT_SEC)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_SEC(i)))) then
        unit = UNIT_SEC(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_MIN)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MIN(i)))) then
        unit = UNIT_MIN(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_HOUR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_HOUR(i)))) then
        unit = UNIT_HOUR(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_DAY)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_DAY(i)))) then
        unit = UNIT_DAY(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_MONTH)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MONTH(i)))) then
        unit = UNIT_MONTH(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_YEAR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_YEAR(i)))) then
        unit = UNIT_YEAR(1)
        return
      end if
    end do

    unit = ''

  end function dccaldate_str2ustr

  function dccaldate_str2usym(str) result(symbol)
    !
    !  *str* Ϳ줿ʸᤷ, ñ̤򼨤
    !  *symbol* ֤. 줾ʲʸñ̤ȤƲ᤹.
    ! ʸȾʸ϶̤ʤ.
    !
    ! ǯ         :: dc_calendar_types#UNIT_YEAR
    !          :: dc_calendar_types#UNIT_MONTH
    !          :: dc_calendar_types#UNIT_DAY
    !          :: dc_calendar_types#UNIT_HOUR
    ! ʬ         :: dc_calendar_types#UNIT_MIN
    !          :: dc_calendar_types#UNIT_SEC
    !
    ! ֤륷ܥ () ϰʲ̤. 
    !
    ! ǯ         :: dc_calendar_types#UNIT_SYMBOL_YEAR
    !          :: dc_calendar_types#UNIT_SYMBOL_MONTH
    !          :: dc_calendar_types#UNIT_SYMBOL_DAY
    !          :: dc_calendar_types#UNIT_SYMBOL_HOUR
    ! ʬ         :: dc_calendar_types#UNIT_SYMBOL_MIN
    !          :: dc_calendar_types#UNIT_SYMBOL_SEC
    !
    ! ˳ʤʸ *str* Ϳ, 
    ! dc_calendar_types#UNIT_SYMBOL_ERR ֤. 
    !
    use dc_types, only: TOKEN
    use dc_calendar_types, only: UNIT_YEAR, UNIT_MONTH, UNIT_DAY, &
      & UNIT_HOUR, UNIT_MIN, UNIT_SEC, &
      & UNIT_SYMBOL_YEAR, UNIT_SYMBOL_MONTH, UNIT_SYMBOL_DAY, &
      & UNIT_SYMBOL_HOUR, UNIT_SYMBOL_MIN, UNIT_SYMBOL_SEC, &
      & UNIT_SYMBOL_ERR
    use dc_string, only: StriEq
    implicit none
    character(*), intent(in):: str
    integer:: symbol
    integer:: unit_str_size, i
    character(TOKEN):: unit
  continue
    unit = adjustl(str)

    unit_str_size = size(UNIT_SEC)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_SEC(i)))) then
        symbol = UNIT_SYMBOL_SEC
        return
      end if
    end do

    unit_str_size = size(UNIT_MIN)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MIN(i)))) then
        symbol = UNIT_SYMBOL_MIN
        return
      end if
    end do

    unit_str_size = size(UNIT_HOUR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_HOUR(i)))) then
        symbol = UNIT_SYMBOL_HOUR
        return
      end if
    end do

    unit_str_size = size(UNIT_DAY)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_DAY(i)))) then
        symbol = UNIT_SYMBOL_DAY
        return
      end if
    end do

    unit_str_size = size(UNIT_MONTH)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MONTH(i)))) then
        symbol = UNIT_SYMBOL_MONTH
        return
      end if
    end do

    unit_str_size = size(UNIT_YEAR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_YEAR(i)))) then
        symbol = UNIT_SYMBOL_YEAR
        return
      end if
    end do

    symbol = UNIT_SYMBOL_ERR

  end function dccaldate_str2usym

end module dc_calendar_internal
