!
!= gtool_history 󶡤빽¤ǡ
!= Derived types provided from "gtool_history"
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: gtool_history_types.f90,v 1.5 2009-10-10 08:01:52 morikawa Exp $
! Tag Name::  $Name: gtool5-20100413 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gtool_history_types
  !
  != gtool_history 󶡤빽¤ǡ
  != Derived types provided from "gtool_history"
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ⥸塼γפˡˤĤƤ, gtool_history 
  ! 򻲾Ȥ. 
  !
  ! See "gtool_history" for brief and usage of this module. 
  !
  !== Derived types
  !
  ! GT_HISTORY          :: gtool4 ǡ
  ! GT_HISTORY_AXIS     :: gtool4 ǡɸ
  ! GT_HISTORY_VARINFO  :: gtool4 ǡѿ
  !

  use dc_types, only: STRING, TOKEN, DP, STDERR
  use dc_date_types, only: DC_DIFFTIME, UNIT_SYMBOL_ERR
  use gtdata_types, only: GT_VARIABLE
  implicit none
  private

  public:: GT_HISTORY, GT_HISTORY_AXIS, GT_HISTORY_VARINFO
  public:: GT_HISTORY_ATTR, GT_HISTORY_AVRDATA
  public:: GT_HISTORY_MPIFILEINFO, GT_HISTORY_MPIAXISDATA
  public:: GT_HISTORY_MPIAXISINFO, GT_HISTORY_MPIVARINDEX

  type GT_HISTORY
    !
    !== gtool4 netCDF ǡνѹ¤
    !
    ! ηѿ HistoryCreate ˤäƽꤵɬפޤ
    ! 塢ǡѤʣΥ֥롼ˤäѤޤ
    ! ǽŪˤ HistoryClose ˤäƽλƤ
    !
    ! ι¤ΤǤˤʤäƤޤ
    ! 䤤碌κݤˤ HistoryInquire ѤƤ
    !
    !
    ! Data entity of this type represents a netCDF dataset
    ! controlled by gtool5 library.
    ! It must be initialized by HistoryCreate ,
    ! then used in many subroutines, and must be finalized by 
    ! HistoryClose .
    ! Note that the resultant file is undefined if you forget to 
    ! finalize it. 
    !
    ! Users are recommended to retain the object of this type
    ! returned by HistoryCreate,
    ! to use it as the last argument called *history* for
    ! all following subroutine calls.
    ! However, it is not mandatory.
    ! When you are going to write *ONLY* one dataset,
    ! argument *history* of all subroutine calls can be omitted, and
    ! the history entity will be internally managed within this module.

    logical:: initialized = .false.
                              ! ե饰. 
                              ! Initialization flag
    integer:: unlimited_index = 0
                              ! ̵¼ ID. 
                              ! ID of unlimited dimension.
    character(TOKEN):: unlimited_units = ''
                              ! ̵¼ñ. 
                              ! Units of unlimited dimension.
    integer:: unlimited_units_symbol = UNIT_SYMBOL_ERR
                              ! ̵¼ñ. 
                              ! Units of unlimited dimension.
    type(GT_VARIABLE), pointer:: dimvars(:) =>null()
                              ! ѿ ID.
                              ! it is index of dimvars(:),
                              ! not that of vars(:).
    logical, pointer:: dim_value_written(:) =>null()
                              ! ƼҺѤߤɤ
    real(DP):: origin, interval, newest, oldest
                              ! ñ̤ HistoryCreate  units ̵¼
                              ! бΤˤʤ. 
    logical:: origin_setting = .false.
                              ! ֤θŪꤵ줿. 
    type(GT_VARIABLE), pointer:: vars(:) =>null()
                              ! ѿ ID 
    integer, pointer:: growable_indices(:) =>null()
                              ! ̵¼ź
                              ! (̵¼̵ 0)
    integer, pointer:: count(:) =>null()
                              ! ̵¼Ĺ
    integer, pointer:: var_avr_count(:) =>null()
                              ! ѿλʿͽϤκݤѻ. 
                              ! -1 ξϽϥǡʿѲʤ. 
                              ! 
                              ! Number of times of integral 
                              ! for time-averaged value output of each variable. 
                              ! -1 disables average value output
    type(GT_HISTORY_AVRDATA), pointer:: var_avr_data(:) =>null()
                              ! ʿͤϤ뤿Υǡݴ. 
                              !
                              ! Array for temporary keeping data for 
                              ! time-averaged value output
    logical, pointer:: var_avr_firstput(:) =>null()
                              ! ܤνϤ򼨤ե饰. 
                              ! 
                              ! Flag for first output
    real(DP), pointer:: var_avr_coefsum(:) =>null()
                              ! ѿλʿѤκݤηι. 
                              ! 
                              ! Summation of coefficients for integral 
                              ! of time-averaged value of each variable
    real(DP), pointer:: var_avr_baseint(:) =>null()
                              ! ѿλʿͽϤΤδֳִܻ. 
                              ! 
                              ! Basic interval of time for output
                              ! of time-averaged value of each variable
    real(DP), pointer:: var_avr_prevtime(:) =>null()
                              ! ѿλʿͽϤΤλݴ. 
                              ! 
                              ! Store keeping of previous time for output
                              ! of time-averaged value of each variable
    real(DP):: time_bnds(1:2) = 0.0_DP
                              ! "time_bnds" ѿ˽Ϥǡ. 
                              ! 
                              ! Data that is to be output in "time_bnds" 
                              ! variable
    integer:: time_bnds_output_count = 0
                              ! "time_bnds" ѿ˽Ϥ줿. 
                              ! 
                              ! Number of output in "time_bnds" variable
    integer:: time_nv_index = 0
                              ! time_nv  ID. 
                              ! ID of dimension "time_nv"

    ! MPI Ϣѿ
    ! Variables for MPI
    !
    integer:: mpi_myrank = -1
                              ! MPI ˤΡֹ. Node number of MPI
    integer:: mpi_nprocs = -1
                              ! MPI ˤΡɿ. Number of all nodes of MPI
    logical:: mpi_gather = .false.
                              ! ե礷ƽϤե饰.
                              ! Flag for integration of files
    logical:: mpi_split = .false.
                              ! եʬ䤷ƽϤե饰.
                              ! Flag for split of files
    type(GT_HISTORY_MPIFILEINFO), pointer:: mpi_fileinfo =>null()
                              ! ե˴ؤ
                              ! Information about file
    type(GT_HISTORY_MPIAXISDATA), pointer:: mpi_dimdata_all(:) =>null()
                              ! Τμǡݴɤ뤿. 
                              ! Array for keeping data of axes in whole area. 
    type(GT_HISTORY_MPIAXISDATA), pointer:: mpi_dimdata_each(:) =>null()
                              ! ġΥΡɤǤμǡݴɤ뤿. 
                              ! Array for keeping data of axes on each node. 
    type(GT_HISTORY_MPIAXISINFO), pointer:: mpi_gthr_info(:) =>null()
                              ! ǡս˽󤹤ݤɬפʾ. 
                              ! Information for integration of data. 
    type(GT_HISTORY_VARINFO), pointer:: mpi_varinfo(:) =>null()
                              ! ѿ. 
                              ! Information of variables
    type(GT_HISTORY_MPIVARINDEX), pointer:: mpi_vars_index(:) =>null()
                              ! ѿź. 
                              ! Indexes of array of each variable
  end type GT_HISTORY

  type GT_HISTORY_AVRDATA
    !
    ! ʿͤϤ뤿Υǡݴ. 
    !
    ! Array for temporary keeping data for time average value output. 
    !
    real(DP), pointer:: a_DataAvr(:) =>null()
    integer:: length
  end type GT_HISTORY_AVRDATA

  type(GT_HISTORY), save, target:: default  ! history ̤ξ˻

  type GT_HISTORY_AXIS
    !
    !== ɸǼ빽¤
    !
    ! ηѿ HistoryAxisCreate, HistoryAxisCopy, HistoryInquire
    ! ˤäƽꤵɬפޤ
    ! 塢HistoryCreate  *axes* Ϳޤ
    !
    ! 䤤碌 HistoryAxisInquire ˤäƹԤޤ
    ! °ղä HistoryAxisAddAttr ˤäƹԤޤ
    !  HistoryAxisClear ˤäƹԤޤ
    !
    ! This type may be used as a argument *axes* of HistoryCreate
    ! to define features of axes of a history dataset.
    ! Typically, a constant array of this type will be used for
    ! fixed specification.
    !
    character(TOKEN) :: name     = "" ! ѿ̾
    integer          :: length   = 0  ! Ĺ (󥵥)
    character(STRING):: longname = "" ! ѿεŪ̾
    character(STRING):: units    = "" ! ѿñ
    character(TOKEN) :: xtype    = "" ! ѿη
    type(GT_HISTORY_ATTR), pointer:: attrs(:) =>null() ! °
  end type GT_HISTORY_AXIS


  type GT_HISTORY_VARINFO
    !
    !== ѿǼ빽¤
    !
    ! ηѿ HistoryVarinfoCreate, HistoryVarinfoCopy,
    ! HistoryInquire
    ! ˤäƽꤵɬפޤ
    ! 塢HistoryAddVariable  *varinfo* Ϳޤ
    !
    ! 䤤碌 HistoryVarinfoInquire ˤäƹԤޤ
    ! °ղä HistoryVarinfoAddAttr ˤäƹԤޤ
    !  HistoryVarinfoClear ˤäƹԤޤ
    !
    ! This type may be used as a argument *varinfo* of
    ! HistoryAddVariable
    ! to define features of variable of a history dataset.
    !
    character(TOKEN)          :: name     = ""     ! ѿ̾
    character(TOKEN), pointer :: dims(:)  =>null() ! ¸뼡
    character(STRING)         :: longname = ""     ! ѿεŪ̾
    character(STRING)         :: units    = ""     ! ѿñ
    character(TOKEN)          :: xtype    = ""     ! ѿη
    type(GT_HISTORY_ATTR), pointer:: attrs(:) =>null() ! °
    logical:: time_average = .false.               ! ʿ
    logical:: initialized = .false.
                              ! ե饰. 
                              ! Initialization flag
  end type GT_HISTORY_VARINFO

  type GT_HISTORY_ATTR
    !
    ! ѿ°ι¤. ȤϤ, GT_HISTORY_VARINFO
    !  GT_HISTORY_AXIS 񤵤Ѥ뤳Ȥ
    ! ꤷƤ. ľŪˤι¤ΤѿˤȤ
    ! ֥롼 gtool_history_internal ⥸塼
    ! gtool_history_internal#append_attrs  
    ! gtool_history_internal#copy_attrs .
    !
    character(TOKEN)    :: attrname  ! °̾
    character(TOKEN)    :: attrtype  ! °ͤη
    logical             :: array = .false. ! °ͤ󤫤ɤ
    character(STRING)   :: Charvalue    ! ° (ʸѿ)
    integer       :: Intvalue    ! ° (ѿ)
    real            :: Realvalue    ! ° (ñټ¿ѿ)
    real(DP)            :: Doublevalue    ! ° (ټ¿ѿ)
    logical             :: Logicalvalue    ! ° (ѿ)
    integer ,pointer:: Intarray(:) =>null() ! ° ()
    real ,pointer:: Realarray(:) =>null() ! ° (ñټ¿)
    real(DP) ,pointer:: Doublearray(:) =>null() ! ° (ټ¿)
  end type GT_HISTORY_ATTR

  type GT_HISTORY_MPIFILEINFO
    !
    ! MPI ѻ, ե˽񤭽Фܾ. 
    ! (ƥΡɾΥǡ礷ưĤΥե˽Ϥݤ˻)
    !
    ! Basic information output to a file  when MPI is used. 
    ! (This is used when data on each node is integrated and output to one file )
    !
    logical:: already_output = .false.
    type(GT_HISTORY_AXIS), pointer:: axes(:) =>null()
    logical:: overwrite
    character(STRING):: file
    character(STRING):: title
    character(STRING):: source
    character(STRING):: institution
    character(STRING):: conventions
    character(TOKEN):: gt_version
    logical:: gtver_add
    logical:: quiet
    character(STRING):: nc_history
  end type GT_HISTORY_MPIFILEINFO

  type GT_HISTORY_MPIAXISDATA
    !
    ! MPI ѻ, ǡݴɤ뤿. 
    !
    ! Array for keeping data of axes when MPI is used. 
    !
    real(DP), pointer:: a_Axis(:) =>null()
    integer:: length = -1
    type(GT_HISTORY_ATTR), pointer:: attrs(:) =>null()
                              ! ɸ° (HistoryCreate2 ƤФ줿˻) 
                              ! Attributes of axes (this is used when HistoryCreate2 is used)
  end type GT_HISTORY_MPIAXISDATA

  type GT_HISTORY_MPIAXISINFO
    !
    ! MPI ѻ, ǡս˽󤹤ݤɬפʾ. 
    !
    ! Information for integration of data when MPI is used. 
    !
    integer, pointer:: index_all(:,:) =>null()
    integer, pointer:: length(:) =>null()
  end type GT_HISTORY_MPIAXISINFO

  type GT_HISTORY_MPIVARINDEX
    !
    ! MPI ѻ, ǡս˽󤹤ݤɬפʾ. 
    !
    ! Information for integration of data when MPI is used. 
    !
    integer, pointer:: each2all(:,:) =>null()
    integer, pointer:: allcount(:) =>null()
    integer:: allcount_all = 0
  end type GT_HISTORY_MPIVARINDEX

end module gtool_history_types
