!= spline_data ⥸塼Υƥȥץ
!
!= Test program for "spline_data"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: spline_data_test.f90,v 1.2 2007/09/21 13:50:05 morikawa Exp $
! Tag Name::  $Name: dcpam4-20071012 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! spline_data ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "spline_data" module.
! Confirm compilation and execution of this program.
!

program spline_data_test
  use spline_data, only: SPLDAT, Create, Close, &
    & PutLine, initialized, GetSpline
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: GT_HISTORY, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
    & HistoryGet
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'spline_data_test $Name: dcpam4-20071012 $ :: ' // &
    & 'Test program of "spline_data" module'
  character(*), parameter:: source = &
    & 'dcmodel project: hierarchical numerical models ' // &
    & '(See http://www.gfd-dennou.org/library/dcmodel)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: jmax = 64
                              ! ٳʻ. 
                              ! Number of grid points in latitude

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), allocatable:: y_Lat (:) ! . Latitude

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP), allocatable:: y_Data (:)
  real(DP), allocatable:: y_DataAns (:)

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(SPLDAT):: spl_dat00, spl_dat01, spl_dat02, spl_dat03
  type(GT_HISTORY):: gthist
  logical:: err
  character(*), parameter:: subname = 'spline_data_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './spline_data_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = 'NAMELIST filename' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( spl_dat = spl_dat00, & ! (inout)
    & knots_num = 13, &
    & x_knots = &
    &   (/ -90.0_DP, -75.0_DP, -60.0_DP, -45.0_DP, -30.0_DP, -15.0_DP, &
    &        0.0_DP,  15.0_DP,  30.0_DP,  45.0_DP,  60.0_DP,  75.0_DP, &
    &       90.0_DP /), &             ! (in)
    & x_value = &
    &   (/  0.0_DP,  7.0_DP, 18.0_DP, 25.0_DP, 17.0_DP,   3.0_DP, &
    &     -25.0_DP, 10.0_DP, 48.0_DP, 20.0_DP,  8.0_DP, -15.0_DP, &
    &       0.0_DP /) )               ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(spl_dat00) )
  call PutLine( spl_dat = spl_dat00 ) ! (in)

  !---------------------------------------------------------
  !  ǡ
  !  Configure axis data
  !---------------------------------------------------------
  allocate( y_Lat (0:jmax-1) )
  allocate( y_Data (0:jmax-1) )
  y_Lat = &
    & (/ -87.8638,  -85.09653, -82.31291, -79.5256,  -76.7369,  &
    &    -73.94752, -71.15775, -68.36776, -65.57761, -62.78735, &
    &    -59.99702, -57.20663, -54.4162,  -51.62573, -48.83524, &
    &    -46.04473, -43.2542,  -40.46365, -37.67309, -34.88252, &
    &    -32.09195, -29.30136, -26.51077, -23.72017, -20.92957, &
    &    -18.13897, -15.34836, -12.55776,  -9.767145, -6.976533, &
    &     -4.185921, -1.395307,  1.395307,  4.185921,  6.976533, &
    &      9.767145, 12.55776,  15.34836,  18.13897,  20.92957, &
    &     23.72017,  26.51077,  29.30136,  32.09195,  34.88252, &
    &     37.67309,  40.46365,  43.2542,   46.04473,  48.83524, &
    &     51.62573,  54.4162,   57.20663,  59.99702,  62.78735, &
    &     65.57761,  68.36776,  71.15775,  73.94752,  76.7369, &
    &     79.5256,   82.31291,  85.09653,  87.8638 /)

  !---------------------------------------------------------
  !  GetSpline Υ顼γǧ
  !  Confirm error handling of "GetSpline"
  !---------------------------------------------------------
  call GetSpline( spl_dat = spl_dat00 , &
    & a_Dim = y_Lat(0:jmax-5), & ! (in)
    & a_Data = y_Data, &         ! (out)
    & err = err )                ! (out)

  call AssertEqual( 'GetSpline error handling test 1', &
    & answer = .true., check = err )

  call GetSpline( spl_dat = spl_dat00 , &
    & a_Dim = y_Lat(0:10), &     ! (in)
    & a_Data = y_Data(0:10), &   ! (out)
    & err = err )                ! (out)

  call AssertEqual( 'GetSpline error handling test 2', &
    & answer = .true., check = err )


  !---------------------------------------------------------
  !  ץ饤ǡκ
  !  Generate spline curve data
  !---------------------------------------------------------
  call GetSpline( spl_dat = spl_dat00 , &
    & a_Dim = y_Lat, &  ! (in)
    & a_Data = y_Data ) ! (out)

!!$  !----------------------------------------------------------------
!!$  !  ǡ
!!$  !  Output data
!!$  !----------------------------------------------------------------
!!$  call HistoryCreate( &
!!$    & history = gthist, &                           ! (out)
!!$    & file = 'spline_data_test00.nc', &             ! (in)
!!$    & title = title, &                              ! (in)
!!$    & source = source, institution = institution, & ! (in)
!!$    & dims = StoA('lat'), &                         ! (in)
!!$    & dimsizes = (/jmax/), &                        ! (in)
!!$    & longnames = StoA('latitude'), &               ! (in)
!!$    & units = StoA('degree_north') )                ! (in)
!!$
!!$  call HistoryPut( &
!!$    & history = gthist, &              ! (inout)
!!$    & varname = 'lat', array = y_Lat ) ! (in)
!!$
!!$  call HistoryAddVariable( &
!!$    & history = gthist, &             ! (inout)
!!$    & varname = 'Data', &           ! (in)
!!$    & dims = StoA('lat'), &           ! (in)
!!$    & longname = 'Any quantity', &    ! (in)
!!$    & units = '1', xtype = 'double' ) ! (in)
!!$
!!$  call HistoryPut( &
!!$    & history = gthist, &                ! (inout)
!!$    & varname = 'Data', array = y_Data ) ! (in)
!!$
!!$  call HistoryClose( history = gthist ) ! (inout)


  !---------------------------------------------------------
  !  μ
  !  Get correct answer
  !---------------------------------------------------------
  allocate( y_DataAns (0:jmax-1) )

  call HistoryGet( &
    & file = 'spline_data_test00.nc', & ! (in)
    & varname = 'Data', &               ! (in)
    & array = y_DataAns )               ! (out)

  call AssertEqual( 'spline curve data generation test 1', &
    & answer = y_DataAns, check = y_Data, &
    & significant_digits = 15, ignore_digits = -15 )

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( spl_dat = spl_dat00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(spl_dat00) )
  call PutLine( spl_dat = spl_dat00 ) ! (in)

  call Close( spl_dat = spl_dat02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )

end program spline_data_test
