*-----------------------------------------------------------------------
*   TEST PROGRAM FOR MAP PROJECTION  ( radial coordinate )
*-----------------------------------------------------------------------
*     TEST FOR PLOTTING VECTORS
*
*
      write(*,*) ' rleng (real)?'
      read (*,*) rleng
*
      CALL GLPSET('LEPSL', .TRUE.)

      CALL SUPWSN(6)
      READ (5,*) IWS
      CALL SGOPN(IWS)

      CALL TSTMAP(rleng,1)
      CALL TSTMAP(rleng,2)
      CALL TSTMAP(rleng,3)

      CALL SGCLS
      STOP
      END
*------------------------------------------------------------------------
      SUBROUTINE TSTMAP( rleng, iarlen)
      CHARACTER CTITLE*80

      rmax = 0.03
      scale = 1.0 / rmax / 2

      CALL SGSCLP(0)
      CALL SGFRM
      CALL SGSVPT( 0.1, 0.9, 0.1, 0.9)
      CALL SGSOTG( scale, 0., 0. )
      CALL SGSTRN(5)
      CALL SUPVPR(1)
      ctitle(1:40) = 'polar coordinate?'
      CALL SGTXZV(0.5, 0.92, ctitle(1:40), 0.028, 0, 0, 3)
      CALL SGSCLP(1)
      CALL SGPSET('LLNINT',.TRUE.)
      CALL SGPSET('LGCINT',.TRUE.)

      CALL Dmesh ( 0.0, rmax , 0.0, 360., 10, 12 )

      CALL DVECT ( 15 , 18, rmax, rleng, iarlen )

      return
      END

*======================================================================
      SUBROUTINE DVECT ( ndx, ndy, rmax, rleng, iarlen )
      PARAMETER ( PI = 3.1415926, CP = PI/180)
      parameter ( mx = 100, my = 100 )
*------------------------------------------------------
      dimension x(1000), y(1000)
      dimension vectx(mx,my)
      dimension vecty(mx,my)
*
      DO 100 i=1, NDx
      DO 100 j=1, NDy+1
         X(i) = (i-1)* rmax /NDx 
         Y(j) = (j-1)*360./NDy 
 100  CONTINUE
*
      call uwsgxa( x, ndx )
      call uwsgya( y, ndy+1 )
*
      DO 200 i=1, NDx
      DO 200 j=1, NDy+1
         vectx(i,j) = rleng * x(i)
         vecty(i,j) = rleng * x(i) 
 200  CONTINUE
*
      IND = 1

      call uvpset ( 'LUNIT', .true. )
      call glpset ( 'LMISS', .true. )
      call uvpset ( 'lnrmal', .true. )
      call uvpset ( 'LMSG', .false. )
      call uvpset ( 'LUMSG', .true. )
      call uvpset ( 'INDEX', 1 )
      call uvpset ( 'IARLEN', iarlen )
      call uvpset ( 'icent', 0 )

      CALL uvVECT( VECTX, mx, VECTY, mx, ndx, ndy+1 )
*
      RETURN
      END

