*-----------------------------------------------------------------------
*     Copyright (C) 2000 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      SUBROUTINE SGSTRF

      LOGICAL   LDEG

      EXTERNAL  RFPI


      CALL SGLGET('LDEG',LDEG)
      CALL SGIGET('ITR',ITR)

      IF (LDEG) THEN
        CP = RFPI()/180
      ELSE
        CP = 1
      END IF

*     / VIEW PORT /

      CALL SGQVPT(VXMIN, VXMAX, VYMIN, VYMAX)

      IF (.NOT.(VXMIN.LT.VXMAX .AND. VYMIN.LT.VYMAX)) THEN
        CALL MSGDMP('E','SGSTRF','VIEWPORT DEFINITION IS INVALID.')
      END IF

      CALL SZSCLL(VXMIN,VXMAX,VYMIN,VYMAX,1)

      IF (1.LE.ITR .AND. ITR.LE.4) THEN

*       / LINEAR AND LOG /

        CALL SGQWND(UXMIN, UXMAX, UYMIN, UYMAX)

        IF (ITR.LE.2) THEN
          CX  = (VXMAX-VXMIN) / (UXMAX-UXMIN)
          VX0 = VXMIN - CX*UXMIN
        ELSE
          IF (UXMIN.LE.0 .OR. UXMAX.LE.0) THEN
            CALL MSGDMP('E','SGSTRF',
     +           'NEGATIVE REGION EXISTS FOR LOG TRANSFORMATION (X).')
          END IF
          CX = (VXMAX-VXMIN) / LOG10(UXMAX/UXMIN)
          VX0 = VXMIN - CX*LOG10(UXMIN)
        END IF

        IF (MOD(ITR,2).EQ.1) THEN
          CY = (VYMAX-VYMIN) / (UYMAX-UYMIN)
          VY0 = VYMIN - CY*UYMIN
        ELSE
          IF (UYMIN.LE.0 .OR. UYMAX.LE.0) THEN
            CALL MSGDMP('E','SGSTRF',
     +           'NEGATIVE REGION EXISTS FOR LOG TRANSFORMATION (Y).')
          END IF
          CY = (VYMAX-VYMIN) / LOG10(UYMAX/UYMIN)
          VY0 = VYMIN - CY*LOG10(UYMIN)
        END IF

        CALL STSRAD(.FALSE., .FALSE.)
        CALL STSTRF(.FALSE.)
        CALL STSTRN(ITR, CX, CY, VX0, VY0)

      ELSE IF (5.LE.ITR .AND. ITR.LE.6) THEN

*       / ORTHOGONAL CURVE /

        CALL SGQSIM(SIMFAC, VXOFF, VYOFF)

        VX0 = (VXMAX + VXMIN)/2 + VXOFF
        VY0 = (VYMAX + VYMIN)/2 + VYOFF

        CALL STSRAD(LDEG .AND. (ITR.EQ.6),
     +              LDEG .AND. (ITR.EQ.5 .OR. ITR.EQ.6))
        CALL STSTRF(.FALSE.)
        CALL STSTRN(ITR, SIMFAC, SIMFAC, VX0, VY0)

      ELSE IF (10.LE.ITR .AND. ITR.LE.15 .OR.
     +         20.LE.ITR .AND. ITR.LE.23 .OR.
     +         30.LE.ITR .AND. ITR.LE.33 ) THEN

*       / MAP /

        CALL SGQSIM(SIMFAC, VXOFF, VYOFF)
        CALL SGQMPL(PLX, PLY, PLROT)

        VX0 = (VXMAX + VXMIN)/2 + VXOFF
        VY0 = (VYMAX + VYMIN)/2 + VYOFF

        CALL STSRAD(LDEG, LDEG)
        CALL STSROT(RFPI()/2 - CP*PLY, CP*PLX, CP*PLROT)
        CALL STSTRF(.TRUE.)
        CALL STSTRN(ITR, SIMFAC, SIMFAC, VX0, VY0)

*       / SET CLIPPING REGION /

        CALL SGQTXY(TXMIN, TXMAX, TYMIN, TYMAX)
        CALL SZSCLX(CP*TXMIN, CP*TXMAX)
        CALL SZSCLY(CP*TYMIN, CP*TYMAX)

*       / SATELITE VIEW /

        CALL SGRGET('RSAT',RSAT)
        CALL MPSOTG(RSAT)

*       / SET STANDARD LATITUDE /

        CALL SGRGET('STLAT1',STLAT1)
        CALL SGRGET('STLAT2',STLAT2)

        IF (ITR.EQ.20) THEN
          CALL MPSCON(CP * STLAT1)
        ELSE IF (ITR.EQ.21) THEN
          CALL MPSCOA(CP * STLAT1)
        ELSE IF (ITR.EQ.22) THEN
          CALL MPSCOC(CP*STLAT1, CP*STLAT2)
        ELSE IF (ITR.EQ.23) THEN
          CALL MPSBON(CP * STLAT1)
        END IF

      ELSE IF (ITR.EQ.99) THEN

        CALL STSUSR

      ELSE

        CALL MSGDMP('E','SGSTRF',
     +       'TRANSFORMATION FUNCTION NUMBER IS INVALID.')

      END IF

      END
