*-----------------------------------------------------------------------
*     UZPQNP / UZPQID / UZPQCP / UZPQVL / UZPSVL / UZPSAV / UZPRST
*-----------------------------------------------------------------------
      SUBROUTINE UZPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA=68)
      PARAMETER (IUNDEF=-999,RUNDEF=-999)

      INTEGER   IX(NPARA)
      REAL      RX(NPARA)
      LOGICAL   LX(NPARA),LCHREQ,LFIRST
      CHARACTER CPARA(NPARA)*8,CMSG*80

      EQUIVALENCE (IX,RX,LX)

      EXTERNAL  LCHREQ,LENC,IUFOPN

      SAVE

      DATA      CPARA( 1)/'UXUSER  '/, RX( 1)/RUNDEF/
      DATA      CPARA( 2)/'UYUSER  '/, RX( 2)/RUNDEF/

      DATA      CPARA( 3)/'ROFFXB  '/, RX( 3)/0/
      DATA      CPARA( 4)/'ROFFXT  '/, RX( 4)/0/
      DATA      CPARA( 5)/'ROFFXU  '/, RX( 5)/0/
      DATA      CPARA( 6)/'ROFFYL  '/, RX( 6)/0/
      DATA      CPARA( 7)/'ROFFYR  '/, RX( 7)/0/
      DATA      CPARA( 8)/'ROFFYU  '/, RX( 8)/0/

      DATA      CPARA( 9)/'ROFGXB  '/, RX( 9)/0/
      DATA      CPARA(10)/'ROFGXT  '/, RX(10)/0/
      DATA      CPARA(11)/'ROFGXU  '/, RX(11)/0/
      DATA      CPARA(12)/'ROFGYL  '/, RX(12)/0/
      DATA      CPARA(13)/'ROFGYR  '/, RX(13)/0/
      DATA      CPARA(14)/'ROFGYU  '/, RX(14)/0/

      DATA      CPARA(15)/'LABELXB '/, LX(15)/.TRUE./
      DATA      CPARA(16)/'LABELXT '/, LX(16)/.FALSE./
      DATA      CPARA(17)/'LABELXU '/, LX(17)/.TRUE./
      DATA      CPARA(18)/'LABELYL '/, LX(18)/.TRUE./
      DATA      CPARA(19)/'LABELYR '/, LX(19)/.FALSE./
      DATA      CPARA(20)/'LABELYU '/, LX(20)/.TRUE./

      DATA      CPARA(21)/'IROTLXB '/, IX(21)/0/
      DATA      CPARA(22)/'IROTLXT '/, IX(22)/0/
      DATA      CPARA(23)/'IROTLXU '/, IX(23)/0/
      DATA      CPARA(24)/'IROTLYL '/, IX(24)/0/
      DATA      CPARA(25)/'IROTLYR '/, IX(25)/0/
      DATA      CPARA(26)/'IROTLYU '/, IX(26)/0/

      DATA      CPARA(27)/'IROTCXB '/, IX(27)/0/
      DATA      CPARA(28)/'IROTCXT '/, IX(28)/0/
      DATA      CPARA(29)/'IROTCXU '/, IX(29)/0/
      DATA      CPARA(30)/'IROTCYL '/, IX(30)/+1/
      DATA      CPARA(31)/'IROTCYR '/, IX(31)/+1/
      DATA      CPARA(32)/'IROTCYU '/, IX(32)/+1/

      DATA      CPARA(33)/'ICENTXB '/, IX(33)/0/
      DATA      CPARA(34)/'ICENTXT '/, IX(34)/0/
      DATA      CPARA(35)/'ICENTXU '/, IX(35)/0/
      DATA      CPARA(36)/'ICENTYL '/, IX(36)/+1/
      DATA      CPARA(37)/'ICENTYR '/, IX(37)/+1/
      DATA      CPARA(38)/'ICENTYU '/, IX(38)/+1/

      DATA      CPARA(39)/'INDEXT0 '/, IX(39)/IUNDEF/
      DATA      CPARA(40)/'INDEXT1 '/, IX(40)/1/
      DATA      CPARA(41)/'INDEXT2 '/, IX(41)/3/

      DATA      CPARA(42)/'INDEXL0 '/, IX(42)/IUNDEF/
      DATA      CPARA(43)/'INDEXL1 '/, IX(43)/3/
      DATA      CPARA(44)/'INDEXL2 '/, IX(44)/3/

      DATA      CPARA(45)/'RSIZET0 '/, RX(45)/RUNDEF/
      DATA      CPARA(46)/'RSIZET1 '/, RX(46)/0.007/
      DATA      CPARA(47)/'RSIZET2 '/, RX(47)/0.014/

      DATA      CPARA(48)/'RSIZEL0 '/, RX(48)/RUNDEF/
      DATA      CPARA(49)/'RSIZEL1 '/, RX(49)/0.021/
      DATA      CPARA(50)/'RSIZEL2 '/, RX(50)/0.028/

      DATA      CPARA(51)/'RSIZEC0 '/, RX(51)/RUNDEF/
      DATA      CPARA(52)/'RSIZEC1 '/, RX(52)/0.028/
      DATA      CPARA(53)/'RSIZEC2 '/, RX(53)/0.035/

      DATA      CPARA(54)/'LOFFSET '/, LX(54)/.FALSE./
      DATA      CPARA(55)/'XOFFSET '/, RX(55)/0.0/
      DATA      CPARA(56)/'YOFFSET '/, RX(56)/0.0/
      DATA      CPARA(57)/'XFACT   '/, RX(57)/1.0/
      DATA      CPARA(58)/'YFACT   '/, RX(58)/1.0/

      DATA      CPARA(59)/'PAD1    '/, RX(59)/0.7/
      DATA      CPARA(60)/'PAD2    '/, RX(60)/1.5/
      DATA      CPARA(61)/'IFLAG   '/, IX(61)/-1/
      DATA      CPARA(62)/'LBTWN   '/, LX(62)/.FALSE./
      DATA      CPARA(63)/'RBTWN   '/, RX(63)/0.0/
      DATA      CPARA(64)/'LBOUND  '/, LX(64)/.FALSE./
      DATA      CPARA(65)/'LBMSG   '/, LX(65)/.TRUE./
      DATA      CPARA(66)/'INNER   '/, IX(66)/+1/

      DATA      CPARA(67)/'IUNDEF  '/, IX(67)/IUNDEF/
      DATA      CPARA(68)/'RUNDEF  '/, RX(68)/RUNDEF/

      DATA      LFIRST/.TRUE./


      NCP=NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY UZPQID(CP,IDX)

      DO 10 N=1,NPARA
        IF (LCHREQ(CP,CPARA(N))) THEN
          IDX=N
          RETURN
        END IF
   10 CONTINUE
      CMSG='PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','UZPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY UZPQCP(IDX,CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP=CPARA(IDX)
      ELSE
        CALL MSGDMP('E','UZPQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UZPQVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UZ:',CPARA,IX,NPARA-2)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA=IX(IDX)
      ELSE
        CALL MSGDMP('E','UZPQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UZPSVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UZ:',CPARA,IX,NPARA-2)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA-2) THEN
        IX(IDX)=IPARA
      ELSE
        CALL MSGDMP('E','UZPSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UZPSAV

      IU=IUFOPN()
      OPEN(UNIT=IU,FORM='UNFORMATTED',STATUS='SCRATCH')
      REWIND(IU)

      WRITE(UNIT=IU,IOSTAT=IOS) IX
      IF (IOS.NE.0) THEN
        CALL MSGDMP('E','UZPSAV','IOSTAT IS NOT ZERO.')
      END IF
      REWIND(IU)

      RETURN
*-----------------------------------------------------------------------
      ENTRY UZPRST

      READ(UNIT=IU,IOSTAT=IOS) IX
      IF (IOS.NE.0) THEN
        CALL MSGDMP('E','UZPRST','IOSTAT IS NOT ZERO.')
      END IF
      REWIND(IU)

      RETURN
      END
