*-----------------------------------------------------------------------
*     ULPQNP / ULPQID / ULPQCP / ULPQVL / ULPSVL
*-----------------------------------------------------------------------
      SUBROUTINE ULPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA=4)

      INTEGER   IX(NPARA)
      REAL      RX(NPARA)
      LOGICAL   LX(NPARA),LCHREQ,LFIRST
      CHARACTER CPARA(NPARA)*8,CMSG*80

      EQUIVALENCE (IX,RX,LX)

      EXTERNAL  LCHREQ,LENC

      SAVE

      DATA      CPARA( 1)/'IXCHR   '/, IX( 1)/195/
      DATA      CPARA( 2)/'IYCHR   '/, IX( 2)/195/
      DATA      CPARA( 3)/'IXTYPE  '/, IX( 3)/1/
      DATA      CPARA( 4)/'IYTYPE  '/, IX( 4)/1/

*     IXCHR /IYCHR  : CHARACTER NUMBER OF * FOR 5*10E1 IN X/Y-AXIS
*     IXTYPE/IXTYPE : 1-4  1 ... 10|2" 2*10|2" 5*10|2" 10|3"  ETC
*                          2 ... 10|2" 2       5       10|3"  ETC
*                          3 ... 100   200     500     1000   ETC
*                          4 ... 100   2       5       1000   ETC
*               FORMAT FOR 3 OR 4 DEPENDS ON THAT SET BY ULSFMT

      DATA      LFIRST/.TRUE./


      NCP=NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY ULPQID(CP,IDX)

      DO 10 N=1,NPARA
        IF (LCHREQ(CP,CPARA(N))) THEN
          IDX=N
          RETURN
        END IF
   10 CONTINUE
      CMSG='PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','ULPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY ULPQCP(IDX,CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP=CPARA(IDX)
      ELSE
        CALL MSGDMP('E','ULPQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY ULPQVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UL:',CPARA,IX,NPARA)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA=IX(IDX)
      ELSE
        CALL MSGDMP('E','ULPQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY ULPSVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UL:',CPARA,IX,NPARA)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IX(IDX)=IPARA
      ELSE
        CALL MSGDMP('E','ULPSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
      END
