*-----------------------------------------------------------------------
      SUBROUTINE CIFLAB(X, Y, Z, UL, A, B)

      PARAMETER (XN=98.072, YN=100., ZN=118.225 )
      PARAMETER (THRS=0.008856, C=16./116.)


      X0 = X/XN
      Y0 = Y/YN
      Z0 = Z/ZN

      IF (X0.LE.THRS .OR. Y0.LE.THRS .OR. Z0.LE.THRS) THEN
        XX = 7.787*X0 + C
        YY = 7.787*Y0 + C
        ZZ = 7.787*Z0 + C
      ELSE
        XX = X0**(1./3.)
        YY = Y0**(1./3.)
        ZZ = Z0**(1./3.)
      END IF

      UL = 116.*YY - 16.
      A  = 500.*(XX-YY)
      B  = 200.*(YY-ZZ)

      END
