program traj_sample
! 解析的な速度場データから流跡線を計算する.
  use Math_Const
  use Trajectory

  implicit none

  integer :: i, j, k, dnum
  integer, parameter :: nx=100, ny=100    ! 水平格子点数
  integer, parameter :: nt=10             ! 速度場データの時間間隔
  integer, parameter :: tstep=200         ! 流線の計算ステップ
  real, dimension(nx,ny,nt) :: u, v       ! 前方計算用の風データ
  real, dimension(nx,ny,nt) :: ru, rv     ! 後方計算用の風データ
  real, dimension(tstep,1) :: tx, ty      ! 流線の x, y 座標
  real :: x(nx), y(ny), t(nt), rt(nt)     ! 時空間座標
  real, parameter :: xmin=-pi, xmax=pi    ! x 軸の領域 
  real, parameter :: ymin=-pi, ymax=pi    ! y 軸の領域
  real, parameter :: tmin=0.0, tmax=pi    ! t 軸の領域
  real :: dtstep                          ! 流線の計算時間間隔
  real :: dx, dy, dt                      ! 格子解像度
  character(3) :: sche
  logical :: FTF(1)

  dx=(xmax-xmin)/(nx-1)
  dy=(ymax-ymin)/(ny-1)
  dt=(tmax-tmin)/(nt-1)
  dtstep=(tmax-tmin)/(tstep-1)

  x=(/((xmin+dx*(i-1)),i=1,nx)/)
  y=(/((ymin+dy*(i-1)),i=1,ny)/)
  t=(/((tmin+dt*(i-1)),i=1,nt)/)
  rt=(/((tmax-dt*(i-1)),i=1,nt)/)

  tx(1,1)=0.1
  ty(1,1)=0.1

  write(*,*) "input scheme of time integration."
  write(*,*) "EU1 or RK4."
  read(*,*) sche

  write(*,*) "input direction of trajectory for time."
  write(*,*) "1 = Forward, 2 = Backward."
  read(*,*) dnum

  do k=1,nt
     do j=1,ny
        do i=1,nx
           u(i,j,k)=cos(t(k))  ! 解析的な速度場を与える.
           v(i,j,k)=sin(t(k))  ! 解析的な速度場を与える.
           ru(i,j,k)=cos(rt(k))  ! 解析的な速度場を与える.
           rv(i,j,k)=sin(rt(k))  ! 解析的な速度場を与える.
!           u(i,j,k)=sin(x(i))+sin(y(j))+sin(t(k))  ! 解析的な速度場を与える.
!           v(i,j,k)=sin(x(i))+sin(y(j))+sin(t(k))  ! 解析的な速度場を与える.
!           ru(i,j,k)=sin(x(i))+sin(y(j))+sin(rt(k))  ! 解析的な速度場を与える.
!           rv(i,j,k)=sin(x(i))+sin(y(j))+sin(rt(k))  ! 解析的な速度場を与える.
        end do
     end do
  end do

  select case (dnum)
  case (1)
  call Forward_Traject_2d(  &
  &                    dtstep,  &            ! 時間間隔
  &                    tmin,  &              ! 開始時間
  &                    tstep,  &             ! 時間ステップ
  &                    tx(1:1,1),  &       ! パーセルの初期位置 x 座標
  &                    ty(1:1,1),  &       ! パーセルの初期位置 y 座標
  &                    t, x, y,  &           ! x, y 座標値
  &                    u, v,  &              ! x, y の各点で定義されている速度場
  &                    tx(:,1:1), ty(:,1:1),  &  ! 実際の流線の軌跡
  &                    FTF(1:1),  &          ! 流線が計算領域外に出たかの判別
  &                    opt=trim(sche) )      ! 時間スキーム
  case (2)
  ! 後方の場合, 時刻, 速度場データは全て逆向きの時間で配列格納されている.
  call Backward_Traject_2d(  &
  &                    dtstep,  &            ! 時間間隔
  &                    tmax,  &              ! 開始時間
  &                    tstep,  &             ! 時間ステップ
  &                    tx(1:1,1),  &       ! パーセルの初期位置 x 座標
  &                    ty(1:1,1),  &       ! パーセルの初期位置 y 座標
  &                    rt, x, y,  &          ! x, y 座標値
  &                    ru, rv,  &            ! x, y の各点で定義されている速度場
  &                    tx(:,1:1), ty(:,1:1),  &  ! 実際の流線の軌跡
  &                    FTF(1:1),  &          ! 流線が計算領域外に出たかの判別
  &                    opt=trim(sche) )      ! 時間スキーム
  end select

  open(unit=10,file='traj_sample.dat',status='unknown')
     write(10,*) "x ", "y"
     write(10,*) "x ", "y"
     do i=1,tstep
        write(10,*) tx(i,1), ty(i,1)
     end do
  close(unit=10)

end program
