program read_mgdsst_nc
  ! mgdsst のオリジナルデータを GrADS or NetCDF 形式に変換するプログラム
  ! sst_list に作るデータファイルを書き込めば, 自動で作成する.

  use file_operate
  use gtool_history

  implicit none
  integer, parameter :: nx=1440  ! mgdsst longtitude
  integer, parameter :: ny=720   ! mgdsst latitude
  real, parameter :: dlon=0.25  ! resolution of longtitude
  real, parameter :: dlat=0.25  ! resolution of latitude
  real, parameter :: lonmin=0.125  ! data start point (long)
  real, parameter :: latmin=-89.875  ! data start point (lat)
  real, parameter :: undef=999.0, undefc=-1.0e35
  real, dimension(nx,ny) :: sst
  real :: lon(nx), lat(ny)
  character(80), parameter :: dat_name='sst_list'
  character(80), allocatable, dimension(:) :: dat_list
  integer :: dat_line
  character(10) :: formatt
  integer :: i, j, k, dtype
  real, parameter :: cmin=270.0, cmax=306.0, contmin=270.0, contmax=306.0
  real, parameter :: vxmin=0.15, vxmax=0.85, vymin=0.225, vymax=0.775

  lon=(/((lonmin+dlon*(i-1)),i=1,nx)/)
  lat=(/((latmin+dlat*(i-1)),i=1,ny)/)

  formatt='(1440a3)'
  dat_line=line_number_counter( trim(dat_name) )
  allocate(dat_list(dat_line))
  call read_file_text( trim(dat_name), 1, dat_line, dat_list )

  write(*,*) "Select the converting data type."
  write(*,*) "1 = Netcdf [time split],"
  write(*,*) "2 = grads format,"
  read(*,*) dtype

  if(dtype==2)then
     write(*,'(a26,1PE14.5,a2,1PE14.5,a3)') "Undef value is converting ",  &
  &                                         undef, '->', undefc, '...'
  end if

  do i=1,dat_line
     call read_mgdsst( trim(dat_list(i)), sst )  ! ここで読み込む

     select case (dtype)
     case (1)
        call HistoryCreate( &                             ! ヒストリー作成
          & file=trim(dat_list(i))//'.nc',  &
          & title=trim(dat_list(i))//'sst data', &
          & source='Sample program of gtool_history/gtool5',   &
          & institution='GFD_Dennou Club davis project',       &
          & dims=(/'lon','lat'/), dimsizes=(/nx,ny/),               &
          & longnames=(/'longitude','latitude '/),       &
          & units=(/'deg','deg'/),                                 &
          & origin=0.0, interval=0.0 )

        call HistoryPut( 'lon', lon )                            ! 次元変数出力
        call HistoryPut( 'lat', lat )                            ! 次元変数出力

        call HistoryAddVariable( &                           ! 変数定義
          & varname='sst', dims=(/'lon','lat'/), &
          & longname='sea surface temperature', units='K', xtype='float')

        call HistoryAddAttr( 'sst', '+missing_value', undefc )

        call HistoryPut( 'sst', sst )

        call HistoryClose
        write(*,*) "Finish : "//trim(dat_list(i))//'.nc'

     case (2)

        do j=1,ny
           do k=1,nx
              if(sst(k,j)==undef)then
                 sst(k,j)=undefc
              end if
           end do
        end do

        call write_file( trim(dat_list(i))//'.bin', nx, ny, 1,  &
  &                      sst, mode='replace' )
        write(*,*) "Finish : "//trim(dat_list(i))//'.bin'

     end select

  end do

end program
