program poison2
! 多重格子法による解析サンプル
  use gtool_history
  use Ellip_Slv
!$  use omp_lib

  implicit none

  integer :: nx, ny, nxm, nym, nxg, nyg
  integer :: i, j, l
  real, allocatable, dimension(:,:) :: dmpv
  double precision :: dx, dy, dxm, dym, dxg, dyg
  double precision :: t1, t2, t3, t4, t5
  double precision, allocatable, dimension(:) :: x, y, xm, ym, xg, yg
  double precision, allocatable, dimension(:,:) :: rho, psi, psit, psia, dpsi, rhom, psim, rhog, psig, psinew, psite, psie, dpsit
  double precision, allocatable, dimension(:,:) :: at, ct
  double precision, parameter :: undef=999.0
  integer :: method
  integer :: level, conv_num, skipnum, skipnug
  integer, allocatable :: ib(:,:)
  character(4) :: tp
  logical :: ter_flag

  namelist /input /nx,ny,tp,method,ter_flag
  namelist /multi_grid /level, conv_num
  read(5,input)
  read(5,multi_grid)

  allocate(x(nx))
  allocate(y(ny))
  allocate(psi(nx,ny))
  allocate(psit(nx,ny))
  allocate(psia(nx,ny))
  allocate(dpsi(nx,ny))
  allocate(dpsit(nx,ny))
  allocate(rho(nx,ny))
  allocate(psie(nx,ny))
  allocate(psite(nx,ny))
  allocate(ib(nx,ny))
  allocate(at(nx,ny))
  allocate(ct(nx,ny))
  allocate(dmpv(nx,ny))

  t1=0.0d0
  t2=0.0d0
  t3=0.0d0
  t4=0.0d0
  t5=0.0d0

  dx=1.0/dble(nx-1)
  dy=1.0/dble(ny-1)

  x=(/(dx*(i-1),i=1,nx)/)
  y=(/(dy*(i-1),i=1,ny)/)

  rho=0.0
  at=2.0d0
  ct=0.5d0
! do i=1,nx
! do j=1,ny
! rho(i,j)=exp(-10.0*((x(i)-0.5)**2+(y(j)-0.5)**2))
! end do
! end do
  do i=1,nx
     do j=1,ny

! org
!        if((((i-(nx-1)/2)**2+(j-(ny-1)/2)**2)*dx*dy)<0.05*0.05)then
!
!           rho(i,j)=-1.0e4/8.85
!
!        end if

! analysis
        rho(i,j)=-2.0*((1.0-6.0*x(i)**2)*(y(j)**2)*(1.0-y(j)**2)+(1.0-6.0*y(j)**2)*(x(i)**2)*(1.0-x(i)**2))
        psia(i,j)=(x(i)**2-x(i)**4)*(y(j)**4-y(j)**2)

     end do
  end do

!  call cpu_time( t1 )
!$ t1=omp_get_wtime()

  if(ter_flag.eqv..true.)then
     do j=1,ny
        do i=1,nx
           ib(i,j)=0
           if(j<=ny/4.and.i>=nx/4.and.i<=nx*3/4)then
              ib(i,j)=10
           end if
        end do
     end do
     ib(nx/4,1:ny/3)=1
     ib(nx/4:nx*3/4,ny/3)=1
     ib(nx*3/4,1:ny/3)=1
     select case (method)
     case(1)
        call Ellip_GauSei_2d( x, y, rho, 1.0d-8, tp, psi,  &
  &                           inner_bound=ib, undef=undef )
     case(2)
        call Ellip_Jacobi_2d( x, y, rho, 1.0d-8, tp, psi,  &
  &                          inner_bound=ib, undef=undef )
     end select
  else
     select case (method)
     case(1)
!$ t3=omp_get_wtime()
        !-- Full level solver
!        call Ellip_GauSei_2d(x,y,rho,1.0d-8,tp,psit,a=at,c=ct,ln=1000000)
!        call calc_error_2d(x,y,psit,rho,psite,a=at,c=ct)
!$ t4=omp_get_wtime()

        call Full_Multi_Grid_2d( level, x, y, rho, 1.0d-8, tp, psi,  &
  &                              a=at, c=ct,  &
  &                              conv_num=conv_num, add_itr=conv_num )
!ORG        !-- FMG
!ORG        !-- 1. Solving on the coasest grid
!ORG        !-- Set and Allocate variables on the coarsest grid
!ORG        skipnum=2**(level-1)
!ORG        nxm=(nx-1)/skipnum+1
!ORG        nym=(ny-1)/skipnum+1
!ORG        dxm=dx*dble(skipnum)
!ORG        dym=dy*dble(skipnum)
!ORG        allocate(xm(nxm))
!ORG        allocate(ym(nym))
!ORG        allocate(rhom(nxm,nym))
!ORG        allocate(psim(nxm,nym))
!ORG        xm=(/(dxm*(i-1),i=1,nxm)/)
!ORG        ym=(/(dym*(i-1),i=1,nym)/)
!ORG!        write(*,*) "skipnum = ", skipnum, "XY=", (nx-1)/skipnum, (ny-1)/skipnum
!ORG
!ORG        !-- 2. Calculation of the initial u^l before the V-cycle
!ORG        call forward_interpo( rho, rhom, level, 1 )
!ORG        call Ellip_GauSei_2d( xm, ym, rhom, 1.0d-8, tp, psim,ln=conv_num )
!ORG!write(*,*) "temporary stop", psim
!ORG
!ORG        !-- 3. Enter cycles
!ORG        do l=2,level
!ORG           !-- Set and Allocate variables on the l grid
!ORG           skipnug=2**(level-l)
!ORG           nxg=(nx-1)/skipnug+1
!ORG           nyg=(ny-1)/skipnug+1
!ORG           dxg=dx*dble(skipnug)
!ORG           dyg=dy*dble(skipnug)
!ORG           allocate(xg(nxg))
!ORG           allocate(yg(nyg))
!ORG           allocate(rhog(nxg,nyg))
!ORG           allocate(psig(nxg,nyg))
!ORG           allocate(psinew(nxg,nyg))
!ORG           xg=(/(dxg*(i-1),i=1,nxg)/)
!ORG           yg=(/(dyg*(i-1),i=1,nyg)/)
!ORG!           write(*,*) "skipnum = ", skipnug, "XY=", (nx-1)/skipnug, (ny-1)/skipnug
!ORG
!ORG           !-- Interpolation of the initial u^l
!ORG           call backward_interpo( psim, psig, l-1, l )  ! From l-1 to l
!ORG           call forward_interpo( rho, rhog, level, l )  ! From level to l
!ORG
!ORG           !-- Enter the V-cycle from the l grid
!ORG           call GauSei_Vcycle_2d( l, xg, yg, psig, rhog, psinew, conv_num )
!ORG!write(*,*) "temporary stop", psig
!ORG!stop
!ORG
!ORG           !-- Reallocate psim from l-1 to l
!ORG           deallocate(psim)
!ORG           nxm=nxg
!ORG           nym=nyg
!ORG           allocate(psim(nxm,nym))
!ORG
!ORG           !-- Store psinew to psim
!ORG           psim(1:nxm,1:nym)=psinew(1:nxg,1:nyg)
!ORG
!ORG           !-- Deallocate variables
!ORG           deallocate(xg)
!ORG           deallocate(yg)
!ORG           deallocate(rhog)
!ORG           deallocate(psig)
!ORG           deallocate(psinew)
!ORG        end do
!ORG
!ORG        if(nxm/=nx.or.nym/=ny)then
!ORG           write(*,*) "error"
!ORG           stop
!ORG        end if
!ORG        allocate(psinew(nx,ny))
!ORG        do l=1,30
!ORG           call GauSei_Vcycle_2d( level, x, y, psim, rho, psinew, conv_num )
!ORG           psim=psinew
!ORG        end do
!ORG
!ORG        !-- 4. Set psi
!ORG!        write(*,*) "check final grid", nx, ny, nxm, nym
!ORG        psi(1:nx,1:ny)=psim(1:nxm,1:nym)
        call calc_error_2d( x, y, psi, rho, psie, a=at, c=ct )

        dpsi(1:nx,1:ny)=psi(1:nx,1:ny)-psia(1:nx,1:ny)
        dpsit(1:nx,1:ny)=psit(1:nx,1:ny)-psia(1:nx,1:ny)
!$ t5=omp_get_wtime()

     case(2)
        call Ellip_Jacobi_2d(x,y,rho,1.0d-8,tp,psi)
     end select
  end if

!  call cpu_time( t2 )
!$ t2=omp_get_wtime()

!$ write(*,*) "Main solver elapse time is ", t2-t1, "[s]."

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ヒストリー作成
    & file='poison.nc', title='poison model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','y'/), dimsizes=(/nx,ny/),               &
    & longnames=(/'X-coordinate','Y-coordinate'/),       &
    & units=(/'m','m'/),                                 &
    & origin=0.0, interval=0.0 )
 
  call conv_d2f_1d( x, dmpv(1:nx,1) ) 
  call HistoryPut( 'x', dmpv(1:nx,1) )
  call conv_d2f_1d( y, dmpv(1,1:ny) ) 
  call HistoryPut( 'y', dmpv(1,1:ny) )

  call HistoryAddVariable( &                           ! 変数定義
    & varname='psi', dims=(/'x','y'/), &
    & longname='psi', units='1', xtype='float')

  call conv_d2f( psi, dmpv(1:nx,1:ny) )
  call HistoryPut('psi',dmpv)                         ! 変数出力
!  call HistoryPut('psi',psi)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='psit', dims=(/'x','y'/), &
    & longname='true of psi', units='1', xtype='float')

  call conv_d2f( psit, dmpv(1:nx,1:ny) )
  call HistoryPut('psit',dmpv)                         ! 変数出力
!  call HistoryPut('psit',psit)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='epsit', dims=(/'x','y'/), &
    & longname='error of true psi for rho', units='1', xtype='float')

  call conv_d2f( psite, dmpv(1:nx,1:ny) )
  call HistoryPut('epsit',dmpv)                         ! 変数出力
!  call HistoryPut('epsit',psite)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='epsi', dims=(/'x','y'/), &
    & longname='error of psi for rho', units='1', xtype='float')

  call conv_d2f( psie, dmpv(1:nx,1:ny) )
  call HistoryPut('epsi',dmpv)                         ! 変数出力
!  call HistoryPut('epsi',psie)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='dpsi', dims=(/'x','y'/), &
    & longname='difference between psi and psia', units='1', xtype='float')

  call conv_d2f( dpsi, dmpv(1:nx,1:ny) )
  call HistoryPut('dpsi',dmpv)                         ! 変数出力
!  call HistoryPut('dpsi',dpsi)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='dpsit', dims=(/'x','y'/), &
    & longname='difference between psit and psia', units='1', xtype='float')

  call conv_d2f( dpsit, dmpv(1:nx,1:ny) )
  call HistoryPut('dpsit',dmpv)                         ! 変数出力
!  call HistoryPut('dpsit',dpsit)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='rho', dims=(/'x','y'/), &
    & longname='forcing', units='1', xtype='float')

  call conv_d2f( rho, dmpv(1:nx,1:ny) )
  call HistoryPut('rho',dmpv)                         ! 変数出力
!  call HistoryPut('rho',rho)                         ! 変数出力
  call HistoryClose

  write(*,*) "--------------------------------------------"
  write(*,'(a28,1p,E14.5,a5)') "Main solver running time = ",  &
  &                            (t2-t1), " [s]."
  if(method==1)then
     write(*,*) "This Method is Seidel Method."
     write(*,'(a22,1p,E14.5,a5)') "Seidel running time = ",  &
  &                               (t4-t3), " [s]."
     write(*,'(a19,1p,E14.5,a5)') "FMG running time = ",  &
  &                               (t5-t4), " [s]."
  else
     write(*,*) "This Method is Jacobi Method."
  end if
  write(*,*) "--------------------------------------------"

contains

subroutine conv_d2f_1d( dval, fval )
  implicit none
  double precision, intent(in) :: dval(:)
  real, intent(out) :: fval(size(dval))
  integer :: ii, ix

  ix=size(dval)

  do ii=1,ix
     fval(ii)=real(dval(ii))
  end do

end subroutine conv_d2f_1d

subroutine conv_d2f( dval, fval )
  implicit none
  double precision, intent(in) :: dval(:,:)
  real, intent(out) :: fval(size(dval,1),size(dval,2))
  integer :: ii, jj, ix, jy

  ix=size(dval,1)
  jy=size(dval,2)

  do jj=1,jy
     do ii=1,ix
        fval(ii,jj)=real(dval(ii,jj))
     end do
  end do

end subroutine conv_d2f


subroutine calc_error_2d( xl, yl, ul, fl, error, a, b, c, d, e, f )
!-- Calculation error for f^l - L^lu^l
  implicit none
  double precision, intent(in) :: xl(:)                  ! X grid on the level grid
  double precision, intent(in) :: yl(:)                  ! Y grid on the level grid
  double precision, intent(in) :: ul(size(xl),size(yl))  ! The initial guess for u on the level grid
  double precision, intent(in) :: fl(size(xl),size(yl))  ! The forcing on the level grid
  double precision, intent(out) :: error(size(xl),size(yl)) ! The error for fl - Ll(ul)
  double precision, intent(in), optional :: a(size(xl),size(yl))  ! coefficient in PDE
  double precision, intent(in), optional :: b(size(xl),size(yl))  ! coefficient in PDE
  double precision, intent(in), optional :: c(size(xl),size(yl))  ! coefficient in PDE
  double precision, intent(in), optional :: d(size(xl),size(yl))  ! coefficient in PDE
  double precision, intent(in), optional :: e(size(xl),size(yl))  ! coefficient in PDE
  double precision, intent(in), optional :: f(size(xl),size(yl))  ! coefficient in PDE
  integer :: ii, jj, nxl, nyl
  double precision :: dxi, dyi
  double precision, dimension(size(xl),size(yl)) :: at, bt, ct, dt, et, ft

  !-- Set and Allocate variables
  nxl=size(xl)
  nyl=size(yl)
  dxi=1.0d0/(xl(2)-xl(1))
  dyi=1.0d0/(yl(2)-yl(1))

  at=1.0d0
  ct=1.0d0
  bt=0.0d0
  dt=0.0d0
  et=0.0d0
  ft=0.0d0

  if(present(a))then
     at(1:nxl,1:nyl)=a(1:nxl,1:nyl)
  end if
  if(present(b))then
     bt(1:nxl,1:nyl)=b(1:nxl,1:nyl)
  end if
  if(present(c))then
     ct(1:nxl,1:nyl)=c(1:nxl,1:nyl)
  end if
  if(present(d))then
     dt(1:nxl,1:nyl)=d(1:nxl,1:nyl)
  end if
  if(present(e))then
     et(1:nxl,1:nyl)=e(1:nxl,1:nyl)
  end if
  if(present(f))then
     ft(1:nxl,1:nyl)=f(1:nxl,1:nyl)
  end if

  error=0.0

  do jj=2,nyl-1
     do ii=2,nxl-1
        error(ii,jj)=fl(ii,jj)  &
  &                 -at(ii,jj)*(ul(ii+1,jj)+ul(ii-1,jj)-2.0d0*ul(ii,jj))*dxi*dxi  &
  &                 -ct(ii,jj)*(ul(ii,jj+1)+ul(ii,jj-1)-2.0d0*ul(ii,jj))*dyi*dyi  &
  &                 -bt(ii,jj)*(ul(ii+1,jj+1)+ul(ii-1,jj-1)  &
  &                           -(ul(ii-1,jj+1)+ul(ii+1,jj-1)))*0.25d0*dxi*dyi  &
  &                 -dt(ii,jj)*(ul(ii+1,jj)-ul(ii-1,jj))*0.5d0*dxi  &
  &                 -et(ii,jj)*(ul(ii,jj+1)-ul(ii,jj-1))*0.5d0*dyi  &
  &                 -ft(ii,jj)*ul(ii,jj)
     end do
  end do

end subroutine calc_error_2d


end program
