program advect
  use ffts  ! FFT ルーチン
  use file_operate  ! 結果ファイル出力
  use Math_Const
  implicit none
  integer :: nx  ! x 方向の格子点数
  real :: dt  ! 計算時間間隔
  integer :: nt  ! 計算ステップ数
  real :: xmin  ! x 座標左端
  real :: dx  ! x 座標格子間隔
  integer :: j, k, l, m, n
  real, allocatable, dimension(:) :: x  ! x 座標
  real, allocatable, dimension(:) :: y  ! スカラー変数
  complex, allocatable, dimension(:) :: fx  ! y の変数変換用
  complex, allocatable, dimension(:) :: fm1  ! スペクトル用
  complex, allocatable, dimension(:) :: fm2  ! スペクトル用
  complex, allocatable, dimension(:) :: fm_tmp  ! ダンプ出力用
  complex :: ctmp
  complex, parameter :: i=(0.0,1.0)

  namelist /input /nx,dt,nt,xmin,dx
  read(5,input)

  if(mod(nx,2)/=0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "nx must be even number. Stop."
     stop
  end if

  allocate(x(0:nx-1))
  allocate(y(0:nx-1))
  allocate(fx(0:nx-1))
  allocate(fm1(0:nx/2-1))
  allocate(fm2(0:nx/2-1))
  allocate(fm_tmp(0:nx/2-1))

  x=(/((xmin+dx*real(j)),j=0,nx-1)/)

  do j=0,nx-1
!     y(j)=sin(x(j))
     y(j)=exp(-(x(j)-0.5*real(nx)*dx)**2)
!     fx(j)=y(j)
  end do

  call r2c_ffttp_1d( nx, y, fm1, 'o' )

  open(unit=10, file="result.dat", access='direct', status='unknown', recl=4*nx)
!-- 時間積分開始
  do j=1,nt
!-------------------------------------------------
! nx/2 の実数については, 複素数にまで展開し, 各ステップで
! 逆変換の際, 実数にのみを用いて FFT ルーチンに送る.
!     ctmp=((1.0+0.25*i*dt*real(nx))/  &
! &         (1.0-0.25*i*dt*real(nx)))*aimag(fm1(0))  ! nx/2 番目の実数スペクトル
!     fm2(k)=real(fm1(0))+
!     fm1(k)=fm2(k)
!-------------------------------------------------
!     fm2(0)=real(fm1(0))
     do k=1,nx/2-1
!        fm2(k)=(1.0+i*0.1*dt*real(k))*fm1(k)
!        fm2(k)=(1.0-i*0.1*dt*real(k))*fm1(k)/(1.0+0.01*dt**2*real(k)**2)
!        fm2(k)=((1.0-0.25*(dt*real(k))**2+i*dt*real(k))/  &
!  &            (1.0+0.25*(dt*real(k))**2))*fm1(k)
        fm2(k)=((1.0-0.25*(dt*real(k))**2-i*dt*real(k))/  &
  &            (1.0+0.25*(dt*real(k))**2))*fm1(k)
        fm1(k)=fm2(k)
     end do
     fm2(0)=fm1(0)
!        ctmp=((1.0-0.25*i*dt*real(nx))/  &
!  &            (1.0+0.25*i*dt*real(nx)))*ctmp
!        fm2(0)=fm1(0)+2.0*i*real(ctmp)
!        fm1(0)=fm2(0)
     call c2r_ffttp_1d( nx, fm2, y, 'o' )
     write(10,rec=j) (y(k),k=0,nx-1)
  end do
  close(unit=10,status='keep')

end program
