module HEVI_mod

  contains

subroutine HEVI()

  use sub_calc
  use val_define
  use read_namelist
  use val_alloc
  use val_init
  use val_coord
  use real_initialize
  use sub_calc

  implicit none

  integer :: i, j, k
  real :: coe, coee, logc, logcc
  real, dimension(nr+1,nz+1) :: ak, bk, ck, dk, xk, yk, divu_s, div_s

     !-- For u, explicit calculation (Euler scheme)

  div_s=0.0

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)

  do k=1,nz
     do j=1,nr
        div_s(j,k)=(r_u(j+1)*u_old(j+1,k)-r_u(j)*u_old(j,k))/(r_s(j)*(r_u(j+1)-r_u(j)))  &
  &                 +(w_old(j,k+1)-w_old(j,k))/(z_w(k+1)-z_w(k))
     end do
  end do

!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)

  do k=1,nz
     do j=2,nr
        u_new(j,k)=u_old(j,k)+dts*force_u(j,k)  &
               -dts*Cpd*ptvb_u(j,k)*((p_old(j,k)-p_old(j-1,k)  &
  &                                  -alpha*(div_s(j,k)-div_s(j-1,k)))/(r_s(j)-r_s(j-1)))
if(abs(force_u(j,k))>1.0)then
write(*,*) "u_new check", u_new(j,k), j, k, u_old(j,k), force_u(j,k), p_old(j,k), divu_s(j,k)
end if
     end do

  !-- r-direction boundary condition
     u_new(1,k)=0.0
     if(u_old(nr+1,k)+cg>=0.0)then
        u_new(nr+1,k)=u_old(nr+1,k)+dts*force_u(nr+1,k)
     else
        u_new(nr+1,k)=u_old(nr+1,k)
     end if
  end do

!$omp end do
!$omp end parallel

  divu_s=0.0

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)

  do k=1,nz
     do j=1,nr
        divu_s(j,k)=(r_u(j+1)*u_new(j+1,k)-r_u(j)*u_new(j,k))/(r_s(j)*(r_u(j+1)-r_u(j)))
if(abs(u_new(j,k))>100.0)then
!write(*,*) "u_new check", u_new(j,k), j, k, u_old(j,k), force_u(j,k), p_old(j,k), divu_s(j,k)
end if
     end do
  end do

!$omp end do
!$omp end parallel

     !-- For w, pi, implicit calculation (CN scheme)

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k,coe,coee,logc,logcc)

  do j=1,nr
     do k=2,nz
        coe=ptvb_w(j,k)*(Cpd/Cvd)*Rd*tempb_s(j,k)  &
  &         *((2.0*dts*beta/(z_w(k+1)-z_w(k-1)))**2)
        coee=ptvb_w(j,k)*(Cpd/Cvd)*Rd*(dts**2)  &
  &         *(2.0*beta/(z_w(k+1)-z_w(k-1)))
        logc=1.0/(rhob_s(j,k-1)*ptvb_s(j,k-1)*ptvb_s(j,k-1))
        logcc=1.0/(rhob_s(j,k)*ptvb_s(j,k)*ptvb_s(j,k))

        ak(j,k)=-coe*(rhob_w(j,k+1)*ptvb_w(j,k+1)*logcc)
        bk(j,k)=1.0+coe*rhob_w(j,k)*ptvb_w(j,k)*(logcc+logc)
        ck(j,k)=-coe*(rhob_w(j,k-1)*ptvb_w(j,k-1)*logc)

        dk(j,k)=w_old(j,k)*(1.0-coee*(1.0-beta)*rhob_w(j,k)*ptvb_w(j,k)  &
  &                             *(tempb_s(j,k)*logcc+tempb_s(j,k-1)*logc)  &
  &                             *(2.0/(z_w(k+1)-z_w(k-1))))  &
  &             +force_w(j,k)*dts  &
  &             +coee*(tempb_s(j,k)*divu_s(j,k)/ptvb_s(j,k)  &
  &                   -tempb_s(j,k-1)*divu_s(j,k-1)/ptvb_s(j,k-1))  &
  &             -Cpd*ptvb_w(j,k)*(dts/(z_s(k)-z_s(k-1)))  &
  &              *(p_old(j,k)-p_old(j,k-1)-alpha*(div_s(j,k)-div_s(j,k-1)))  &

  &             +coee*(1.0-beta)*(2.0/(z_w(k+1)-z_w(k-1)))  &
  &              *(tempb_s(j,k)*rhob_w(j,k+1)*ptvb_w(j,k+1)*logcc*w_old(j,k+1)  &
  &               +tempb_s(j,k-1)*rhob_w(j,k-1)*ptvb_w(j,k-1)*logc*w_old(j,k-1))
     end do
  end do

!$omp end do
!$omp end parallel

  do j=1,nr
     xk(j,2)=ak(j,2)/bk(j,2)
     yk(j,2)=dk(j,2)/bk(j,2)
     do k=3,nz
        xk(j,k)=ak(j,k)/(bk(j,k)-ck(j,k)*xk(j,k-1))
        yk(j,k)=(dk(j,k)-yk(j,k-1)*ck(j,k))/(bk(j,k)-ck(j,k)*xk(j,k-1))
     end do

     w_new(j,nz)=yk(j,nz)
     do k=nz-1,2,-1
        w_new(j,k)=yk(j,k)-xk(j,k)*w_new(j,k+1)
if(abs(w_new(j,k))>20.0)then
write(*,*) "w_new check", w_new(j,k), j, k, ak(j,k), bk(j,k), ck(j,k), dk(j,k), xk(j,k), yk(j,k)
end if
     end do

  !-- z-direction boundary condition
     w_new(j,nz+1)=0.0
     w_new(j,1)=0.0
  end do

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k,coe,coee)

  do k=1,nz
     do j=1,nr
        coe=(Rd*tempb_s(j,k)/(Cvd*ptvb_s(j,k)))*dts
        coee=coe/(ptvb_s(j,k)*rhob_s(j,k)*(z_w(k+1)-z_w(k)))
        p_new(j,k)=p_old(j,k)  &
  &                -coe*divu_s(j,k)  &
  &                -coee*((w_new(j,k+1)*beta+w_old(j,k+1)*(1.0-beta))  &
  &                        *rhob_w(j,k+1)*ptvb_w(j,k+1)  &
  &                      -(w_new(j,k)*beta+w_old(j,k)*(1.0-beta))  &
  &                        *rhob_w(j,k)*ptvb_w(j,k))
if(abs(p_new(j,k))>0.5)then
write(*,*) "p_new check", p_new(j,k), j, k, p_old(j,k)
end if
     end do
  end do

!$omp end do
!$omp end parallel


end subroutine HEVI

end module
