module force_solv_small
! 小さな時間ステップで強制項を計算するモジュール
  use Derivation
  use ffts
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use special_function
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use complex_initialize
  use mpi

contains

subroutine force_small()

  implicit none

  integer :: i, j

  !-- 強制項の初期化
  call complex_init( forceu )
  call complex_init( forcev )
  call complex_init( forceh )
!     do j=1,hnt+1
!        do i=1,nr
!           forceu(i,j)=(0.0,0.0)
!           forcev(i,j)=(0.0,0.0)
!           forceh(i,j)=(0.0,0.0)
!        end do
!     end do

!-- スペクトル変数を実部・虚部に分割

!-- 時間の従属変数の空間微分を計算

  call grad_1d( rv, ub, dubdr )
  call grad_1d( rs, hb, dhbdr )
  call grad_1d( rv, vb, dvbdr )

  !-- 基本場の移流項

  do i=1,nr
     ubdub(i)=ub(i)*dubdr(i)
     ubdvb(i)=ub(i)*dvbdr(i)
     ubdhb(i)=ub(i)*dhbdr(i)
     vbdub(i)=vb(i)*dubdr(i)
     vbdvb(i)=vb(i)*dvbdr(i)
     vbdhb(i)=vb(i)*dhbdr(i)
     hbdub(i)=hb(i)*dubdr(i)
     hbdvb(i)=hb(i)*dvbdr(i)
     hbdhb(i)=hb(i)*dhbdr(i)
  end do

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
  do j=1,hnt+1

     call complex_grad_1d( rs, hcp_old(:,j), dhcpdr(:,j) )
     call complex_grad_1d( rv, ucp_old(:,j), ducpdr(:,j) )
     call complex_grad_1d( rv, vcp_old(:,j), dvcpdr(:,j) )

     !-- 移流項の計算 (線形項のみ)

     do i=1,nr
        updub(i,j)=ucp_old(i,j)*dubdr(i)
        vpdub(i,j)=vcp_old(i,j)*dubdr(i)
        hpdub(i,j)=hcp_old(i,j)*dubdr(i)
        updvb(i,j)=ucp_old(i,j)*dvbdr(i)
        vpdvb(i,j)=vcp_old(i,j)*dvbdr(i)
        hpdvb(i,j)=hcp_old(i,j)*dvbdr(i)
        updhb(i,j)=ucp_old(i,j)*dhbdr(i)
        vpdhb(i,j)=vcp_old(i,j)*dhbdr(i)
        hpdhb(i,j)=hcp_old(i,j)*dhbdr(i)
        ubdup(i,j)=ub(i)*ducpdr(i,j)
        ubdvp(i,j)=ub(i)*dvcpdr(i,j)
        ubdhp(i,j)=ub(i)*dhcpdr(i,j)
        vbdup(i,j)=vb(i)*ducpdr(i,j)
        vbdvp(i,j)=vb(i)*dvcpdr(i,j)
        vbdhp(i,j)=vb(i)*dhcpdr(i,j)
        hbdup(i,j)=hb(i)*ducpdr(i,j)
        hbdvp(i,j)=hb(i)*dvcpdr(i,j)
        hbdhp(i,j)=hb(i)*dhcpdr(i,j)
     end do

     !-- 変形項の計算

     do i=1,nr
        ubup(i,j)=ub(i)*ucp_old(i,j)
        ubvp(i,j)=ub(i)*vcp_old(i,j)
        ubhp(i,j)=ub(i)*hcp_old(i,j)
        vbup(i,j)=vb(i)*ucp_old(i,j)
        vbvp(i,j)=vb(i)*vcp_old(i,j)
        vbhp(i,j)=vb(i)*hcp_old(i,j)
        hbup(i,j)=hb(i)*ucp_old(i,j)
        hbvp(i,j)=hb(i)*vcp_old(i,j)
        hbhp(i,j)=hb(i)*hcp_old(i,j)
     end do

   !-- 各項計算
      !-- 強制項へまとめる
      !-- このとき, j=1 は実数成分が波数ゼロ, 虚数成分が波数 nt/2 なので,
      !-- それ用に処理を分ける.
      !-- ここでは, 時間変化しない重力波強制項は含めない.
      !-- なぜなら, 常に同じ値で強制をかけているため.
     if(force_flag(7:7)=='o')then  ! 連続の式の発散項

        do i=2,nr-1
           forceh(i,j)=forceh(i,j)  &
  &                    -hbdup(i,j)  &
  &                    -hbup(i,j)/rs(i)  &
  &                    -img*(real(j-1))*hbvp(i,j)/rs(i)
        end do
     end if

     if(force_flag(8:8)=='o')then  ! 圧力傾度項
        do i=2,nr-1
           forceu(i,j)=forceu(i,j)  &
  &                    -(g*dhcpdr(i,j))
           forcev(i,j)=forcev(i,j)  &
  &                    -g*img*(real(j-1))*hcp_old(i,j)/rs(i)
        end do
     end if

   !-- 一定強制項の付加

     do i=2,nr-1
        forceu(i,j)=forceu(i,j)+termu(i,j)
        forcev(i,j)=forcev(i,j)+termv(i,j)
        forceh(i,j)=forceh(i,j)+termh(i,j)
     end do

  end do

!$omp end do
!$omp end parallel

end subroutine

end module
