module fft_saveval_alloc
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new

  use fft_saveval_define

  implicit none

contains

subroutine fft_saveval_allocate()

  use fft_saveval_define

  implicit none

  integer :: err

  err=0

  allocate(x(nx),stat=err)  ! ベクトル動径座標
  allocate(y(ny),stat=err)  ! 接線座標

  allocate(xd(nx),stat=err)  ! ベクトル動径座標
  allocate(yd(ny),stat=err)  ! 接線座標

  !-- 変換法用座標
  allocate(xj(jxnt),stat=err)
  allocate(yj(jynt),stat=err)

  allocate(xi(nxi),stat=err)
  allocate(yi(nyi),stat=err)

!ORG  allocate(t(nt))
  allocate(cr(jxnt,jynt),stat=err)
  allocate(cr_isp(jynt,jxnt),stat=err)
  allocate(zinit_isp(jynt,jxnt),stat=err)

  if(err/=0)then
     write(*,*) "*** ERROR (fft_saveval_allocate) *** : cannot allocate."
     stop
  end if

end subroutine

subroutine fft_saveval_allocate_isp()

  use fft_saveval_define

  implicit none

  integer :: err

  err=0
  allocate(TJR(2*ny),stat=err)
  allocate(TIR(2*nx),stat=err)
  allocate(ITJR(5),stat=err)
  allocate(ITIR(5),stat=err)
  allocate(TJJ(2*jynt),stat=err)
  allocate(TIJ(2*jxnt),stat=err)
  allocate(ITJJ(5),stat=err)
  allocate(ITIJ(5),stat=err)

  if(err/=0)then
     write(*,*) "*** ERROR (fft_saveval_allocate_isp) *** : cannot allocate."
     stop
  end if

end subroutine

end module
