program solver
! ϰ̲ǥ
! Ȥޤ路ץΤ,
! nr, r, -> y
! ntheta, theta -> -x
! v -> -u
! u -> v
! ˤ줾б.

  use gtool_history
  use Derivation
  use ffts
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use special_function
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use time_scheme

  implicit none

!-- do loop ѿ
  integer :: i, j, it, ct

!-- namelist ɤ߹

  call read_name()

!-- allocating array

  call val_allocate()

!-- Ͳ (2d ǡ 3 ǡؤγĥ)

write(*,*) "starting initialization."
  call HistoryGet( trim(finame), 'up', uib )
  call HistoryGet( trim(finame), 'vp', vib )
  call HistoryGet( trim(finame), 'hp', hib )
  call HistoryGet( trim(finame), 'y', ri )
  call HistoryGet( trim(finame), 'x', thetai )

!-- ʻκ
  call val_coordinate()

!-- ͥǡγʻ׻ΰγʻҤ
!-- ǽλ
  call cont_interpolation( thetai, ri, theta, rv, vib, inv_vp )
  call cont_interpolation( thetai, ri, theta, rs, hib, inv_hp )
  call cont_interpolation( thetai, ri, theta, rs, uib, inv_up )

!-- ʬؤ
  do i=1,nr
     do j=1,ntheta
        urp_dmp(i,j)=-inv_vp(j,i)
        vrp_dmp(i,j)=inv_up(j,i)
        hrp_dmp(i,j)=inv_hp(j,i)
     end do
  end do

!-- 쥤꡼ԥ
  epsu=0.0
  epsv=0.0
  epsh=0.0

  do i=1,nr
     if(rv(i)>=r_dmp)then
        epsu(i)=1.0
        epsv(i)=1.0
        epsh(i)=1.0
     end if
  end do

  write(*,*) "normally pass the initialization."

!-- ϥեν
  call HistoryCreate( file=trim(foname), title='shallow result data', &
  & source='test', institution='test', dims=(/'x','y','t'/),  &
  & dimsizes=(/ntheta, nr, 0/),  & 
  & longnames=(/'x-coordinate    ','y-coordinate', 'time        '/),  &
  & units=(/'m', 'm', 's'/), origin=0.0, interval=dmpstp*dt )
  
  call HistoryPut( 'x', theta )
  call HistoryPut( 'y', rs )
  
  call HistoryAddVariable( varname='up', dims=(/'x','y','t'/), &
    & longname='radial wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='vp', dims=(/'x','y','t'/), &
    & longname='tangential wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='hp', dims=(/'x','y','t'/), &
    & longname='geopotential height', units='m', xtype='float')

  write(*,*) "time integration start."

  !-- ν (ͤν)
  do j=1,ntheta
     do i=1,nr
        ucp_old(i,j)=urp_dmp(i,j)
        vcp_old(i,j)=vrp_dmp(i,j)
        hcp_old(i,j)=hrp_dmp(i,j)
     end do
  end do

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  !-- ֤ؤ

  do i=1,nr
     do j=1,ntheta
        inv_up(j,i)=-vrp_dmp(i,j)
        inv_vp(j,i)=urp_dmp(i,j)
        inv_hp(j,i)=hrp_dmp(i,j)
     end do
  end do

  call HistoryPut( 'up', inv_up )
  call HistoryPut( 'vp', inv_vp )
  call HistoryPut( 'hp', inv_hp )

!$omp parallel default(shared)
!$omp do private(i)
  do i=1,nr
     call ffttp_1d( ntheta, ucp_old(i,:), ucp_new(i,:), 'r', prim='o' )
     call ffttp_1d( ntheta, vcp_old(i,:), vcp_new(i,:), 'r', prim='o' )
     call ffttp_1d( ntheta, hcp_old(i,:), hcp_new(i,:), 'r', prim='o' )
  end do
!$omp end do
!$omp end parallel

!-- solver 

  do it=1,nt

     call time_schematic( it )

  !-- ƥåפοʤ߶
     write(*,*) "This step is ", it, "(time =", real(it)*dt, "[s])."

     !-- ν (2)
     if(mod(it,dmpstp)==0)then  ! ѴԤ¿Ϥ.

!$omp parallel default(shared)
!$omp do private(i)
        do i=1,nr
           call ffttp_1d( ntheta, ucp_new(i,:), ucp_dmp(i,:), 'i', prim='o' )
           call ffttp_1d( ntheta, vcp_new(i,:), vcp_dmp(i,:), 'i', prim='o' )
           call ffttp_1d( ntheta, hcp_new(i,:), hcp_dmp(i,:), 'i', prim='o' )
           do j=1,ntheta
              urp_new(i,j)=real(ucp_dmp(i,j))
              vrp_new(i,j)=real(vcp_dmp(i,j))
              hrp_new(i,j)=real(hcp_dmp(i,j))
           end do
        end do
!$omp end do
!$omp end parallel

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", real(it)*dt, "[s])."
        write(*,*) "*******************************************"

        !-- ֤ؤ

        do i=1,nr
           do j=1,ntheta
              inv_up(j,i)=-vrp_dmp(i,j)
              inv_vp(j,i)=urp_dmp(i,j)
              inv_hp(j,i)=hrp_dmp(i,j)
           end do
        end do

        call HistoryPut( 'up', inv_up )
        call HistoryPut( 'vp', inv_vp )
        call HistoryPut( 'hp', inv_hp )

     end if

  end do

!-- solver ȥå

  write(*,*) "solver is normally."

contains

subroutine cont_interpolation( ixcor, iycor, oxcor, oycor, ival, oval )
!-- Ⱦʻ줿ؤޤԤ.
  use Statistics

  implicit none

  real, intent(in) :: ixcor(:)  ! κɸ 1
  real, intent(in) :: iycor(:)  ! κɸ 2
  real, intent(in) :: oxcor(:)  ! ޸κɸ 1
  real, intent(in) :: oycor(:)  ! ޸κɸ 2
  real, intent(in) :: ival(size(ixcor),size(iycor))  ! icor ѿ
  real, intent(inout) :: oval(size(oxcor),size(oycor))  ! ocor ѿ
  integer :: i, ni, no, tmpi, j, nj, noj, tmpj

  ni=size(ixcor)
  no=size(oxcor)
  nj=size(iycor)
  noj=size(oycor)

  do j=1,noj
     do i=1,no
        call interpo_search_2d( ixcor, iycor, oxcor(i), oycor(j),  &
  &                             tmpi, tmpj )
        call interpolation_2d( ixcor(tmpi:tmpi+1), iycor(tmpj:tmpj+1),  &
  &                            ival(tmpi:tmpi+1,tmpj:tmpj+1),  &
  &                            (/oxcor(i), oycor(j)/), oval(i,j) )
     end do
  end do

end subroutine

end program
