program draw
  use dcl
  use Dcl_Automatic
  use gtool_history
  use Statistics
  use Math_Const
  use max_min
  use Thermo_Const
  use file_operate
  use basis
  use ffts
  use Derivation

  implicit none

  integer :: i, j, k, it
  integer :: nx, ny, nl, nt, char_num
  integer :: nargv, fig_type, cmap
  integer :: xdmin, xdmax, ydmin, ydmax
  integer, dimension(2) :: clev
  real :: xmin, xmax, ymin, ymax, xscale, yscale
  real, allocatable, dimension(:) :: x, y, time, theta
  real, allocatable, dimension(:,:) :: val1, val2, val3, val4
  real, allocatable, dimension(:,:) :: pv
  real, allocatable, dimension(:,:) :: xd, yd, hx, hy
  real, dimension(2) :: vx, vy
  character(80) :: argv
  character(80) :: cont_val, shade_val, vx_val, vy_val, fname, txtname
  character(80) :: x_axis, y_axis
  character(80), allocatable, dimension(:,:) :: cval
  character(14) :: title_tmp
  real :: cmin, cmax, smin, smax, sfact, cfact, vxfact, vyfact, dt, undef
  integer :: col_min, col_max, min_tab, max_tab
  complex, allocatable, dimension(:,:) :: amp_f
  character(70), parameter :: FONTNAME='Nimbus Sans L Bold 12'

!  cont_val=''
!  shade_val=''
!  vx_val=''
!  vy_val=''

  namelist /drawinput /fig_type, nx, ny, nt, dt,  &
  &                    xmin, xmax, ymin, ymax, fname,  &
  &                    txtname, cont_val, shade_val, vx_val, vy_val,  &
  &                    cmin, cmax, smin, smax, x_axis, y_axis,  &
  &                    sfact, cfact, vxfact, vyfact, undef, vx, vy,  &
  &                    clev, cmap, col_min, col_max, min_tab, max_tab
  read(5,nml=drawinput)

  allocate(x(nx))
  allocate(y(ny))
  allocate(theta(ny))
  allocate(val1(nx,ny))
  allocate(val2(nx,ny))
  allocate(val3(nx,ny))
  allocate(val4(nx,ny))
  allocate(hx(nx,ny))
  allocate(hy(nx,ny))

  call SGISET( 'IFONT', 1 )
  call SWLSET( 'LSYSFNT', .true. )
  call UZFACT( 0.6 )
  call GLLSET('LMISS',.TRUE.)
  call GLRSET('RMISS',undef)

!-- ѿ
  call HistoryGet( trim(fname), trim(x_axis), x(1:nx) )
  call HistoryGet( trim(fname), trim(y_axis), y(1:ny) )

  xscale=0.005
  call calc_vscale( (/(xmax-xmin), (ymax-ymin)/), (/0.6, 0.6/), xscale, yscale )
  yscale=yscale

!  dummy=-10.0

  do j=1,ny
     do i=1,nx
        hx(i,j)=1.0
        hy(i,j)=x(i)
     end do
  end do

!-- ΰη
  call nearest_search_1d( x, xmin, xdmin )
  call nearest_search_1d( x, xmax, xdmax )
  call nearest_search_1d( y, ymin, ydmin )
  call nearest_search_1d( y, ymax, ydmax )

  call color_setting( clev(2), (/smin, smax/),  &
  &                   col_min=col_min, col_max=col_max,  &
  &                   min_tab=min_tab, max_tab=max_tab, col_tab=cmap )  

  call DclOpenGraphics(1)

  CALL SWCSET('FONTNAME', FONTNAME)

  do it=0,nt-1

     write(*,'(1P,E14.5)') it*dt
     write(title_tmp,'(1P,E14.5)') it*dt
!     title_tmp=r2c_convert( (it*dt), '(f3.1)' )
     title_tmp='t='//trim(adjustl(title_tmp))
     write(*,*) "read time is ", title_tmp

     if(cont_val/=''.and.trim(cont_val)/='pv')then
        call HistoryGet( trim(fname), trim(cont_val), val1(1:nx,1:ny),  &
     &                   range=trim(title_tmp) )

           do j=1,ny
              do i=1,nx
                 if(val1(i,j)/=undef)then
                    val1(i,j)=val1(i,j)*cfact
                 end if
              end do
           end do
     end if
     if(shade_val/=''.and.trim(shade_val)/='pv')then
        call HistoryGet( trim(fname), trim(shade_val), val2(1:nx,1:ny),  &
     &                   range=trim(title_tmp) )

           do j=1,ny
              do i=1,nx
                 if(val2(i,j)/=undef)then
                    val2(i,j)=val2(i,j)*sfact
                 end if
              end do
           end do
     end if
     if(vx_val/='')then
        call HistoryGet( trim(fname), trim(vx_val), val3(1:nx,1:ny),  &
     &                   range=trim(title_tmp) )

           do j=1,ny
              do i=1,nx
                 if(val3(i,j)/=undef)then
                    val3(i,j)=val3(i,j)
                 end if
              end do
           end do
     end if
     if(vy_val/='')then
        call HistoryGet( trim(fname), trim(vy_val), val4(1:nx,1:ny),  &
     &                   range=trim(title_tmp) )

        do j=1,ny
           do i=1,nx
              if(val4(i,j)/=undef)then
                 val4(i,j)=val4(i,j)
              end if
           end do
        end do
     end if

!-- ƥȥǡ뤫ǧ
     if(txtname/='')then
        nl=line_number_counter( trim(txtname) )
        allocate(xd(nl,1))
        allocate(yd(nl,1))
        allocate(cval(2,nl))

        call read_file_text( trim(txtname), 2, nl, cval )

        do i=1,nl
           xd(i,1)=c2r_convert( cval(1,i) )
           yd(i,1)=c2r_convert( cval(2,i) )
        end do
     end if

     if(fig_type==1)then
        if(txtname/='')then
        call Dcl_2D_cont_shade(  &
     &       trim(cont_val)//' and '//trim(shade_val)//'\_{('//trim(title_tmp)//')}',  &
     &       x(xdmin:xdmax), y(ydmin:ydmax),  &
     &       val1(xdmin:xdmax,ydmin:ydmax),  &
     &       val2(xdmin:xdmax,ydmin:ydmax),  &
     &       (/cmin, cmax/), (/smin, smax/),  &
     &       (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
     &       c_num=clev, viewx_int=vx, viewy_int=vy,  &
     &       xg=xd(:,1:1), yg=yd(:,1:1), no_tone=.true. )  !,  &
        else
        call Dcl_2D_cont_shade(  &
     &       trim(cont_val)//' and '//trim(shade_val)//'\_{('//trim(title_tmp)//')}',  &
     &       x(xdmin:xdmax), y(ydmin:ydmax),  &
     &       val1(xdmin:xdmax,ydmin:ydmax),  &
     &       val2(xdmin:xdmax,ydmin:ydmax),  &
     &       (/cmin, cmax/), (/smin, smax/),  &
     &       (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
     &       c_num=clev, viewx_int=vx, viewy_int=vy, no_tone=.true. )
        end if
     else if(fig_type==2)then
        if(txtname/='')then
        call Dcl_2D_cont_shade_vec(  &
     &       trim(cont_val)//' and '//trim(shade_val)//'\_{('//trim(title_tmp)//')}',  &
     &       x(xdmin:xdmax), y(ydmin:ydmax),  &
     &       val1(xdmin:xdmax,ydmin:ydmax),  &
     &       val2(xdmin:xdmax,ydmin:ydmax),  &
     &       val3(xdmin:xdmax,ydmin:ydmax),  &
     &       val4(xdmin:xdmax,ydmin:ydmax),  &
     &       (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
     &       (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
     &       c_num=clev, viewx_int=vx, viewy_int=vy,  &
     &       xg=xd(:,1:1), yg=yd(:,1:1), no_tone=.true.,  &
     &       unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
     &       unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
        else
        call Dcl_2D_cont_shade_vec(  &
     &       trim(cont_val)//' and '//trim(shade_val)//'\_{('//trim(title_tmp)//')}',  &
     &       x(xdmin:xdmax), y(ydmin:ydmax),  &
     &       val1(xdmin:xdmax,ydmin:ydmax),  &
     &       val2(xdmin:xdmax,ydmin:ydmax),  &
     &       val3(xdmin:xdmax,ydmin:ydmax),  &
     &       val4(xdmin:xdmax,ydmin:ydmax),  &
     &       (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
     &       (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
     &       c_num=clev, viewx_int=vy, viewy_int=vy, no_tone=.true.,  &
     &       unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
     &       unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
        end if
     end if

     call DclSetParm( "GRAPH:LCLIP", .false. )
     call DclDrawMarker( (/1.0/), (/1.0/) )
     call tone_bar( clev(2), (/smin, smax/), (/vx(2)+0.025, vx(2)+0.05/),  &
  &                 vy, '(f6.1)', trigle='a',  &
  &                 col_mem_num=clev(1) )
     call DclSetParm( "GRAPH:LCLIP", .true. )

  end do

!-- draw the time series of PV (Rossby PV)
  

  call DclCloseGraphics

end program
