!-----------------------------------------------------------------------
!     Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module Thermo_Const  ! ʪ(Ǯϳ)
  ! ñ̤Ϥ٤ MKS ñ̷
  ! ͤ
  ! * ǯɽʹΩŷʸԡʿ 20 ǯ
  ! * List, R. J. 1951: Smithonian Meteorological Tables, 6th rev.
  ! * Iribarnem J. V. and W. L. Godson, 1973: Atmospheric Thermodynamics.
  ! .
  implicit none
  real, parameter :: Rd=287.0  ! 絤ε [J / K kg]
  real, parameter :: Rv=461.0  ! ε [J / K kg]
  real, parameter :: Md=28.96  ! 絤ʬ [kg / kmol]
  real, parameter :: Mv=18.0  ! ʬ [kg / kmol]
  real, parameter :: e0=611.0  ! ŸǤο [Pa]
  real, parameter :: ei0=611.73  ! ŸǤɹ˰¤Ǥξ [Pa]
  real, parameter :: Cpd=1004.0  ! 絤갵Ǯ [J / K kg]
  real, parameter :: Cpv=1870.0  ! 갵Ǯ [J / K kg]
  real, parameter :: Cvd=719.0  ! 絤Ǯ [J / K kg]
  real, parameter :: Cvv=1410.0  ! Ǯ [J / K kg]
  real, parameter :: p0=1.0e5  ! ൤ [Pa]
  real, parameter :: p00=1.01325e5  ! ɸ絤 [Pa]
  real, parameter :: LH0=2.5e6  ! Ǯ [J / kg]
  real, parameter :: LHS=2.8e6  ! ξǮ [J / kg]
  real, parameter :: LF0=3.337e5  ! 0 degC ǤοͻǮ [J / kg]
  real, parameter :: LFm40=2.357e5  ! -40 degC ǤοͻǮ [J / kg]
  real, parameter :: kalm=0.4  ! ޥ
  real, parameter :: eps_rdrv=287.0/461.0  ! ȴ絤ʬ
  real, parameter :: rhow=1.0e3  ! ̩ [kg/m^3]
  real, parameter :: t0=273.15  ! ɸ൤ǤοζŸ [K]
  real, parameter :: ti0=273.16  ! λǤζŸ [K]


end module
