program sound_1d
! 饸ιصݴ¬ǡ, 1 Υץեǡ
! , ٤ˤѡˤ CAPE Υѥ᡼׻.
! ǥǡΥեޥåȤϥƥȷΤߥݡ

  use Thermo_Const
  use Thermo_Function
  use Thermo_Advanced_Function
  use file_operate
  use Statistics
  use Basis
  use dcl
  use Dcl_Automatic
  use Dcl_Thermo_Graph

  implicit none

  real, allocatable, dimension(:) :: temp    ! 
  real, allocatable, dimension(:) :: height  ! 
  real, allocatable, dimension(:) :: pres    ! 
  real, allocatable, dimension(:) :: rh      ! м
  real, allocatable, dimension(:) :: qv      ! 
  real, allocatable, dimension(:) :: pt      ! 
  real, allocatable, dimension(:) :: ept     ! 
  real, allocatable, dimension(:) :: sept    ! ˰
  real, allocatable, dimension(:) :: ew      ! 
  real, allocatable, dimension(:) :: ww      ! 
  real, allocatable, dimension(:) :: tmp     ! ƥݥ
  real, allocatable, dimension(:,:) :: draw_tate, draw_yoko, write_data
  real, dimension(11) :: col_lev  ! ۥɥչ
  real :: height_lcl, pres_lcl  ! LCL 
  real :: height_lfc, pres_lfc  ! LFC 
  real :: height_lnb, pres_lnb  ! LNB 
  real :: cape_c  ! CAPE
  real :: cin_c  ! CIN
  real :: precip  ! Ĺ߿
  real :: z_ref  ! CAPE η׻κ, .
  real :: p_ref  ! CAPE η׻κ, ൤.
  real :: unit_v  ! ñ̥٥ȥ礭.
  real, dimension(2) :: draw_region_p, draw_region_z
  real, dimension(2) :: vx_new, vy_new
  real, dimension(6), parameter :: convx=(/0.3, 0.5, 0.55, 0.75, 0.55, 0.75/),  &
                                   convy=(/0.5, 0.8, 0.5, 0.8, 0.5, 0.8/)
  real, allocatable, dimension(:,:) :: cvx, cvy

  integer :: i, j, k, l, m, n, iz, jmax, idz_min, idz_max
  integer :: nz  ! 
  integer :: nnz  ! ǡޤȤ˻Ȥΰˤ
  integer :: nx  ! ǡο
  integer :: IWS
  integer :: cape_opt  ! CAPE ׻κ, LNB ǡüξ.
  integer, parameter :: fig_num=3  ! ޤμ
  integer, dimension(11) :: col_num  ! ۥɥչ

  character(80), allocatable, dimension(:,:) :: fname  ! ǡե̾
  character(80) :: list_name  ! ǡꥹȥե̾
  character(20), allocatable, dimension(:,:) :: cval  ! ǡɤ߹
  character(1000) :: tmp_char
  character(5) :: draw_flag  ! ޤ˴ؤե饰
  character(10) :: t_c
  character(28) :: skew_c
  character(12), allocatable, dimension(:) :: title_c, title_u
  character(1) :: refer_flag
  character(70) :: sysfont

  logical :: dmp_flag, no_draw_flag

  real :: undef
  integer, parameter :: skip_num=2

!-- namelist file ɤ߹

  namelist /input /z_ref, p_ref, cape_opt, list_name, dmp_flag, undef,  &
  &                draw_flag, draw_region_p, draw_region_z, IWS, unit_v,  &
  &                sysfont
  read(5,nml=input)

  if(z_ref==-999.0)then
     refer_flag='p'
  end if

  if(p_ref==-999.0)then
     refer_flag='z'
  end if

  no_draw_flag=.true.
  do i=1,len_trim(draw_flag)
     if(draw_flag(i:i)=='o')then
        no_draw_flag=.false.
        exit
     end if
  end do

  jmax=11

  allocate(title_c(jmax))
  allocate(title_u(jmax))
  allocate(cvx(jmax,fig_num))
  allocate(cvy(jmax,fig_num))

  title_c=(/'z\_{ref}', 'p\_{ref}', 'CAPE    ', 'CIN     ', 'PW      ',  &
  &         'z\_{LCL}', 'z\_{LFC}', 'z\_{LNB}', 'p\_{LCL}', 'p\_{LFC}',  &
  &         'p\_{LNB}'/)
  title_u=(/' m         ', ' hPa       ', ' J kg\^{-1}', ' J kg\^{-1}',  &
  &         ' mm        ', ' m         ', ' m         ', ' m         ',  &
  &         ' hPa       ', ' hPa       ', ' hPa       '/)

  do i=1,fig_num
     cvx(:,i)=convx((i-1)*2+1)+0.01
     do j=1,jmax
        cvy(j,i)=convy(2*i)-0.01-(convy(2*i)-convy(2*(i-1)+1)-0.02)  &
  &              *real(j-1)/real(jmax-1)
     end do
  end do

!-- ۥɥչѥ顼.
  call color_setting( 10, draw_region_z, col_min=15, col_max=85 )
  col_num=(/((153+7*(i-1)*10),i=1,11)/)
  col_lev=(/((draw_region_z(1)+((draw_region_z(2)-draw_region_z(1))/10.0)*real(i-1)),i=1,11)/)

!-- ɤ߹ǡեο
  nnz=line_number_counter( trim(list_name) )

  allocate(fname(2,nnz))
  allocate(write_data(nnz,jmax))

!-- DCL set
  if(no_draw_flag.eqv..false.)then
     if(len_trim(adjustl(sysfont))/=0)then
        call SGISET( 'IFONT', 1 )
        call SWLSET( 'LSYSFNT', .true. )
        write(*,*) "This drawing mode is sysfont."
     else
        call SGISET( 'IFONT', 2 )
        write(*,*) "This drawing mode is dclfont."
     end if

     call DclOpenGraphics(IWS)

     if(len_trim(adjustl(sysfont))/=0)then
!        CALL SWSLFT(sysfont)
        CALL SWCSET('FONTNAME', sysfont)
     end if

  end if

  call GLRSET('RMISS',undef)
  call GLLSET('LMISS',.true.)
  call UZFACT( 0.8 )
  call DclSetParm('ENABLE_PROPORTIONAL_FONT',.true.)

  call read_file_text( trim(list_name), 2, nnz, fname )
  
  do i=1,nnz

  if(trim(fname(1,i))/='unknown')then
!-- ƥȥեɤ߹

     nz=line_number_counter( trim(fname(1,i)) )-skip_num  ! ƥȥñ̤ʬð

!-- 

     allocate(cval(6,nz))
     allocate(height(nz))
     allocate(temp(nz))
     allocate(pres(nz))
     allocate(qv(nz))
     allocate(ew(nz))
     allocate(ww(nz))
     allocate(tmp(nz))
     allocate(pt(nz))
     allocate(ept(nz))
     allocate(sept(nz))
     allocate(draw_tate(nz,4))
     allocate(draw_yoko(nz,4))

!-- ե뤫ǡɤ߹
     call read_file_text( trim(fname(1,i)), 6, nz, cval, skip=skip_num )
     write(*,*) "reading file ", trim(fname(1,i))

!-- character -> real
     do j=1,nz
        height(j)=c2r_convert( cval(1,j) )
        pres(j)=c2r_convert( cval(2,j) )
        temp(j)=c2r_convert( cval(3,j) )
        qv(j)=c2r_convert( cval(4,j) )
        ew(j)=c2r_convert( cval(5,j) )
        ww(j)=c2r_convert( cval(6,j) )
     end do

!-- z_ref  p_ref ֤
     if(refer_flag=='p')then
        ! interpo 뤿󲽽
        do j=1,nz
           tmp(j)=pres(nz-j+1)
        end do
        call interpo_search_1d( tmp, p_ref, iz )
        call interpolation_1d( tmp(iz:iz+1), (/height(nz-iz+1),height(nz-iz)/),  &
  &                             p_ref, z_ref )
     end if

!-- p_ref  z_ref ֤
     if(refer_flag=='z')then
        ! interpo 뤿󲽽
        do j=1,nz
           tmp(j)=pres(nz-j+1)
        end do
        call interpo_search_1d( height, z_ref, iz )
        call interpolation_1d( height(iz:iz+1), (/tmp(nz-iz+1), tmp(nz-iz)/),  &
  &                             z_ref, p_ref )
     end if

!-- z_ref  p_ref ֤
!  ν¿ʬʤ.
!     if(z_ref==-999.0)then
        ! interpo 뤿󲽽
!        call interpo_search_1d( height, z_ref, iz )
!        call interpolation_1d( height(iz:iz+1), pres(iz:iz+1),  &
!  &                             z_ref, p_ref )
!     end if

!-- ή԰ѥ᡼׻
!-- 1. CAPE ׻
     cape_c=CAPE( pres, height, qv, temp, z_ref, undeff=undef, copt=cape_opt )!, opt=2 )
!     write(*,*) "MESSAGE : CAPE option is 2."

!-- 2. CIN ׻
     cin_c=CIN( pres, height, qv, temp, z_ref, undef )

!-- 3. Ĺ߿̷׻
     precip=precip_water( pres, qv, undef )

!-- 4. LCL ٷ׻
     height_lcl=z_LCL( z_ref, height, temp, pres, qv )
     call interpo_search_1d( height, height_lcl, iz, int(undef) )
     if(iz/=int(undef))then
        call interpolation_1d( height(iz:iz+1), pres(iz:iz+1),  &
  &                            height_lcl, pres_lcl )
     else
        pres_lcl=undef
     end if

!-- 5. LFC ٷ׻
     height_lfc=z_LFC( z_ref, height, temp, pres, qv )
     call interpo_search_1d( height, height_lfc, iz, int(undef) )
     if(iz/=int(undef))then
        call interpolation_1d( height(iz:iz+1), pres(iz:iz+1),  &
  &                            height_lfc, pres_lfc )
     else
        pres_lfc=undef
     end if

!-- 6. LNB ٷ׻
     height_lnb=z_LNB( z_ref, height, temp, pres, qv )
     call interpo_search_1d( height, height_lnb, iz, int(undef) )
     if(iz/=int(undef))then
        call interpolation_1d( height(iz:iz+1), pres(iz:iz+1),  &
  &                            height_lnb, pres_lnb )
     else
        pres_lnb=undef
     end if

!-- 7. ⤷, ʬ¾Υѥ᡼׻ǽ.

!-- 8. data -> array

     write_data(i,1)=z_ref
     write_data(i,2)=p_ref
     write_data(i,3)=cape_c
     write_data(i,4)=cin_c
     write_data(i,5)=precip
     write_data(i,6)=height_lcl
     write_data(i,7)=height_lfc
     write_data(i,8)=height_lnb
     write_data(i,9)=pres_lcl
     write_data(i,10)=pres_lfc
     write_data(i,11)=pres_lnb

!-- ʬۺʬ
     if(draw_flag(1:1)/='x')then
        do j=1,nz
           if(temp(j)/=undef.and.qv(j)/=undef.and.pres(j)/=undef)then
              pt(j)=theta_dry( temp(j), pres(j) )
              ept(j)=thetae_Bolton( temp(j), qv(j), pres(j) )
              sept(j)=thetaes_Bolton( temp(j), pres(j) )
           else
              pt(j)=undef
              ept(j)=undef
              sept(j)=undef
           end if
           do k=1,3
              draw_tate(j,k)=height(j)
           end do
           draw_yoko(j,1)=pt(j)
           draw_yoko(j,2)=ept(j)
           draw_yoko(j,3)=sept(j)
        end do
     end if

!-- ۥɥʬۺʬ
     if(draw_flag(5:5)=='o')then
        do j=1,nz
           draw_tate(j,1)=height(j)
           if(ew(j)/=undef.and.ww(j)/=undef)then
              draw_yoko(j,4)=ew(j)
              draw_tate(j,4)=ww(j)
           else
              draw_yoko(j,4)=undef
              draw_tate(j,4)=undef
           end if
        end do
     end if

!-- skew-T ץåȺʬ

     if(draw_flag(1:1)=='o')then
        call DclSetParm( 'GRAPH:LCLIP', .true. )
        call Dcl_PL( 'l', trim(fname(2,i)),  &
  &                  draw_yoko(:,1:3), draw_tate(:,1:3),  &
  &                  draw_yoko(:,1:3), draw_tate(:,1:3),  &
  &                  (/achar(241)//'(black), '//achar(241)//'\_{e}(red), '//  &
  &                    achar(241)//'\_{es}(green)  (K)', 'height (m)'/),  &
  &                  x_int=(/280.0, 380.0/), y_int=draw_region_z,  &
  &                  viewx_int=(/0.3, 0.7/), viewy_int=(/0.2, 0.8/),  &
  &                  l_idx=(/14,24,34/) )
        if(draw_flag(3:3)=='o')then
           call DclSetParm( 'GRAPH:LCLIP', .false. )
           CALL SGQVPT( vx_new(1), vx_new(2), vy_new(1), vy_new(2) )
           call axis_vec( draw_region_z, vx_new(2)+0.01, pres, ew, ww,  &
  &                       sondeZ=height, undef=undef, vn=20,  &
  &                       view_int=vy_new,  &
  &                       unit_flag=.true., unity=unit_v,  &
  &                       u_posi=(/vx_new(2)+0.1,vy_new(1)-0.025/),  &
  &                       uni_len=0.05 )
        end if
        if(draw_flag(4:4)=='o')then
           call Dcl_Square_Normal( convx(1:2), convy(1:2), 12, 999999 )
           do j=1,jmax
              if(trim(adjustl(title_u(j)))=='hPa'.and.write_data(i,j)/=undef)then
                 skew_c=trim(title_c(j))//r2c_convert( write_data(i,j)*1.0e-2, '(f8.1)' )
              else
                 skew_c=trim(title_c(j))//r2c_convert( write_data(i,j), '(f8.1)' )
              end if
              skew_c=trim(skew_c)//trim(title_u(j))
              call DclDrawTextNormalized( cvx(j,1), cvy(j,1), trim(skew_c),  &
  &                                    height=0.0125, centering=-1 )
           end do
        end if
     end if

     if(draw_flag(2:2)=='o')then
        call DclSetParm( 'GRAPH:LCLIP', .true. )
        call SkewT( trim(fname(2,i)), 30.0, (/245.0, 305.0/),  &
  &                 draw_region_p, temp, pres, qv, height,  &
  &                 undef=undef, refh=p_ref, heiopt=.false. )
        if(draw_flag(3:3)=='o')then
           call DclSetParm( 'GRAPH:LCLIP', .false. )
           CALL SGQVPT( vx_new(1), vx_new(2), vy_new(1), vy_new(2) )
           call axis_vec( draw_region_p, vx_new(2)+0.01, pres, ew, ww,  &
  &                       undef=undef, view_int=vy_new,  &
  &                       unit_flag=.true., unity=unit_v,  &
  &                       u_posi=(/vx_new(2)+0.1,vy_new(1)-0.025/),  &
  &                       uni_len=0.05 )
        end if
        if(draw_flag(4:4)=='o')then
           call Dcl_Square_Normal( convx(3:4), convy(3:4), 12, 999999 )
           do j=1,jmax
              if(trim(adjustl(title_u(j)))=='hPa'.and.write_data(i,j)/=undef)then
                 skew_c=trim(title_c(j))//r2c_convert( write_data(i,j)*1.0e-2, '(f8.1)' )
              else
                 skew_c=trim(title_c(j))//r2c_convert( write_data(i,j), '(f8.1)' )
              end if
              skew_c=trim(skew_c)//trim(title_u(j))
              call DclDrawTextNormalized( cvx(j,2), cvy(j,2), trim(skew_c),  &
  &                                    height=0.0125, centering=-1 )
           end do
        end if
     end if

!-- ۥɥʬ

     if(draw_flag(5:5)=='o')then
        call interpo_search_1d( height, draw_region_z(1), idz_min )
        if(idz_min<1)then
           idz_min=1
        end if
        !-- Only Hodograph operation
        write(*,*) "#### MESSAGE ###"
        write(*,*) "At Hodograph : the lowest point is forced to vanish."
        draw_tate(idz_min,4)=0.0
        draw_yoko(idz_min,4)=0.0
        draw_yoko(idz_min,1)=0.0
        call interpo_search_1d( height, draw_region_z(2), idz_max )

        call Dcl_PL( 'l', trim(fname(2,i)),  &
  &                  draw_yoko(idz_min:idz_max,4:4),  &
  &                  draw_tate(idz_min:idz_max,4:4),  &
  &                  draw_yoko(idz_min:idz_max,4:4),  &
  &                  draw_tate(idz_min:idz_max,4:4),  &
  &                  (/'Zonal Wind', 'Meridional Wind'/),  &
  &                  cl_val=col_lev, cl_idx=col_num,  &
  &                  zline=draw_tate(idz_min:idz_max,1:1) )
                     ! draw_tate Ͼ Ema ǹ٤ȤƻȤäƤ.
        CALL SGQVPT( vx_new(1), vx_new(2), vy_new(1), vy_new(2) )
        call tone_bar( 10, draw_region_z,  &
  &                    (/vx_new(2)+0.025, vx_new(2)+0.05/), vy_new,  &
  &                    '(f8.2)', col_mem_num=10,  &
  &                    title='height [m]', titles='t', titlep=0.0 )
     end if

     deallocate(cval)
     deallocate(height)
     deallocate(temp)
     deallocate(pres)
     deallocate(qv)
     deallocate(ew)
     deallocate(ww)
     deallocate(tmp)
     deallocate(pt)
     deallocate(ept)
     deallocate(sept)
     deallocate(draw_tate)
     deallocate(draw_yoko)

  else
     do j=1,jmax
        write_data(i,j)=undef
     end do
  end if
  end do

  if(no_draw_flag.eqv..false.)then
     call DclCloseGraphics
  end if

!-- 10. Ƽѥ᡼Υƥȥǡ¸

  if(dmp_flag.eqv..true.)then  ! ήѥ᡼ƥȥǡȤ¸.

     open(unit=10,file='convec_parm'//trim(list_name),status='unknown')
     tmp_char="'data name' "//"'reference height' "//"'reference pressure' "  &
  &                   //"'CAPE' "//  &
  &                   "'CIN' "//"'precipitable water' "//  &
  &                   "'LCL height' "//"'LFC height' "//"'LNB height' "//  &
  &                   "'LCL pressure' "//"'LFC pressure' "//"'LNB pressure' "
     t_c=trim( adjustl(i2c_convert( len_trim(tmp_char) )) )
     write(10,'(a'//trim(t_c)//')') trim(tmp_char)
     tmp_char=''
     t_c=''
     tmp_char="'character' "//"'m' "//"'Pa' "//"'"//'J kg^{-1}'//"' "//  &
  &                   "'"//'J kg^{-1}'//"' "//"'mm' "//"'m' "//"'m' "//  &
  &                   "'m' "//"'Pa' "//"'Pa' "//"'Pa' " 
     t_c=trim( adjustl( i2c_convert( len_trim(tmp_char) ) ) )
     write(10,'(a'//trim(t_c)//')') trim(tmp_char)

     tmp_char='('
     t_c=''

     tmp_char='(a20,1P'//trim( adjustl( i2c_convert( jmax ) ) )//'E16.8)'
write(*,*) "format", trim(tmp_char)

     do i=1,nnz
!        write(10,'(a20,1000f)') trim(fname(2,i)), (write_data(i,j),j=1,jmax)
        write(10,trim(tmp_char)) trim( adjustl( fname(2,i) ) ),  &
  &                              (write_data(i,j),j=1,jmax)
!     write(10,'(a20,1000f)') trim(fname(2,i)), z_ref, p_ref, cape_c, cin_c,  &
!     write(10,'(a20,1000f)') trim(fname(2,i)), z_ref, p_ref, cape_c,  &
!     write(10,*) trim(fname(2,i)), z_ref, p_ref, cape_c,  &
!  &                           precip, height_lcl, height_lfc, height_lnb,  &
!  &                           pres_lcl, pres_lfc, pres_lnb
     end do

     write(*,*) "CLOSED"

     close(unit=10,status='keep')

  end if

end program
