#
# test02.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


nx = 19
ny = 19
xmin = 0
xmax = 360
ymin = -90
ymax = +90
drad = PI/180
dz = 0.05
dp = 0.2
p = NArray.new(Float, nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

rmiss = DCL::glrget('RMISS')
DCL::sglset('LSOFTF', false)

DCL::grfrm
DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.1, 0.9, 0.1, 0.9)
DCL::grssim(0.4, 0.0, 0.0)
DCL::grsmpl(165.0, 60.0, 0.0)
DCL::grstxy(-180.0, 180.0, 0.0, 90.0)
DCL::grstrn(30)
DCL::grstrf
DCL::sglset('LCLIP', true)

DCL::uestlv(rmiss, -dp, 201)
DCL::uestlv(dp, dp*2, 401)
DCL::uestlv(dp*2, rmiss, 402)
DCL::uetone(p)

DCL::udgclb(p, dp)
DCL::udcntr(p)

DCL::umpmap('coast_world')
DCL::umpglb

DCL::grcls

