from http.server import HTTPServer, SimpleHTTPRequestHandler
import os
import subprocess
import sys
import threading


with HTTPServer(('127.0.0.1', 0), SimpleHTTPRequestHandler) as http_server:
    http_port = str(http_server.socket.getsockname()[1])
    data_url = f'http://localhost:{http_port}/xmltoolingtest/data/'
    daemon = threading.Thread(target=http_server.serve_forever)
    daemon.start()
    result = subprocess.run(sys.argv[1:], env=os.environ | {'XMLTOOLINGTEST_DATA_URL': data_url})
    http_server.shutdown()
    daemon.join()
sys.exit(result.returncode)
