/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.browser;

import java.applet.Applet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import vrml.eai.Browser;
import vrml.eai.BrowserFactoryImpl;
import vrml.eai.ConnectionException;
import vrml.eai.NoSuchBrowserException;
import vrml.eai.NotSupportedException;
import vrml.eai.VrmlComponent;

public class VRMLBrowserFactoryImpl
implements BrowserFactoryImpl {
    private static final boolean PREFER_JAVA3D = false;
    private static BrowserFactoryImpl networkFactory;
    private static BrowserFactoryImpl openglFactory;
    private static BrowserFactoryImpl java3dFactory;
    private static BrowserFactoryImpl defaultFactory;
    private static final String NULL_PARAMETER_ERROR = "Null parameter strings not allowed.";
    private static final String MALFORMED_PARAMETER_STRING_ERROR = "Malformed parameter string.  Expecting strings of the form A=B";
    private static final String RENDERER_TYPE_PARAM = "Xj3D_RendererType";
    private static final String NETWORK_FACTORY_CLASS = "org.web3d.vrml.scripting.external.neteai.NetworkBrowserFactoryImpl";
    private static final String OPENGL_FACTORY_CLASS = "org.xj3d.ui.awt.browser.ogl.VRMLOGLBrowserFactoryImpl";
    private static final String JAVA3D_FACTORY_CLASS = "org.xj3d.ui.awt.browser.ogl.J3DBrowserFactoryImpl";

    public VrmlComponent createComponent(String[] stringArray) throws NotSupportedException {
        Map map;
        String string;
        BrowserFactoryImpl browserFactoryImpl = defaultFactory;
        if (stringArray != null && stringArray.length != 0 && (string = (String)(map = this.parseParameters(stringArray)).get(RENDERER_TYPE_PARAM)) != null) {
            if (string.equalsIgnoreCase("opengl")) {
                browserFactoryImpl = openglFactory;
            } else if (string.equalsIgnoreCase("java3d")) {
                browserFactoryImpl = java3dFactory;
            }
        }
        if (browserFactoryImpl == null) {
            browserFactoryImpl = defaultFactory;
        }
        return browserFactoryImpl.createComponent(stringArray);
    }

    public Browser getBrowser(Applet applet) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        throw new NotSupportedException();
    }

    public Browser getBrowser(Applet applet, String string, int n) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        throw new NotSupportedException();
    }

    public Browser getBrowser(InetAddress inetAddress, int n) throws NotSupportedException, NoSuchBrowserException, UnknownHostException, ConnectionException {
        if (networkFactory != null) {
            return networkFactory.getBrowser(inetAddress, n);
        }
        throw new NotSupportedException();
    }

    private Map parseParameters(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new IllegalArgumentException(NULL_PARAMETER_ERROR);
            }
            int n = stringArray[i].indexOf(61);
            if (n < 1) {
                throw new IllegalArgumentException(MALFORMED_PARAMETER_STRING_ERROR);
            }
            hashMap.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
        }
        return hashMap;
    }

    static {
        try {
            openglFactory = (BrowserFactoryImpl)Class.forName(OPENGL_FACTORY_CLASS).newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        try {
            java3dFactory = (BrowserFactoryImpl)Class.forName(JAVA3D_FACTORY_CLASS).newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        try {
            networkFactory = (BrowserFactoryImpl)Class.forName(NETWORK_FACTORY_CLASS).newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        defaultFactory = openglFactory != null ? openglFactory : java3dFactory;
    }
}

