#!/usr/bin/env python3
# DESCRIPTION: Verilator: Verilog Test driver/expect definition
#
# Copyright 2024 by Wilson Snyder. This program is free software; you
# can redistribute it and/or modify it under the terms of either the GNU
# Lesser General Public License Version 3 or the Perl Artistic License
# Version 2.0.
# SPDX-License-Identifier: LGPL-3.0-only OR Artistic-2.0

import vltest_bootstrap

test.scenarios('vlt')
test.top_filename = "t/t_waiveroutput.v"

out_filename = test.obj_dir + "/" + test.name + ".waiver_gen.out"
waiver_filename = "t/t_waiveroutput.vlt"

test.lint(v_flags2=[
    waiver_filename, '-Wall', '-Wno-fatal', '--waiver-multiline', '--waiver-output', out_filename
])

test.files_identical(out_filename, test.golden_filename)

test.passes()
