/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.ArraysListOfLong;
import cds.healpix.CompassPoint;
import cds.healpix.FlatHashList;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.NeighbourSelector;
import cds.healpix.NewtonMethod;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.sphgeom.Cone;
import cds.healpix.common.sphgeom.CooXYZ;
import cds.healpix.common.sphgeom.Polygon;
import java.util.Arrays;
import java.util.EnumMap;

public final class HealpixNestedPolygonComputer {
    private final int depthMax;
    private final HealpixNested hnDepthMax;
    private final HashComputer hcDepthMax;
    private final HashComputer[] hcs;
    private final VerticesAndPathComputer[] vpcs;
    private final NeighbourSelector[] neiSelect;
    private final EnumMap<CompassPoint.Cardinal, double[]> vertices = new EnumMap(CompassPoint.Cardinal.class);
    private CooXYZ vertexN;
    private CooXYZ vertexE;
    private CooXYZ vertexS;
    private CooXYZ vertexW;
    private final FlatHashList neigs;
    private static final AdditionalCheck ALWAYS_OK = new AdditionalCheck(){

        @Override
        public boolean isOk(Polygon poly, long hash) {
            return true;
        }
    };
    private final AdditionalCheck centerInPoly;

    HealpixNestedPolygonComputer(HealpixNested healpixNestedAtDepthMax) {
        this.depthMax = healpixNestedAtDepthMax.depth;
        this.hnDepthMax = healpixNestedAtDepthMax;
        this.hcDepthMax = this.hnDepthMax.newHashComputer();
        this.hcs = new HashComputer[this.depthMax + 1];
        this.vpcs = new VerticesAndPathComputer[this.depthMax + 1];
        this.neiSelect = new NeighbourSelector[this.depthMax + 1];
        this.neigs = new FlatHashList(this.depthMax, 12);
        this.vertices.put(CompassPoint.Cardinal.N, new double[2]);
        this.vertices.put(CompassPoint.Cardinal.E, new double[2]);
        this.vertices.put(CompassPoint.Cardinal.S, new double[2]);
        this.vertices.put(CompassPoint.Cardinal.W, new double[2]);
        this.centerInPoly = new AdditionalCheck(){
            private final VerticesAndPathComputer vpc;
            {
                this.vpc = HealpixNestedPolygonComputer.this.getVPC(HealpixNestedPolygonComputer.this.depthMax);
            }

            @Override
            public boolean isOk(Polygon poly, long hash) {
                double[] ccoos = this.vpc.center(hash);
                CooXYZ cellCenter = new CooXYZ(ccoos[0], ccoos[1]);
                return poly.contains(cellCenter);
            }
        };
    }

    private HashComputer getHC(int depth) {
        int deltaDepth = this.depthMax - depth;
        HashComputer hc = this.hcs[deltaDepth];
        if (hc == null) {
            this.hcs[deltaDepth] = hc = Healpix.getNested(depth).newHashComputer();
        }
        return hc;
    }

    private VerticesAndPathComputer getVPC(int depth) {
        int deltaDepth = this.depthMax - depth;
        VerticesAndPathComputer vpc = this.vpcs[deltaDepth];
        if (vpc == null) {
            this.vpcs[deltaDepth] = vpc = Healpix.getNested(depth).newVerticesAndPathComputer();
        }
        return vpc;
    }

    private NeighbourSelector getNeigSelect(int depth) {
        int deltaDepth = this.depthMax - depth;
        NeighbourSelector nei = this.neiSelect[deltaDepth];
        if (nei == null) {
            this.neiSelect[deltaDepth] = nei = Healpix.getNested(depth).newNeighbourSelector();
        }
        return nei;
    }

    public HealpixNestedBMOC overlappingCells(double[][] vertices) {
        return this.overlapping(vertices, ALWAYS_OK);
    }

    public HealpixNestedBMOC overlappingCenters(double[][] vertices) {
        return this.overlapping(vertices, this.centerInPoly);
    }

    private HealpixNestedBMOC overlapping(double[][] vertices, AdditionalCheck check) {
        CooXYZ[] polyVertices = HealpixNestedPolygonComputer.buildArrayOfCooXYZ(vertices);
        Polygon poly = new Polygon(polyVertices);
        Cone boundingCone = CooXYZ.boundingCone(polyVertices);
        int startingDepth = Healpix.getBestStartingDepth(boundingCone.radiusRad());
        if ((startingDepth = Math.min(startingDepth, this.depthMax)) == -1) {
            this.neigs.clear();
            this.neigs.put(0L).put(1L).put(2L).put(3L).put(4L).put(5L).put(6L).put(7L).put(8L).put(9L).put(10L).put(11L);
            startingDepth = 0;
        } else {
            long hashCenter = this.getHC(startingDepth).hash(boundingCone.lon(), boundingCone.lat());
            this.getNeigSelect(startingDepth).neighbours(hashCenter, this.neigs);
            this.neigs.put(hashCenter);
            this.neigs.sortByHashAsc();
        }
        long[] polyVerticesHash = this.buildOrderedArrayOfPolyVerticesAndSpecialPointsHash(polyVertices);
        ArraysListOfLong moc = new ArraysListOfLong(10000);
        for (int i = 0; i < this.neigs.size; ++i) {
            long icell = this.neigs.get(i);
            this.buildMocRecursively(moc, startingDepth, icell, poly, polyVerticesHash, check);
        }
        return HealpixNestedBMOC.createUnsafe(this.depthMax, moc.a, moc.size());
    }

    private void buildMocRecursively(ArraysListOfLong moc, int depth, long hash, Polygon poly, long[] polyVerticesHash, AdditionalCheck check) {
        int nVerticesInPoly = 0;
        if (this.isInList(depth, hash, polyVerticesHash) || (nVerticesInPoly = this.nVerticesInPoly(depth, hash, poly)) > 0 && nVerticesInPoly < 4 || this.hasIntersection(depth, hash, poly)) {
            if (depth == this.depthMax) {
                if (check.isOk(poly, hash)) {
                    moc.add(HealpixNestedBMOC.buildValue(depth, hash, false, this.depthMax));
                }
            } else {
                this.buildMocRecursively(moc, ++depth, hash <<= 2, poly, polyVerticesHash, check);
                this.buildMocRecursively(moc, depth, ++hash, poly, polyVerticesHash, check);
                this.buildMocRecursively(moc, depth, ++hash, poly, polyVerticesHash, check);
                this.buildMocRecursively(moc, depth, ++hash, poly, polyVerticesHash, check);
            }
        } else if (nVerticesInPoly == 4) {
            moc.add(HealpixNestedBMOC.buildValue(depth, hash, true, this.depthMax));
        }
    }

    private boolean hasIntersection(int depth, long hash, Polygon poly) {
        return poly.intersectSegAB(this.vertexN, this.vertexE) || poly.intersectSegAB(this.vertexS, this.vertexE) || poly.intersectSegAB(this.vertexW, this.vertexN) || poly.intersectSegAB(this.vertexW, this.vertexS);
    }

    private int nVerticesInPoly(int depth, long hash, Polygon poly) {
        VerticesAndPathComputer vpc = this.getVPC(depth);
        vpc.vertices(hash, this.vertices);
        double[] vcoos = this.vertices.get((Object)CompassPoint.Cardinal.N);
        this.vertexN = new CooXYZ(vcoos[0], vcoos[1]);
        vcoos = this.vertices.get((Object)CompassPoint.Cardinal.E);
        this.vertexE = new CooXYZ(vcoos[0], vcoos[1]);
        vcoos = this.vertices.get((Object)CompassPoint.Cardinal.S);
        this.vertexS = new CooXYZ(vcoos[0], vcoos[1]);
        vcoos = this.vertices.get((Object)CompassPoint.Cardinal.W);
        this.vertexW = new CooXYZ(vcoos[0], vcoos[1]);
        int nIn = 0;
        if (poly.contains(this.vertexN)) {
            ++nIn;
        }
        if (poly.contains(this.vertexE)) {
            ++nIn;
        }
        if (poly.contains(this.vertexS)) {
            ++nIn;
        }
        if (poly.contains(this.vertexW)) {
            ++nIn;
        }
        return nIn;
    }

    private boolean isInList(int depth, long hash, long[] polyVerticesHash) {
        int twiceDeltaDepth = this.depthMax - depth << 1;
        long hashAtDepthMax = hash << twiceDeltaDepth;
        int i = Arrays.binarySearch(polyVerticesHash, hashAtDepthMax);
        return i >= 0 || (i = -i - 1) < polyVerticesHash.length && polyVerticesHash[i] >> twiceDeltaDepth == hash || i > 0 && polyVerticesHash[--i] >> twiceDeltaDepth == hash;
    }

    private static final CooXYZ[] buildArrayOfCooXYZ(double[][] vertices) {
        CooXYZ[] polyVertices = new CooXYZ[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            double[] lonlat = vertices[i];
            polyVertices[i] = new CooXYZ(lonlat[0], lonlat[1]);
        }
        return polyVertices;
    }

    private final long[] buildOrderedArrayOfPolyVerticesAndSpecialPointsHash(CooXYZ[] polyVertices) {
        long[] polyVerticesAndSpeicalPointsHash = new long[polyVertices.length << 1];
        int k = 0;
        int i = 0;
        int j = polyVertices.length - 1;
        while (i < polyVertices.length) {
            for (CooXYZ v : NewtonMethod.arcSpecialPoints(polyVertices[i], polyVertices[j], 1.0E-14, 20)) {
                polyVerticesAndSpeicalPointsHash[k++] = this.hcDepthMax.hash(v.lon(), v.lat());
            }
            j = i++;
        }
        for (i = 0; i < polyVertices.length; ++i) {
            CooXYZ polyVertex = polyVertices[i];
            polyVerticesAndSpeicalPointsHash[k++] = this.hcDepthMax.hash(polyVertex.lon(), polyVertex.lat());
        }
        Arrays.sort(polyVerticesAndSpeicalPointsHash, 0, k);
        int l = 0;
        for (int i2 = 1; i2 < l; ++i2) {
            if (polyVerticesAndSpeicalPointsHash[i2] == polyVerticesAndSpeicalPointsHash[k]) continue;
            polyVerticesAndSpeicalPointsHash[++k] = polyVerticesAndSpeicalPointsHash[i2];
        }
        return Arrays.copyOf(polyVerticesAndSpeicalPointsHash, ++k);
    }

    private static interface AdditionalCheck {
        public boolean isOk(Polygon var1, long var2);
    }
}

