/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.skiplist.test;

import edu.jhu.skiplist.SkipList;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;

public class TestSkipList
extends TestCase {
    public static final float[] PROBABILITY = new float[]{0.5f};
    public static final int[] INITIAL_LOAD = new int[]{20000, 40000, 80000};
    public static final boolean[] INPUT_IS_SORTED = new boolean[]{false, true};
    public static final int NUM_OF_TEST_OPERATIONS = 1000;
    static /* synthetic */ Class class$edu$jhu$skiplist$test$TestSkipList;

    public TestSkipList(String string) {
        super(string);
    }

    public void testInsert() {
        long l = 0xC0400000000L;
        SkipList skipList = new SkipList(0.5f);
        skipList.insert(l, 33L);
        long l2 = skipList.search(l);
        Assert.assertTrue((String)"Insert failed ", (l2 > -1L ? 1 : 0) != 0);
    }

    public void testAll() {
        int n = 0;
        while (n < INPUT_IS_SORTED.length) {
            String string = INPUT_IS_SORTED[n] ? "sorted." : "random order.";
            System.out.println("Keys are " + string);
            int n2 = 0;
            while (n2 < INITIAL_LOAD.length) {
                System.out.println("  Size of list: " + INITIAL_LOAD[n2] + " elements.");
                Random random = new Random(1234L);
                int[] nArray = new int[INITIAL_LOAD[n2]];
                int n3 = 0;
                while (n3 < INITIAL_LOAD[n2]) {
                    nArray[n3] = INPUT_IS_SORTED[n] ? n3 : Math.abs(random.nextInt() - 1);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < PROBABILITY.length) {
                    System.out.println("    Probability: " + PROBABILITY[n4]);
                    float f = PROBABILITY[n4];
                    int n5 = INITIAL_LOAD[n2];
                    int n6 = (int)Math.ceil(Math.log(n5) / Math.log(1.0f / f)) - 1;
                    SkipList skipList = new SkipList(f, n6);
                    int n7 = 0;
                    while (n7 < INITIAL_LOAD[n2]) {
                        skipList.insert(nArray[n7], 0L);
                        ++n7;
                    }
                    long l = System.currentTimeMillis();
                    long l2 = 0L;
                    int n8 = 0;
                    while (n8 < 1000) {
                        l2 = skipList.search(nArray[n8]);
                        Assert.assertTrue((String)"Insert failed ", (l2 > -1L ? 1 : 0) != 0);
                        ++n8;
                    }
                    long l3 = System.currentTimeMillis();
                    float f2 = l3 - l;
                    System.out.println("      Search took " + f2 / 1000.0f + " ms per element.");
                    l = System.currentTimeMillis();
                    int n9 = 0;
                    while (n9 < 1000) {
                        skipList.delete(nArray[n9]);
                        l2 = skipList.search(nArray[n9]);
                        Assert.assertEquals((String)"Delete failed ", (long)l2, (long)-1L);
                        ++n9;
                    }
                    l3 = System.currentTimeMillis();
                    f2 = l3 - l;
                    System.out.println("      Delete took " + f2 / 1000.0f + " ms per element.");
                    l = System.currentTimeMillis();
                    int n10 = 0;
                    while (n10 < 1000) {
                        skipList.insert(nArray[n10], 0L);
                        ++n10;
                    }
                    l3 = System.currentTimeMillis();
                    f2 = l3 - l;
                    System.out.println("      Insert took " + f2 / 1000.0f + " ms per element.");
                    System.out.println();
                    ++n4;
                }
                ++n2;
            }
            ++n;
        }
    }

    public static Test suite() {
        return new TestSuite(class$edu$jhu$skiplist$test$TestSkipList == null ? (class$edu$jhu$skiplist$test$TestSkipList = TestSkipList.class$("edu.jhu.skiplist.test.TestSkipList")) : class$edu$jhu$skiplist$test$TestSkipList);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{(class$edu$jhu$skiplist$test$TestSkipList == null ? (class$edu$jhu$skiplist$test$TestSkipList = TestSkipList.class$("edu.jhu.skiplist.test.TestSkipList")) : class$edu$jhu$skiplist$test$TestSkipList).getName()};
        TestRunner.main((String[])stringArray2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

