// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from UserManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.usermgmt {
  public class UserManager_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("usermgmt.UserManager:1.0.1", null);

    public UserManager_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public UserManager_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new UserManager_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new UserManager_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_USER_DOESNT_EXIST = 1;

    public const int ERR_USER_NOT_DELETABLE = 2;

    public const int ERR_USER_ALREADY_EXISTS = 1;

    public const int ERR_MAX_USERS_REACHED = 2;

    public const int ERR_PASSWORD_TOO_SHORT_FOR_SNMP = 3;

    public const int ERR_INVALID_VALUE = 4;

    public const int ERR_INVALID_PASSWORD = 5;

    public class GetAccountNamesResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public GetAccountNamesResult getAccountNames() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAccountNames", _parameters);
      var _ret = new GetAccountNamesResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest getAccountNames(AsyncRpcResponse<GetAccountNamesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAccountNames(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAccountNames(AsyncRpcResponse<GetAccountNamesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAccountNames", _parameters,
        _result => {
          try {
            var _ret = new GetAccountNamesResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class CreateAccountResult {
      public int _ret_;
    }

    public CreateAccountResult createAccount(string username, string password) {
      var _parameters = new LightJson.JsonObject();
      _parameters["username"] = username;
      _parameters["password"] = password;

      var _result = RpcCall("createAccount", _parameters);
      var _ret = new CreateAccountResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest createAccount(string username, string password, AsyncRpcResponse<CreateAccountResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return createAccount(username, password, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest createAccount(string username, string password, AsyncRpcResponse<CreateAccountResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["username"] = username;
        _parameters["password"] = password;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("createAccount", _parameters,
        _result => {
          try {
            var _ret = new CreateAccountResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteAccountResult {
      public int _ret_;
    }

    public DeleteAccountResult deleteAccount(string username) {
      var _parameters = new LightJson.JsonObject();
      _parameters["username"] = username;

      var _result = RpcCall("deleteAccount", _parameters);
      var _ret = new DeleteAccountResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteAccount(string username, AsyncRpcResponse<DeleteAccountResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteAccount(username, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteAccount(string username, AsyncRpcResponse<DeleteAccountResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["username"] = username;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteAccount", _parameters,
        _result => {
          try {
            var _ret = new DeleteAccountResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAllAccountsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.usermgmt.Account> _ret_;
    }

    public GetAllAccountsResult getAllAccounts() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAllAccounts", _parameters);
      var _ret = new GetAllAccountsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.usermgmt.Account>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.usermgmt.Account.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getAllAccounts(AsyncRpcResponse<GetAllAccountsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAllAccounts(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAllAccounts(AsyncRpcResponse<GetAllAccountsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAllAccounts", _parameters,
        _result => {
          try {
            var _ret = new GetAllAccountsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.usermgmt.Account>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.usermgmt.Account.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class CreateAccountFullResult {
      public int _ret_;
    }

    public CreateAccountFullResult createAccountFull(string username, string password, Com.Raritan.Idl.usermgmt.UserInfo info) {
      var _parameters = new LightJson.JsonObject();
      _parameters["username"] = username;
      _parameters["password"] = password;
      _parameters["info"] = info.Encode();

      var _result = RpcCall("createAccountFull", _parameters);
      var _ret = new CreateAccountFullResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest createAccountFull(string username, string password, Com.Raritan.Idl.usermgmt.UserInfo info, AsyncRpcResponse<CreateAccountFullResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return createAccountFull(username, password, info, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest createAccountFull(string username, string password, Com.Raritan.Idl.usermgmt.UserInfo info, AsyncRpcResponse<CreateAccountFullResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["username"] = username;
        _parameters["password"] = password;
        _parameters["info"] = info.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("createAccountFull", _parameters,
        _result => {
          try {
            var _ret = new CreateAccountFullResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAccountsByRoleResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.usermgmt.Account> _ret_;
    }

    public GetAccountsByRoleResult getAccountsByRole(string roleName) {
      var _parameters = new LightJson.JsonObject();
      _parameters["roleName"] = roleName;

      var _result = RpcCall("getAccountsByRole", _parameters);
      var _ret = new GetAccountsByRoleResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.usermgmt.Account>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.usermgmt.Account.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getAccountsByRole(string roleName, AsyncRpcResponse<GetAccountsByRoleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAccountsByRole(roleName, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAccountsByRole(string roleName, AsyncRpcResponse<GetAccountsByRoleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["roleName"] = roleName;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getAccountsByRole", _parameters,
        _result => {
          try {
            var _ret = new GetAccountsByRoleResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.usermgmt.Account>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.usermgmt.Account.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDefaultPreferencesResult {
      public Com.Raritan.Idl.usermgmt.Preferences _ret_;
    }

    public GetDefaultPreferencesResult getDefaultPreferences() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDefaultPreferences", _parameters);
      var _ret = new GetDefaultPreferencesResult();
      _ret._ret_ = Com.Raritan.Idl.usermgmt.Preferences.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getDefaultPreferences(AsyncRpcResponse<GetDefaultPreferencesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDefaultPreferences(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDefaultPreferences(AsyncRpcResponse<GetDefaultPreferencesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDefaultPreferences", _parameters,
        _result => {
          try {
            var _ret = new GetDefaultPreferencesResult();
            _ret._ret_ = Com.Raritan.Idl.usermgmt.Preferences.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetDefaultPreferencesResult {
      public int _ret_;
    }

    public SetDefaultPreferencesResult setDefaultPreferences(Com.Raritan.Idl.usermgmt.Preferences prefs) {
      var _parameters = new LightJson.JsonObject();
      _parameters["prefs"] = prefs.Encode();

      var _result = RpcCall("setDefaultPreferences", _parameters);
      var _ret = new SetDefaultPreferencesResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setDefaultPreferences(Com.Raritan.Idl.usermgmt.Preferences prefs, AsyncRpcResponse<SetDefaultPreferencesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setDefaultPreferences(prefs, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setDefaultPreferences(Com.Raritan.Idl.usermgmt.Preferences prefs, AsyncRpcResponse<SetDefaultPreferencesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["prefs"] = prefs.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setDefaultPreferences", _parameters,
        _result => {
          try {
            var _ret = new SetDefaultPreferencesResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
