// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class CommonSettings : ICloneable {
    public object Clone() {
      CommonSettings copy = new CommonSettings();
      copy.dns = this.dns;
      copy.routing = this.routing;
      copy.portForwarding = this.portForwarding;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["dns"] = this.dns.Encode();
      json["routing"] = this.routing.Encode();
      json["portForwarding"] = this.portForwarding.Encode();
      return json;
    }

    public static CommonSettings Decode(LightJson.JsonObject json, Agent agent) {
      CommonSettings inst = new CommonSettings();
      inst.dns = Com.Raritan.Idl.net.DnsSettings.Decode(json["dns"], agent);
      inst.routing = Com.Raritan.Idl.net.RoutingSettings.Decode(json["routing"], agent);
      inst.portForwarding = Com.Raritan.Idl.net.PortForwardingSettings.Decode(json["portForwarding"], agent);
      return inst;
    }

    public Com.Raritan.Idl.net.DnsSettings dns = new Com.Raritan.Idl.net.DnsSettings();
    public Com.Raritan.Idl.net.RoutingSettings routing = new Com.Raritan.Idl.net.RoutingSettings();
    public Com.Raritan.Idl.net.PortForwardingSettings portForwarding = new Com.Raritan.Idl.net.PortForwardingSettings();
  }
}
