% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-expires.R
\name{cutoff}
\alias{cutoff}
\alias{expires}
\alias{replyby}
\title{Set or query message expiry or reply-by time}
\usage{
expires(msg, datetime = NULL, tz = "")

replyby(msg, datetime = NULL, tz = "")
}
\arguments{
\item{msg}{A message object.}

\item{datetime}{Date and time.}

\item{tz}{A character string specifying the time zone.}
}
\value{
A message object.
}
\description{
Functions to specify the time at which a message expires or by which a reply
is requested.
}
\details{
Manipulate the \code{Expires} and \code{Reply-By} fields as specified in
\href{https://www.ietf.org/rfc/rfc2156.txt}{RFC 2156}.
}
\examples{
envelope() \%>\%
  expires("2030-01-01 13:25:00", "UTC")
envelope() \%>\%
  replyby("2021-12-25 06:00:00", "GMT")
}
