% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_splitBy.R
\name{by-split}
\alias{by-split}
\alias{split_by}
\alias{splitBy}
\alias{head.splitByData}
\alias{tail.splitByData}
\alias{split_by.legacy}
\alias{splitBy.legacy}
\title{Split a data frame}
\usage{
split_by(data, ..., omit = TRUE)

splitBy(formula, data, omit = TRUE)

\method{head}{splitByData}(x, n = 6L, ...)

\method{tail}{splitByData}(x, n = 6L, ...)

split_by.legacy(data, formula, drop = TRUE)

splitBy.legacy(formula, data = parent.frame(), drop = TRUE)
}
\arguments{
\item{data}{A data frame}

\item{...}{A character vector or, right hand sided formula or a
listing of variables.}

\item{omit}{Logical Should variables split on be omitted from the
output. Defaults to TRUE.}

\item{formula}{A character vector or a right hand sided formula.}

\item{x}{An object.}

\item{n}{A single integer.  If positive or zero, size for the
resulting object: number of elements for a vector (including
lists), rows for a matrix or data frame or lines for a
function.  If negative, all but the "n" last/first number of
elements of "x".}

\item{drop}{Obsolete}
}
\value{
A list of dataframes.
}
\description{
Split a dataframe according to the levels of variables
in the dataframe. The variables to split by can be given as a
formula or as a character vector.
}
\examples{

split_by(CO2, ~Treatment+Type)
split_by(CO2, Treatment, Type)
split_by(CO2, c("Treatment", "Type"))
split_by(CO2, Treatment)
x <- CO2 |> split_by(~Treatment)
head(x, 3)
tail(x, 3)

x <- CO2 |> split_by(~Treatment, omit=FALSE)
head(x, 3)
tail(x, 3)

## The "Old" interface
splitBy(~Treatment+Type, CO2)
splitBy(~Treatment+Type, data=CO2)
splitBy(c("Treatment", "Type"), data=CO2)

}
\seealso{
\code{\link{orderBy}}, \code{\link{order_by}},
\code{\link{summaryBy}}, \code{\link{summary_by}},
\code{\link{transformBy}}, \code{\link{transform_by}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
