# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class AccessTokenList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, service_sid):
        """
        Initialize the AccessTokenList

        :param Version version: Version that contains the resource
        :param service_sid: Verify Service Sid.

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenList
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenList
        """
        super(AccessTokenList, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, }
        self._uri = '/Services/{service_sid}/AccessTokens'.format(**self._solution)

    def create(self, identity, factor_type, factor_friendly_name=values.unset,
               ttl=values.unset):
        """
        Create the AccessTokenInstance

        :param unicode identity: Unique external identifier of the Entity
        :param AccessTokenInstance.FactorTypes factor_type: The Type of this Factor
        :param unicode factor_friendly_name: The factor friendly name
        :param unicode ttl: How long, in seconds, the access token is valid.

        :returns: The created AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        """
        data = values.of({
            'Identity': identity,
            'FactorType': factor_type,
            'FactorFriendlyName': factor_friendly_name,
            'Ttl': ttl,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return AccessTokenInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def get(self, sid):
        """
        Constructs a AccessTokenContext

        :param sid: A string that uniquely identifies this Access Token.

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenContext
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenContext
        """
        return AccessTokenContext(self._version, service_sid=self._solution['service_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a AccessTokenContext

        :param sid: A string that uniquely identifies this Access Token.

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenContext
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenContext
        """
        return AccessTokenContext(self._version, service_sid=self._solution['service_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.AccessTokenList>'


class AccessTokenPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the AccessTokenPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param service_sid: Verify Service Sid.

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenPage
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenPage
        """
        super(AccessTokenPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of AccessTokenInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        """
        return AccessTokenInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.AccessTokenPage>'


class AccessTokenContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, service_sid, sid):
        """
        Initialize the AccessTokenContext

        :param Version version: Version that contains the resource
        :param service_sid: Service Sid.
        :param sid: A string that uniquely identifies this Access Token.

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenContext
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenContext
        """
        super(AccessTokenContext, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, 'sid': sid, }
        self._uri = '/Services/{service_sid}/AccessTokens/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the AccessTokenInstance

        :returns: The fetched AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return AccessTokenInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Verify.V2.AccessTokenContext {}>'.format(context)


class AccessTokenInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class FactorTypes(object):
        PUSH = "push"

    def __init__(self, version, payload, service_sid, sid=None):
        """
        Initialize the AccessTokenInstance

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        """
        super(AccessTokenInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'service_sid': payload.get('service_sid'),
            'entity_identity': payload.get('entity_identity'),
            'factor_type': payload.get('factor_type'),
            'factor_friendly_name': payload.get('factor_friendly_name'),
            'token': payload.get('token'),
            'url': payload.get('url'),
            'ttl': deserialize.integer(payload.get('ttl')),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
        }

        # Context
        self._context = None
        self._solution = {'service_sid': service_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: AccessTokenContext for this AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenContext
        """
        if self._context is None:
            self._context = AccessTokenContext(
                self._version,
                service_sid=self._solution['service_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def sid(self):
        """
        :returns: A string that uniquely identifies this Access Token.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: Account Sid.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def service_sid(self):
        """
        :returns: Verify Service Sid.
        :rtype: unicode
        """
        return self._properties['service_sid']

    @property
    def entity_identity(self):
        """
        :returns: Unique external identifier of the Entity
        :rtype: unicode
        """
        return self._properties['entity_identity']

    @property
    def factor_type(self):
        """
        :returns: The Type of the Factor
        :rtype: AccessTokenInstance.FactorTypes
        """
        return self._properties['factor_type']

    @property
    def factor_friendly_name(self):
        """
        :returns: A human readable description of this factor.
        :rtype: unicode
        """
        return self._properties['factor_friendly_name']

    @property
    def token(self):
        """
        :returns: Generated access token.
        :rtype: unicode
        """
        return self._properties['token']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def ttl(self):
        """
        :returns: How long, in seconds, the access token is valid.
        :rtype: unicode
        """
        return self._properties['ttl']

    @property
    def date_created(self):
        """
        :returns: The date this access token was created
        :rtype: datetime
        """
        return self._properties['date_created']

    def fetch(self):
        """
        Fetch the AccessTokenInstance

        :returns: The fetched AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Verify.V2.AccessTokenInstance {}>'.format(context)
