# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AppliedScopeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Applied Scope."""

    SINGLE = "Single"
    SHARED = "Shared"


class CalculateExchangeOperationResultStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the operation."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    PENDING = "Pending"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DisplayProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represent the current display state of the Reservation."""

    SUCCEEDED = "Succeeded"
    EXPIRING = "Expiring"
    EXPIRED = "Expired"
    PENDING = "Pending"
    PROCESSING = "Processing"
    CANCELLED = "Cancelled"
    FAILED = "Failed"


class ErrorResponseCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ErrorResponseCode."""

    NOT_SPECIFIED = "NotSpecified"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    SERVER_TIMEOUT = "ServerTimeout"
    AUTHORIZATION_FAILED = "AuthorizationFailed"
    BAD_REQUEST = "BadRequest"
    CLIENT_CERTIFICATE_THUMBPRINT_NOT_SET = "ClientCertificateThumbprintNotSet"
    INVALID_REQUEST_CONTENT = "InvalidRequestContent"
    OPERATION_FAILED = "OperationFailed"
    HTTP_METHOD_NOT_SUPPORTED = "HttpMethodNotSupported"
    INVALID_REQUEST_URI = "InvalidRequestUri"
    MISSING_TENANT_ID = "MissingTenantId"
    INVALID_TENANT_ID = "InvalidTenantId"
    INVALID_RESERVATION_ORDER_ID = "InvalidReservationOrderId"
    INVALID_RESERVATION_ID = "InvalidReservationId"
    RESERVATION_ID_NOT_IN_RESERVATION_ORDER = "ReservationIdNotInReservationOrder"
    RESERVATION_ORDER_NOT_FOUND = "ReservationOrderNotFound"
    INVALID_SUBSCRIPTION_ID = "InvalidSubscriptionId"
    INVALID_ACCESS_TOKEN = "InvalidAccessToken"
    INVALID_LOCATION_ID = "InvalidLocationId"
    UNAUTHENTICATED_REQUESTS_THROTTLED = "UnauthenticatedRequestsThrottled"
    INVALID_HEALTH_CHECK_TYPE = "InvalidHealthCheckType"
    FORBIDDEN = "Forbidden"
    BILLING_SCOPE_ID_CANNOT_BE_CHANGED = "BillingScopeIdCannotBeChanged"
    APPLIED_SCOPES_NOT_ASSOCIATED_WITH_COMMERCE_ACCOUNT = "AppliedScopesNotAssociatedWithCommerceAccount"
    PATCH_VALUES_SAME_AS_EXISTING = "PatchValuesSameAsExisting"
    ROLE_ASSIGNMENT_CREATION_FAILED = "RoleAssignmentCreationFailed"
    RESERVATION_ORDER_CREATION_FAILED = "ReservationOrderCreationFailed"
    RESERVATION_ORDER_NOT_ENABLED = "ReservationOrderNotEnabled"
    CAPACITY_UPDATE_SCOPES_FAILED = "CapacityUpdateScopesFailed"
    UNSUPPORTED_RESERVATION_TERM = "UnsupportedReservationTerm"
    RESERVATION_ORDER_ID_ALREADY_EXISTS = "ReservationOrderIdAlreadyExists"
    RISK_CHECK_FAILED = "RiskCheckFailed"
    CREATE_QUOTE_FAILED = "CreateQuoteFailed"
    ACTIVATE_QUOTE_FAILED = "ActivateQuoteFailed"
    NONSUPPORTED_ACCOUNT_ID = "NonsupportedAccountId"
    PAYMENT_INSTRUMENT_NOT_FOUND = "PaymentInstrumentNotFound"
    MISSING_APPLIED_SCOPES_FOR_SINGLE = "MissingAppliedScopesForSingle"
    NO_VALID_RESERVATIONS_TO_RE_RATE = "NoValidReservationsToReRate"
    RE_RATE_ONLY_ALLOWED_FOR_EA = "ReRateOnlyAllowedForEA"
    OPERATION_CANNOT_BE_PERFORMED_IN_CURRENT_STATE = "OperationCannotBePerformedInCurrentState"
    INVALID_SINGLE_APPLIED_SCOPES_COUNT = "InvalidSingleAppliedScopesCount"
    INVALID_FULFILLMENT_REQUEST_PARAMETERS = "InvalidFulfillmentRequestParameters"
    NOT_SUPPORTED_COUNTRY = "NotSupportedCountry"
    INVALID_REFUND_QUANTITY = "InvalidRefundQuantity"
    PURCHASE_ERROR = "PurchaseError"
    BILLING_CUSTOMER_INPUT_ERROR = "BillingCustomerInputError"
    BILLING_PAYMENT_INSTRUMENT_SOFT_ERROR = "BillingPaymentInstrumentSoftError"
    BILLING_PAYMENT_INSTRUMENT_HARD_ERROR = "BillingPaymentInstrumentHardError"
    BILLING_TRANSIENT_ERROR = "BillingTransientError"
    BILLING_ERROR = "BillingError"
    FULFILLMENT_CONFIGURATION_ERROR = "FulfillmentConfigurationError"
    FULFILLMENT_OUT_OF_STOCK_ERROR = "FulfillmentOutOfStockError"
    FULFILLMENT_TRANSIENT_ERROR = "FulfillmentTransientError"
    FULFILLMENT_ERROR = "FulfillmentError"
    CALCULATE_PRICE_FAILED = "CalculatePriceFailed"
    APPLIED_SCOPES_SAME_AS_EXISTING = "AppliedScopesSameAsExisting"
    SELF_SERVICE_REFUND_NOT_SUPPORTED = "SelfServiceRefundNotSupported"
    REFUND_LIMIT_EXCEEDED = "RefundLimitExceeded"


class ExchangeOperationResultStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the operation."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    PENDING_REFUNDS = "PendingRefunds"
    PENDING_PURCHASES = "PendingPurchases"


class InstanceFlexibility(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Turning this on will apply the reservation discount to other VMs in the same VM size group.
    Only specify for VirtualMachines reserved resource type.
    """

    ON = "On"
    OFF = "Off"


class Location(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Location in which the Resources needs to be reserved. It cannot be changed after the resource
    has been created.
    """

    WESTUS = "westus"
    EASTUS = "eastus"
    EASTUS2 = "eastus2"
    NORTHCENTRALUS = "northcentralus"
    WESTUS2 = "westus2"
    SOUTHCENTRALUS = "southcentralus"
    CENTRALUS = "centralus"
    WESTEUROPE = "westeurope"
    NORTHEUROPE = "northeurope"
    EASTASIA = "eastasia"
    SOUTHEASTASIA = "southeastasia"
    JAPANEAST = "japaneast"
    JAPANWEST = "japanwest"
    BRAZILSOUTH = "brazilsouth"
    AUSTRALIAEAST = "australiaeast"
    AUSTRALIASOUTHEAST = "australiasoutheast"
    SOUTHINDIA = "southindia"
    WESTINDIA = "westindia"
    CENTRALINDIA = "centralindia"
    CANADACENTRAL = "canadacentral"
    CANADAEAST = "canadaeast"
    UKSOUTH = "uksouth"
    WESTCENTRALUS = "westcentralus"
    UKWEST = "ukwest"


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the individual operation."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    PENDING = "Pending"


class PaymentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes whether the payment is completed, failed, cancelled or scheduled in the future."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    SCHEDULED = "Scheduled"
    CANCELLED = "Cancelled"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represent the current state of the Reservation."""

    CREATING = "Creating"
    PENDING_RESOURCE_HOLD = "PendingResourceHold"
    CONFIRMED_RESOURCE_HOLD = "ConfirmedResourceHold"
    PENDING_BILLING = "PendingBilling"
    CONFIRMED_BILLING = "ConfirmedBilling"
    CREATED = "Created"
    SUCCEEDED = "Succeeded"
    CANCELLED = "Cancelled"
    EXPIRED = "Expired"
    BILLING_FAILED = "BillingFailed"
    FAILED = "Failed"
    SPLIT = "Split"
    MERGED = "Merged"


class QuotaRequestState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The quota request status."""

    ACCEPTED = "Accepted"
    INVALID = "Invalid"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    IN_PROGRESS = "InProgress"


class ReservationBillingPlan(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represent the billing plans."""

    UPFRONT = "Upfront"
    MONTHLY = "Monthly"


class ReservationStatusCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ReservationStatusCode."""

    NONE = "None"
    PENDING = "Pending"
    PROCESSING = "Processing"
    ACTIVE = "Active"
    PURCHASE_ERROR = "PurchaseError"
    PAYMENT_INSTRUMENT_ERROR = "PaymentInstrumentError"
    SPLIT = "Split"
    MERGED = "Merged"
    EXPIRED = "Expired"
    SUCCEEDED = "Succeeded"


class ReservationTerm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represent the term of Reservation."""

    P1_Y = "P1Y"
    P3_Y = "P3Y"
    P5_Y = "P5Y"


class ReservedResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the resource that is being reserved."""

    VIRTUAL_MACHINES = "VirtualMachines"
    SQL_DATABASES = "SqlDatabases"
    SUSE_LINUX = "SuseLinux"
    COSMOS_DB = "CosmosDb"
    RED_HAT = "RedHat"
    SQL_DATA_WAREHOUSE = "SqlDataWarehouse"
    V_MWARE_CLOUD_SIMPLE = "VMwareCloudSimple"
    RED_HAT_OSA = "RedHatOsa"
    DATABRICKS = "Databricks"
    APP_SERVICE = "AppService"
    MANAGED_DISK = "ManagedDisk"
    BLOCK_BLOB = "BlockBlob"
    REDIS_CACHE = "RedisCache"
    AZURE_DATA_EXPLORER = "AzureDataExplorer"
    MY_SQL = "MySql"
    MARIA_DB = "MariaDb"
    POSTGRE_SQL = "PostgreSql"
    DEDICATED_HOST = "DedicatedHost"
    SAP_HANA = "SapHana"
    SQL_AZURE_HYBRID_BENEFIT = "SqlAzureHybridBenefit"
    AVS = "AVS"
    DATA_FACTORY = "DataFactory"
    NET_APP_STORAGE = "NetAppStorage"
    AZURE_FILES = "AzureFiles"
    SQL_EDGE = "SqlEdge"
    VIRTUAL_MACHINE_SOFTWARE = "VirtualMachineSoftware"


class ResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The resource types."""

    STANDARD = "standard"
    DEDICATED = "dedicated"
    LOW_PRIORITY = "lowPriority"
    SHARED = "shared"
    SERVICE_SPECIFIC = "serviceSpecific"


class UserFriendlyAppliedScopeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The applied scope type."""

    NONE = "None"
    SHARED = "Shared"
    SINGLE = "Single"
    RESOURCE_GROUP = "ResourceGroup"
    MANAGEMENT_GROUP = "ManagementGroup"


class UserFriendlyRenewState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The renew state of the reservation."""

    ON = "On"
    OFF = "Off"
    RENEWED = "Renewed"
    NOT_RENEWED = "NotRenewed"
    NOT_APPLICABLE = "NotApplicable"
