/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DAVSequenceGenerator;
import com.sourceforge.knecs.dsm.dsi.test.ThreadTester;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;

public class TestDAVSequenceGenerator {
    public static void main(String[] args) {
        System.out.println("In TestDAVSequenceGenerator.");
        if (args.length < 5) {
            System.err.println("Need user, password, path, property name, and property namespace");
            System.err.println("Usage: TestDAVSequenceGenerator <username> <password> <path> <propertyname> <propnamespace>");
            System.exit(-1);
        }
        String user = args[0];
        String password = args[1];
        String path = args[2];
        String propertyName = args[3];
        String propertyNameSpace = args[4];
        NSProperty nsprop = new NSProperty(propertyNameSpace, propertyName);
        DAVSequenceGenerator gen = new DAVSequenceGenerator(path, nsprop, user, password);
        System.out.println("Generate 20 IDs sequentially.");
        try {
            for (int i = 0; i < 20; ++i) {
                int nextID = gen.next();
                System.out.println(nextID);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.out.println(LoggerUtils.getStackTrace(ex));
        }
        System.out.println("Create 4 threads and generate IDs.");
        new ThreadTester("one", user, password, path, propertyName, propertyNameSpace).start();
        new ThreadTester("two", user, password, path, propertyName, propertyNameSpace).start();
        new ThreadTester("three", user, password, path, propertyName, propertyNameSpace).start();
        new ThreadTester("four", user, password, path, propertyName, propertyNameSpace).start();
    }
}

