/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Array containing the first 100,000 prime numbers.
*
* @module @stdlib/datasets/primes-100k
*
* @example
* var primes = require( '@stdlib/datasets/primes-100k' );
*
* var list = primes();
* // returns [ 2, 3, 5, ... ]
*/

// MODULES //

var primes = require( './main.js' );


// EXPORTS //

module.exports = primes;
