<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Natural Logarithm of Square Root 2π

> [Natural logarithm][@stdlib/math/base/special/ln] of the [square root][@stdlib/math/base/special/sqrt] of [2π][@stdlib/constants/float64/pi].

<section class="usage">

## Usage

```javascript
var LN_SQRT_TWO_PI = require( '@stdlib/constants/float64/ln-sqrt-two-pi' );
```

#### LN_SQRT_TWO_PI

[Natural logarithm][@stdlib/math/base/special/ln] of the [square root][@stdlib/math/base/special/sqrt] of [2π][@stdlib/constants/float64/pi].

```javascript
var bool = ( LN_SQRT_TWO_PI === 0.9189385332046728 );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better example -->

<!-- eslint no-undef: "error" -->

```javascript
var LN_SQRT_TWO_PI = require( '@stdlib/constants/float64/ln-sqrt-two-pi' );

console.log( LN_SQRT_TWO_PI );
// => 0.9189385332046728
```

</section>

<!-- /.examples -->

<section class="links">

[@stdlib/constants/float64/pi]: https://github.com/stdlib-js/constants/tree/main/float64/pi

[@stdlib/math/base/special/ln]: https://github.com/stdlib-js/math-base-special-ln

[@stdlib/math/base/special/sqrt]: https://github.com/stdlib-js/math-base-special-sqrt

</section>

<!-- /.links -->
