/*
 * Copyright 2015 Palantir Technologies, Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import "@blueprintjs/test-commons/bootstrap";

// components
import "./alert/alertTests";
import "./breadcrumbs/breadcrumbsTests";
import "./breadcrumbs/breadcrumbTests";
import "./buttons/buttonTests";
import "./callout/calloutTests";
import "./card/cardTests";
import "./collapse/collapseTests";
import "./collapsible-list/collapsibleListTests";
import "./common/propsTests";
import "./common/utils/compareUtilsTests";
import "./common/utilsTests";
import "./context-menu/contextMenuTests";
import "./controls/controlsTests";
import "./controls/inputGroupTests";
import "./controls/numericInputTests";
import "./controls/radioGroupTests";
import "./dialog/dialogTests";
import "./drawer/drawerTests";
import "./editable-text/editableTextTests";
import "./forms/asyncControllableInputTests";
import "./forms/fileInputTests";
import "./forms/formGroupTests";
import "./forms/textAreaTests";
import "./hotkeys/hotkeysTests";
import "./html-select/htmlSelectTests";
import "./icon/iconTests";
import "./menu/menuItemTests";
import "./menu/menuTests";
import "./multistep-dialog/multistepDialogTests";
import "./non-ideal-state/nonIdealStateTests";
import "./overflow-list/overflowListTests";
import "./overlay/overlayTests";
import "./panel-stack/panelStackTests";
import "./panel-stack2/panelStack2Tests";
import "./popover/popoverTests";
import "./popover/popperUtilTests";
import "./portal/portalTests";
import "./progress/progressBarTests";
import "./resize-sensor/resizeSensorTests";
import "./slider/handleTests";
import "./slider/multiSliderTests";
import "./slider/rangeSliderTests";
import "./slider/sliderTests";
import "./spinner/spinnerTests";
import "./tabs/tabsTests";
import "./tag-input/tagInputTests";
import "./tag/tagTests";
import "./text/textTests";
import "./toast/toasterTests";
import "./toast/toastTests";
import "./tooltip/tooltipTests";
import "./tree/treeTests";

// hooks
import "./hooks/useHotkeysTests";
