# Contributing to mlpack

mlpack is a community-led project; that means that anyone is welcome to
contribute to mlpack and join the community!  If you would like to make
improvements to the library, add new features that are useful to you and others,
or have found a bug that you know how to fix, please submit a pull request!

If you would like to learn more about how to get started contributing, see the
[Community](https://www.mlpack.org/doc/developer/community.html) page, and if you are
interested in participating in Google Summer of Code, see
[mlpack and Google Summer of Code](http://www.mlpack.org/doc/developer/gsoc.html).

## Pull request process

Once a pull request is submitted, it must be approved by at least one member of
mlpack's Contributors team, to ensure that (if applicable):

 * the design meshes with the rest of mlpack
 * the style matches the
   [Style Guide](http://github.com/mlpack/mlpack/wiki/DesignGuidelines)
 * any new functionality is tested and working

The pull request can be merged as soon as it receives two approvals; 24 hours
after the first approval, mlpack-bot will provide a second approval.  This is to
leave time for anyone to comment on the PR before it is merged.

Members of the Contributors team are encouraged to review pull requests that
have already been reviewed, and pull request contributors are encouraged to seek
multiple reviews.  Reviews from anyone not on the Contributors team are always
appreciated and encouraged!

## Reviewing Pull Requests

All mlpack contributors who choose to review and provide feedback on pull
requests have a responsibility to both the project and the individual making
the contribution. 

Reviews and feedback should be
[helpful, insightful, and geared towards improving the contribution](
  https://www.youtube.com/watch?v=NNXk_WJzyMI).
If there are reasons why you feel the PR should not be merged, explain
what those are. Be open to having your mind changed. Be open to
working with the contributor to make the pull request better.

Please don't leave dismissive or disrespectful reviews!  It's not helpful for
anyone.

When reviewing a pull request, the primary goals are:

- For the codebase/project to improve
- For the person submitting the request to succeed

Even if a pull request does not get merged, the submitters should come away
from the experience feeling like their effort was not wasted or unappreciated.
Every pull request from a new contributor is an opportunity to grow the community. 

When changes are necessary, request them, do not demand them, and do not assume
that the contributor already knows how to do that. Be there to lend a helping
hand in case of need.

Since there can sometimes be a lot more pull requests being opened than
reviewed, we highly encourage everyone to review each others pull request
keeping in mind all the above mentioned points.

Let's welcome new contributors with ❤️.

## Pull Request Waiting Time 

mlpack is a community-driven project, so everyone only works on it in their
free time; this means it may take some time for them to review pull requests.
While gentle reminders are welcome, please be patient and avoid constantly
messaging contributors or tagging them on pull requests.

Typically small PRs will be reviewed within a handful of days; larger PRs might
take a few weeks for an initial review, and it may be a little bit longer in 
times of high activity.
