/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;

public final class VirtualMachine {
    final String name;
    final File home;
    final File execPath;
    final ImmutableMap<String, String> arguments;
    final ImmutableList<String> verboseModeArgs;

    public static VirtualMachine hostVm() {
        String home = System.getProperty("java.home");
        String executable = home + "/bin/java";
        String baseName = home.replaceFirst("/jre$", "").replaceFirst(".*/", "");
        return new VirtualMachine(baseName, home, executable, (Map<String, String>)ImmutableMap.of(), (List<String>)ImmutableList.of());
    }

    public static VirtualMachine from(String name, String home, Map<String, String> argMap, List<String> verboseModeArgs) {
        return new VirtualMachine(name, home, home + "/bin/java", argMap, verboseModeArgs);
    }

    public VirtualMachine(String name, String home, String execPath, Map<String, String> arguments, List<String> verboseModeArgs) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.home = new File((String)Preconditions.checkNotNull((Object)home));
        this.execPath = new File((String)Preconditions.checkNotNull((Object)execPath));
        this.arguments = ImmutableMap.copyOf(arguments);
        this.verboseModeArgs = ImmutableList.copyOf(verboseModeArgs);
    }

    ImmutableMap<String, String> detectProperties() {
        return ImmutableMap.of();
    }

    public boolean equals(Object object) {
        if (object instanceof VirtualMachine) {
            VirtualMachine that = (VirtualMachine)object;
            return this.name.equals(that.name) && this.execPath.equals(that.execPath) && this.arguments.equals(that.arguments);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.execPath, this.arguments});
    }

    public String toString() {
        return this.name;
    }
}

