/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.util.Util;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CaliperRc {
    private final ImmutableMap<String, String> props;

    static CaliperRc create(Map<String, String> overrides, Map<String, String> defaults) {
        HashMap map = Maps.newHashMap(defaults);
        map.putAll(overrides);
        Iterables.removeIf(map.values(), (Predicate)Predicates.equalTo((Object)""));
        return new CaliperRc(map);
    }

    public CaliperRc(Map<String, String> props) {
        this.props = ImmutableMap.copyOf(props);
    }

    public String vmBaseDirectory() {
        return (String)this.props.get((Object)"vm.baseDirectory");
    }

    public ImmutableMap<String, String> globalDefaultVmArgs() {
        return this.submap("vm.args.jdk");
    }

    public String homeDirForVm(String name) {
        return (String)this.props.get((Object)("vm." + name + ".home"));
    }

    public ImmutableMap<String, String> vmArgsForVm(String vmName) {
        return this.submap("vm." + vmName + ".args");
    }

    public List<String> verboseArgsForVm(String vmName) {
        String verboseArgs = (String)this.props.get((Object)("vm." + vmName + ".verboseMode"));
        if (verboseArgs == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Splitter.on((char)' ').split((CharSequence)verboseArgs));
    }

    public String instrumentClassName(String instrumentName) {
        return (String)this.props.get((Object)("instrument." + instrumentName + ".class"));
    }

    public ImmutableMap<String, String> instrumentOptions(String instrumentName) {
        return this.submap("instrument." + instrumentName + ".options");
    }

    public ImmutableMap<String, String> vmArgsForInstrument(String instrumentName) {
        return this.submap("instrument." + instrumentName + ".vmArgs.jdk");
    }

    public String getProperty(String propertyName) {
        return (String)this.props.get((Object)propertyName);
    }

    private ImmutableMap<String, String> submap(String name) {
        return Util.prefixedSubmap(this.props, name + ".");
    }
}

