/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.Benchmark;
import com.google.caliper.runner.CaliperRc;
import com.google.caliper.runner.CaliperRcManager;
import com.google.caliper.runner.CaliperRun;
import com.google.caliper.runner.DefaultConsoleWriter;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.ParsedOptions;
import com.google.caliper.util.InvalidCommandException;
import com.google.common.collect.ObjectArrays;
import java.io.File;
import java.io.PrintWriter;

public final class CaliperMain {
    public static void main(Class<? extends Benchmark> benchmarkClass, String[] args) {
        CaliperMain.main((String[])ObjectArrays.concat((Object[])args, (Object)benchmarkClass.getName()));
    }

    static void main(String[] args) {
        PrintWriter writer = new PrintWriter(System.out);
        int code = 1;
        try {
            CaliperMain.exitlessMain(args, writer);
            code = 0;
        }
        catch (InvalidCommandException e) {
            e.display(writer);
            code = e.exitCode();
        }
        catch (InvalidBenchmarkException e) {
            e.display(writer);
        }
        catch (Throwable t) {
            t.printStackTrace(writer);
            writer.println();
            writer.println("An unexpected exception has been thrown by the caliper runner.");
            writer.println("Please see https://sites.google.com/site/caliperusers/issues");
        }
        writer.flush();
        System.exit(code);
    }

    public static void exitlessMain(String[] args, PrintWriter writer) throws InvalidCommandException, InvalidBenchmarkException {
        ParsedOptions options = ParsedOptions.from(args);
        CaliperRc rc = CaliperRcManager.loadOrCreate(new File(options.caliperRcFilename()));
        DefaultConsoleWriter console = new DefaultConsoleWriter(writer);
        CaliperRun run = new CaliperRun(options, rc, console);
        run.run();
        writer.flush();
    }
}

