/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.NewValue;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class NewMeasurement {
    private final NewValue value;
    private final double weight;
    private final String description;

    private NewMeasurement(Builder builder) {
        this.value = builder.value;
        this.description = builder.description;
        this.weight = builder.weight;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NewMeasurement) {
            NewMeasurement that = (NewMeasurement)obj;
            return this.value.equals(that.value) && this.weight == that.weight && this.description.equals(that.description);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.weight, this.description});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("value", (Object)this.value).add("weight", this.weight).add("description", (Object)this.description).toString();
    }

    public NewValue value() {
        return this.value;
    }

    public double weight() {
        return this.weight;
    }

    public String description() {
        return this.description;
    }

    public static final class Builder {
        private NewValue value;
        private Double weight;
        private String description;

        public Builder value(NewValue value) {
            this.value = (NewValue)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder weight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description);
            return this;
        }

        public NewMeasurement build() {
            Preconditions.checkArgument((this.value != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.weight != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.description != null ? 1 : 0) != 0);
            return new NewMeasurement(this);
        }
    }
}

