/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import java.io.PrintStream;

final class CountingPrintStream
extends PrintStream {
    private final PrintStream delegate;
    private int count;

    CountingPrintStream(PrintStream delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean checkError() {
        return this.delegate.checkError();
    }

    @Override
    protected void setError() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void clearError() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(int b) {
        ++this.count;
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        this.count += length;
        this.delegate.write(buffer, offset, length);
    }

    @Override
    public void print(char[] chars) {
        this.count += chars.length;
        this.delegate.print(chars);
    }

    @Override
    public void print(String s) {
        this.count += s.length();
        this.delegate.print(s);
    }
}

