; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=powerpc64-unknown-linux-gnu -mcpu=a2 -S -passes=loop-vectorize -vectorize-memory-check-threshold=60 < %s -o - | FileCheck %s

; The case will do aggressive interleave on PowerPC, resulting in a lot of memory checks.
; (On the A2, always unroll aggressively. In fact, if aggressive interleaving is enabled,
; similar issues may occur on other targets).
; Interleaving should also be restricted by the threshold of memory checks similar to VF.
; (e.g., runtime-memory-check-threshold, default 8).

; CHECK-LABEL: @eddy_diff_caleddy_
; CHECK-NOT: vector.memcheck

define fastcc void @eddy_diff_caleddy_(ptr %wet_cl, i64 %0, i32 %ncol.cast.val) {
entry:
  %trip.count = add nuw i32 %ncol.cast.val, 1
  %wide.trip.count = zext i32 %ncol.cast.val to i64
  %1 = shl i64 %0, 1
  %2 = mul i64 %0, 3
  %3 = shl i64 %0, 2
  %4 = mul i64 %0, 5
  %5 = mul i64 %0, 6
  %6 = mul i64 %0, 7
  %7 = shl i64 %0, 3
  %8 = mul i64 %0, 9
  %9 = mul i64 %0, 10
  %10 = mul i64 %0, 11
  %11 = mul i64 %0, 12
  br label %loop.body

loop.body:
  %indvars.iv774 = phi i64 [ 0, %entry ], [ %indvars.iv.next775, %loop.body ]
  %12 = add nsw i64 %indvars.iv774, -5
  %13 = add i64 %12, %0
  %14 = getelementptr i64, ptr %wet_cl, i64 %13
  store double 0.000000e+00, ptr %14, align 8
  %15 = add i64 %12, %1
  %16 = getelementptr i64, ptr %wet_cl, i64 %15
  store double 0.000000e+00, ptr %16, align 8
  %17 = add i64 %12, %2
  %18 = getelementptr i64, ptr %wet_cl, i64 %17
  store double 0.000000e+00, ptr %18, align 8
  %19 = add i64 %12, %3
  %20 = getelementptr i64, ptr %wet_cl, i64 %19
  store double 0.000000e+00, ptr %20, align 8
  %21 = add i64 %12, %4
  %22 = getelementptr i64, ptr %wet_cl, i64 %21
  store double 0.000000e+00, ptr %22, align 8
  %23 = add i64 %12, %5
  %24 = getelementptr i64, ptr %wet_cl, i64 %23
  store double 0.000000e+00, ptr %24, align 8
  %25 = add i64 %12, %6
  %26 = getelementptr i64, ptr %wet_cl, i64 %25
  store double 0.000000e+00, ptr %26, align 8
  %27 = add i64 %12, %7
  %28 = getelementptr i64, ptr %wet_cl, i64 %27
  store double 0.000000e+00, ptr %28, align 8
  %29 = add i64 %12, %8
  %30 = getelementptr i64, ptr %wet_cl, i64 %29
  store double 0.000000e+00, ptr %30, align 8
  %31 = add i64 %12, %9
  %32 = getelementptr i64, ptr %wet_cl, i64 %31
  store double 0.000000e+00, ptr %32, align 8
  %33 = add i64 %12, %10
  %34 = getelementptr i64, ptr %wet_cl, i64 %33
  store double 0.000000e+00, ptr %34, align 8
  %35 = add i64 %12, %11
  %36 = getelementptr i64, ptr %wet_cl, i64 %35
  store double 0.000000e+00, ptr %36, align 8
  %indvars.iv.next775 = add nuw nsw i64 %indvars.iv774, 1
  %exitcond778.not = icmp eq i64 %indvars.iv.next775, %wide.trip.count
  br i1 %exitcond778.not, label %loop.end, label %loop.body

loop.end:
  ret void
}
