; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define double @std_cabs([2 x double] %z) {
; CHECK-LABEL: @std_cabs(
; CHECK-NEXT:    [[CALL:%.*]] = tail call double @cabs([2 x double] [[Z:%.*]])
; CHECK-NEXT:    ret double [[CALL]]
;
  %call = tail call double @cabs([2 x double] %z)
  ret double %call
}

define float @std_cabsf([2 x float] %z) {
; CHECK-LABEL: @std_cabsf(
; CHECK-NEXT:    [[CALL:%.*]] = tail call float @cabsf([2 x float] [[Z:%.*]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = tail call float @cabsf([2 x float] %z)
  ret float %call
}

define fp128 @std_cabsl([2 x fp128] %z) {
; CHECK-LABEL: @std_cabsl(
; CHECK-NEXT:    [[CALL:%.*]] = tail call fp128 @cabsl([2 x fp128] [[Z:%.*]])
; CHECK-NEXT:    ret fp128 [[CALL]]
;
  %call = tail call fp128 @cabsl([2 x fp128] %z)
  ret fp128 %call
}

define double @fast_cabs([2 x double] %z) {
; CHECK-LABEL: @fast_cabs(
; CHECK-NEXT:    [[REAL:%.*]] = extractvalue [2 x double] [[Z:%.*]], 0
; CHECK-NEXT:    [[IMAG:%.*]] = extractvalue [2 x double] [[Z]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast double [[REAL]], [[REAL]]
; CHECK-NEXT:    [[TMP2:%.*]] = fmul fast double [[IMAG]], [[IMAG]]
; CHECK-NEXT:    [[TMP3:%.*]] = fadd fast double [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast double @llvm.sqrt.f64(double [[TMP3]])
; CHECK-NEXT:    ret double [[CABS]]
;
  %call = tail call fast double @cabs([2 x double] %z)
  ret double %call
}

define float @fast_cabsf([2 x float] %z) {
; CHECK-LABEL: @fast_cabsf(
; CHECK-NEXT:    [[REAL:%.*]] = extractvalue [2 x float] [[Z:%.*]], 0
; CHECK-NEXT:    [[IMAG:%.*]] = extractvalue [2 x float] [[Z]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast float [[REAL]], [[REAL]]
; CHECK-NEXT:    [[TMP2:%.*]] = fmul fast float [[IMAG]], [[IMAG]]
; CHECK-NEXT:    [[TMP3:%.*]] = fadd fast float [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast float @llvm.sqrt.f32(float [[TMP3]])
; CHECK-NEXT:    ret float [[CABS]]
;
  %call = tail call fast float @cabsf([2 x float] %z)
  ret float %call
}

define fp128 @fast_cabsl([2 x fp128] %z) {
; CHECK-LABEL: @fast_cabsl(
; CHECK-NEXT:    [[REAL:%.*]] = extractvalue [2 x fp128] [[Z:%.*]], 0
; CHECK-NEXT:    [[IMAG:%.*]] = extractvalue [2 x fp128] [[Z]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast fp128 [[REAL]], [[REAL]]
; CHECK-NEXT:    [[TMP2:%.*]] = fmul fast fp128 [[IMAG]], [[IMAG]]
; CHECK-NEXT:    [[TMP3:%.*]] = fadd fast fp128 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast fp128 @llvm.sqrt.f128(fp128 [[TMP3]])
; CHECK-NEXT:    ret fp128 [[CABS]]
;
  %call = tail call fast fp128 @cabsl([2 x fp128] %z)
  ret fp128 %call
}

declare double @cabs([2 x double])
declare float @cabsf([2 x float])
declare fp128 @cabsl([2 x fp128])
