; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost -ir-sim-calls-by-name < %s | FileCheck %s

; This test checks that we do can outline calls, but only if they have the same
; function type and the same name.

declare void @f1(ptr, ptr);
declare void @f2(ptr, ptr);

define void @function1() {
; CHECK-LABEL: @function1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[A]], ptr [[B]], ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  store i32 4, ptr %c, align 4
  call void @f1(ptr %a, ptr %b)
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

define void @function2() {
; CHECK-LABEL: @function2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[A]], ptr [[B]], ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  store i32 4, ptr %c, align 4
  call void @f1(ptr %a, ptr %b)
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

define void @function3() {
; CHECK-LABEL: @function3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 2, ptr [[A]], align 4
; CHECK-NEXT:    store i32 3, ptr [[B]], align 4
; CHECK-NEXT:    store i32 4, ptr [[C]], align 4
; CHECK-NEXT:    call void @f2(ptr [[A]], ptr [[B]])
; CHECK-NEXT:    [[AL:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    [[BL:%.*]] = load i32, ptr [[B]], align 4
; CHECK-NEXT:    [[CL:%.*]] = load i32, ptr [[C]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  store i32 4, ptr %c, align 4
  call void @f2(ptr %a, ptr %b)
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

; CHECK: define internal void @outlined_ir_func_0(ptr [[ARG0:%.*]], ptr [[ARG1:%.*]], ptr [[ARG2:%.*]])
; CHECK: entry_to_outline:
; CHECK-NEXT:    store i32 2, ptr [[ARG0]], align 4
; CHECK-NEXT:    store i32 3, ptr [[ARG1]], align 4
; CHECK-NEXT:    store i32 4, ptr [[ARG2]], align 4
; CHECK-NEXT:    call void @f1(ptr [[ARG0]], ptr [[ARG1]])
; CHECK-NEXT:    [[AL:%.*]] = load i32, ptr [[ARG0]], align 4
; CHECK-NEXT:    [[BL:%.*]] = load i32, ptr [[ARG1]], align 4
; CHECK-NEXT:    [[CL:%.*]] = load i32, ptr [[ARG2]], align 4
