; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; REQUIRES: aarch64-registered-target
; RUN: opt -passes='lower-matrix-intrinsics' -matrix-default-layout=row-major -mtriple=arm64-apple-iphoneos -S < %s | FileCheck %s

define <1 x i32> @dotproduct_i32_v8(<8 x i32> %a, <8 x i32> %b) {
; CHECK-LABEL: @dotproduct_i32_v8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i32> [[B:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i32> [[SPLIT1]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK9:%.*]] = shufflevector <1 x i32> [[SPLIT2]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT10:%.*]] = insertelement <1 x i32> poison, i32 [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT11:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT10]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = mul <1 x i32> [[SPLAT_SPLAT11]], [[BLOCK9]]
; CHECK-NEXT:    [[TMP4:%.*]] = add <1 x i32> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[BLOCK12:%.*]] = shufflevector <1 x i32> [[SPLIT3]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <1 x i32> poison, i32 [[TMP5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT13]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = mul <1 x i32> [[SPLAT_SPLAT14]], [[BLOCK12]]
; CHECK-NEXT:    [[TMP7:%.*]] = add <1 x i32> [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[BLOCK15:%.*]] = shufflevector <1 x i32> [[SPLIT4]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT16:%.*]] = insertelement <1 x i32> poison, i32 [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT17:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT16]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = mul <1 x i32> [[SPLAT_SPLAT17]], [[BLOCK15]]
; CHECK-NEXT:    [[TMP10:%.*]] = add <1 x i32> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[BLOCK18:%.*]] = shufflevector <1 x i32> [[SPLIT5]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT19:%.*]] = insertelement <1 x i32> poison, i32 [[TMP11]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT20:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT19]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = mul <1 x i32> [[SPLAT_SPLAT20]], [[BLOCK18]]
; CHECK-NEXT:    [[TMP13:%.*]] = add <1 x i32> [[TMP10]], [[TMP12]]
; CHECK-NEXT:    [[BLOCK21:%.*]] = shufflevector <1 x i32> [[SPLIT6]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT22:%.*]] = insertelement <1 x i32> poison, i32 [[TMP14]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT23:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT22]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = mul <1 x i32> [[SPLAT_SPLAT23]], [[BLOCK21]]
; CHECK-NEXT:    [[TMP16:%.*]] = add <1 x i32> [[TMP13]], [[TMP15]]
; CHECK-NEXT:    [[BLOCK24:%.*]] = shufflevector <1 x i32> [[SPLIT7]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT25:%.*]] = insertelement <1 x i32> poison, i32 [[TMP17]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT26:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT25]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = mul <1 x i32> [[SPLAT_SPLAT26]], [[BLOCK24]]
; CHECK-NEXT:    [[TMP19:%.*]] = add <1 x i32> [[TMP16]], [[TMP18]]
; CHECK-NEXT:    [[BLOCK27:%.*]] = shufflevector <1 x i32> [[SPLIT8]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT28:%.*]] = insertelement <1 x i32> poison, i32 [[TMP20]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT29:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT28]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = mul <1 x i32> [[SPLAT_SPLAT29]], [[BLOCK27]]
; CHECK-NEXT:    [[TMP22:%.*]] = add <1 x i32> [[TMP19]], [[TMP21]]
; CHECK-NEXT:    [[TMP23:%.*]] = shufflevector <1 x i32> [[TMP22]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP24:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP23]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i32> [[TMP24]]
;
entry:
  %c = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %a, <8 x i32> %b, i32 1, i32 8, i32 1)
  ret <1 x i32> %c
}

declare <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32>, <8 x i32>, i32, i32, i32)

declare void @use(<1 x i32>)

define <1 x i32> @dotproduct_i32_v8_result_used_by_inst(<8 x i32> %a, <8 x i32> %b) {
; CHECK-LABEL: @dotproduct_i32_v8_result_used_by_inst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i32> [[B:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i32> [[SPLIT1]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK9:%.*]] = shufflevector <1 x i32> [[SPLIT2]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT10:%.*]] = insertelement <1 x i32> poison, i32 [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT11:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT10]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = mul <1 x i32> [[SPLAT_SPLAT11]], [[BLOCK9]]
; CHECK-NEXT:    [[TMP4:%.*]] = add <1 x i32> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[BLOCK12:%.*]] = shufflevector <1 x i32> [[SPLIT3]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <1 x i32> poison, i32 [[TMP5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT13]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = mul <1 x i32> [[SPLAT_SPLAT14]], [[BLOCK12]]
; CHECK-NEXT:    [[TMP7:%.*]] = add <1 x i32> [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[BLOCK15:%.*]] = shufflevector <1 x i32> [[SPLIT4]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT16:%.*]] = insertelement <1 x i32> poison, i32 [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT17:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT16]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = mul <1 x i32> [[SPLAT_SPLAT17]], [[BLOCK15]]
; CHECK-NEXT:    [[TMP10:%.*]] = add <1 x i32> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[BLOCK18:%.*]] = shufflevector <1 x i32> [[SPLIT5]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT19:%.*]] = insertelement <1 x i32> poison, i32 [[TMP11]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT20:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT19]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = mul <1 x i32> [[SPLAT_SPLAT20]], [[BLOCK18]]
; CHECK-NEXT:    [[TMP13:%.*]] = add <1 x i32> [[TMP10]], [[TMP12]]
; CHECK-NEXT:    [[BLOCK21:%.*]] = shufflevector <1 x i32> [[SPLIT6]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT22:%.*]] = insertelement <1 x i32> poison, i32 [[TMP14]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT23:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT22]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = mul <1 x i32> [[SPLAT_SPLAT23]], [[BLOCK21]]
; CHECK-NEXT:    [[TMP16:%.*]] = add <1 x i32> [[TMP13]], [[TMP15]]
; CHECK-NEXT:    [[BLOCK24:%.*]] = shufflevector <1 x i32> [[SPLIT7]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT25:%.*]] = insertelement <1 x i32> poison, i32 [[TMP17]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT26:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT25]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = mul <1 x i32> [[SPLAT_SPLAT26]], [[BLOCK24]]
; CHECK-NEXT:    [[TMP19:%.*]] = add <1 x i32> [[TMP16]], [[TMP18]]
; CHECK-NEXT:    [[BLOCK27:%.*]] = shufflevector <1 x i32> [[SPLIT8]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT28:%.*]] = insertelement <1 x i32> poison, i32 [[TMP20]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT29:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT28]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = mul <1 x i32> [[SPLAT_SPLAT29]], [[BLOCK27]]
; CHECK-NEXT:    [[TMP22:%.*]] = add <1 x i32> [[TMP19]], [[TMP21]]
; CHECK-NEXT:    [[TMP23:%.*]] = shufflevector <1 x i32> [[TMP22]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP24:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP23]], <1 x i32> <i32 1>
; CHECK-NEXT:    call void @use(<1 x i32> [[TMP24]])
; CHECK-NEXT:    ret <1 x i32> [[TMP24]]
;
entry:
  %c = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %a, <8 x i32> %b, i32 1, i32 8, i32 1)
  call void @use(<1 x i32> %c)
  ret <1 x i32> %c
}


define <1 x i32> @dotproduct_i32_v8_constvector(<8 x i32> %a) {
; CHECK-LABEL: @dotproduct_i32_v8_constvector(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], <i32 1>
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT1:%.*]] = insertelement <1 x i32> poison, i32 [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT2:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT1]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = mul <1 x i32> [[SPLAT_SPLAT2]], <i32 2>
; CHECK-NEXT:    [[TMP4:%.*]] = add <1 x i32> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT3:%.*]] = insertelement <1 x i32> poison, i32 [[TMP5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT4:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT3]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = mul <1 x i32> [[SPLAT_SPLAT4]], <i32 3>
; CHECK-NEXT:    [[TMP7:%.*]] = add <1 x i32> [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT5:%.*]] = insertelement <1 x i32> poison, i32 [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT6:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT5]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = mul <1 x i32> [[SPLAT_SPLAT6]], <i32 4>
; CHECK-NEXT:    [[TMP10:%.*]] = add <1 x i32> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT7:%.*]] = insertelement <1 x i32> poison, i32 [[TMP11]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT8:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT7]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = mul <1 x i32> [[SPLAT_SPLAT8]], <i32 5>
; CHECK-NEXT:    [[TMP13:%.*]] = add <1 x i32> [[TMP10]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT9:%.*]] = insertelement <1 x i32> poison, i32 [[TMP14]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT10:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT9]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = mul <1 x i32> [[SPLAT_SPLAT10]], <i32 6>
; CHECK-NEXT:    [[TMP16:%.*]] = add <1 x i32> [[TMP13]], [[TMP15]]
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT11:%.*]] = insertelement <1 x i32> poison, i32 [[TMP17]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT12:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT11]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = mul <1 x i32> [[SPLAT_SPLAT12]], <i32 7>
; CHECK-NEXT:    [[TMP19:%.*]] = add <1 x i32> [[TMP16]], [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i32> [[SPLIT]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <1 x i32> poison, i32 [[TMP20]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT13]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = mul <1 x i32> [[SPLAT_SPLAT14]], <i32 8>
; CHECK-NEXT:    [[TMP22:%.*]] = add <1 x i32> [[TMP19]], [[TMP21]]
; CHECK-NEXT:    [[TMP23:%.*]] = shufflevector <1 x i32> [[TMP22]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP24:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP23]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i32> [[TMP24]]
;
entry:
  %c = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %a, <8 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>, i32 1, i32 8, i32 1)
  ret <1 x i32> %c
}

define <1 x i32> @add_feeding_dotproduct_i32_v8_1(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c) {
; CHECK-LABEL: @add_feeding_dotproduct_i32_v8_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i32> [[B:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP0:%.*]] = add <8 x i32> [[SPLIT]], [[SPLIT1]]
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i32> [[C:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT9:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i32> [[SPLIT2]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = extractelement <8 x i32> [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP1]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK10:%.*]] = shufflevector <1 x i32> [[SPLIT3]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x i32> [[TMP0]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT11:%.*]] = insertelement <1 x i32> poison, i32 [[TMP3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT12:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT11]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP4:%.*]] = mul <1 x i32> [[SPLAT_SPLAT12]], [[BLOCK10]]
; CHECK-NEXT:    [[TMP5:%.*]] = add <1 x i32> [[TMP2]], [[TMP4]]
; CHECK-NEXT:    [[BLOCK13:%.*]] = shufflevector <1 x i32> [[SPLIT4]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x i32> [[TMP0]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT14:%.*]] = insertelement <1 x i32> poison, i32 [[TMP6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT15:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT14]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP7:%.*]] = mul <1 x i32> [[SPLAT_SPLAT15]], [[BLOCK13]]
; CHECK-NEXT:    [[TMP8:%.*]] = add <1 x i32> [[TMP5]], [[TMP7]]
; CHECK-NEXT:    [[BLOCK16:%.*]] = shufflevector <1 x i32> [[SPLIT5]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x i32> [[TMP0]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT17:%.*]] = insertelement <1 x i32> poison, i32 [[TMP9]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT18:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT17]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = mul <1 x i32> [[SPLAT_SPLAT18]], [[BLOCK16]]
; CHECK-NEXT:    [[TMP11:%.*]] = add <1 x i32> [[TMP8]], [[TMP10]]
; CHECK-NEXT:    [[BLOCK19:%.*]] = shufflevector <1 x i32> [[SPLIT6]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <8 x i32> [[TMP0]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT20:%.*]] = insertelement <1 x i32> poison, i32 [[TMP12]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT21:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT20]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = mul <1 x i32> [[SPLAT_SPLAT21]], [[BLOCK19]]
; CHECK-NEXT:    [[TMP14:%.*]] = add <1 x i32> [[TMP11]], [[TMP13]]
; CHECK-NEXT:    [[BLOCK22:%.*]] = shufflevector <1 x i32> [[SPLIT7]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <8 x i32> [[TMP0]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT23:%.*]] = insertelement <1 x i32> poison, i32 [[TMP15]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT24:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT23]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = mul <1 x i32> [[SPLAT_SPLAT24]], [[BLOCK22]]
; CHECK-NEXT:    [[TMP17:%.*]] = add <1 x i32> [[TMP14]], [[TMP16]]
; CHECK-NEXT:    [[BLOCK25:%.*]] = shufflevector <1 x i32> [[SPLIT8]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <8 x i32> [[TMP0]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT26:%.*]] = insertelement <1 x i32> poison, i32 [[TMP18]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT27:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT26]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = mul <1 x i32> [[SPLAT_SPLAT27]], [[BLOCK25]]
; CHECK-NEXT:    [[TMP20:%.*]] = add <1 x i32> [[TMP17]], [[TMP19]]
; CHECK-NEXT:    [[BLOCK28:%.*]] = shufflevector <1 x i32> [[SPLIT9]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = extractelement <8 x i32> [[TMP0]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT29:%.*]] = insertelement <1 x i32> poison, i32 [[TMP21]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT30:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT29]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP22:%.*]] = mul <1 x i32> [[SPLAT_SPLAT30]], [[BLOCK28]]
; CHECK-NEXT:    [[TMP23:%.*]] = add <1 x i32> [[TMP20]], [[TMP22]]
; CHECK-NEXT:    [[TMP24:%.*]] = shufflevector <1 x i32> [[TMP23]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP24]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i32> [[TMP25]]
;
entry:
  %add = add <8 x i32> %a, %b
  %res = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %add, <8 x i32> %c, i32 1, i32 8, i32 1)
  ret <1 x i32> %res
}

define <1 x i32> @add_feeding_dotproduct_i32_v8_2(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c) {
; CHECK-LABEL: @add_feeding_dotproduct_i32_v8_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i32> [[B:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT9:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT10:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT11:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT12:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT13:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT14:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT15:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[TMP0:%.*]] = add <1 x i32> [[SPLIT]], [[SPLIT8]]
; CHECK-NEXT:    [[TMP1:%.*]] = add <1 x i32> [[SPLIT1]], [[SPLIT9]]
; CHECK-NEXT:    [[TMP2:%.*]] = add <1 x i32> [[SPLIT2]], [[SPLIT10]]
; CHECK-NEXT:    [[TMP3:%.*]] = add <1 x i32> [[SPLIT3]], [[SPLIT11]]
; CHECK-NEXT:    [[TMP4:%.*]] = add <1 x i32> [[SPLIT4]], [[SPLIT12]]
; CHECK-NEXT:    [[TMP5:%.*]] = add <1 x i32> [[SPLIT5]], [[SPLIT13]]
; CHECK-NEXT:    [[TMP6:%.*]] = add <1 x i32> [[SPLIT6]], [[SPLIT14]]
; CHECK-NEXT:    [[TMP7:%.*]] = add <1 x i32> [[SPLIT7]], [[SPLIT15]]
; CHECK-NEXT:    [[SPLIT16:%.*]] = shufflevector <8 x i32> [[C:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i32> [[TMP0]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK17:%.*]] = shufflevector <1 x i32> [[TMP1]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT18:%.*]] = insertelement <1 x i32> poison, i32 [[TMP10]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT19:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT18]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = mul <1 x i32> [[SPLAT_SPLAT19]], [[BLOCK17]]
; CHECK-NEXT:    [[TMP12:%.*]] = add <1 x i32> [[TMP9]], [[TMP11]]
; CHECK-NEXT:    [[BLOCK20:%.*]] = shufflevector <1 x i32> [[TMP2]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT21:%.*]] = insertelement <1 x i32> poison, i32 [[TMP13]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT22:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT21]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = mul <1 x i32> [[SPLAT_SPLAT22]], [[BLOCK20]]
; CHECK-NEXT:    [[TMP15:%.*]] = add <1 x i32> [[TMP12]], [[TMP14]]
; CHECK-NEXT:    [[BLOCK23:%.*]] = shufflevector <1 x i32> [[TMP3]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT24:%.*]] = insertelement <1 x i32> poison, i32 [[TMP16]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT25:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT24]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = mul <1 x i32> [[SPLAT_SPLAT25]], [[BLOCK23]]
; CHECK-NEXT:    [[TMP18:%.*]] = add <1 x i32> [[TMP15]], [[TMP17]]
; CHECK-NEXT:    [[BLOCK26:%.*]] = shufflevector <1 x i32> [[TMP4]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <1 x i32> poison, i32 [[TMP19]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT27]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP20:%.*]] = mul <1 x i32> [[SPLAT_SPLAT28]], [[BLOCK26]]
; CHECK-NEXT:    [[TMP21:%.*]] = add <1 x i32> [[TMP18]], [[TMP20]]
; CHECK-NEXT:    [[BLOCK29:%.*]] = shufflevector <1 x i32> [[TMP5]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT30:%.*]] = insertelement <1 x i32> poison, i32 [[TMP22]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT31:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT30]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP23:%.*]] = mul <1 x i32> [[SPLAT_SPLAT31]], [[BLOCK29]]
; CHECK-NEXT:    [[TMP24:%.*]] = add <1 x i32> [[TMP21]], [[TMP23]]
; CHECK-NEXT:    [[BLOCK32:%.*]] = shufflevector <1 x i32> [[TMP6]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <1 x i32> poison, i32 [[TMP25]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT33]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP26:%.*]] = mul <1 x i32> [[SPLAT_SPLAT34]], [[BLOCK32]]
; CHECK-NEXT:    [[TMP27:%.*]] = add <1 x i32> [[TMP24]], [[TMP26]]
; CHECK-NEXT:    [[BLOCK35:%.*]] = shufflevector <1 x i32> [[TMP7]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT36:%.*]] = insertelement <1 x i32> poison, i32 [[TMP28]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT37:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT36]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP29:%.*]] = mul <1 x i32> [[SPLAT_SPLAT37]], [[BLOCK35]]
; CHECK-NEXT:    [[TMP30:%.*]] = add <1 x i32> [[TMP27]], [[TMP29]]
; CHECK-NEXT:    [[TMP31:%.*]] = shufflevector <1 x i32> [[TMP30]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP32:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP31]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i32> [[TMP32]]
;
entry:
  %add = add <8 x i32> %a, %b
  %res = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %c, <8 x i32> %add, i32 1, i32 8, i32 1)
  ret <1 x i32> %res
}

define <1 x i32> @sub_feeding_dotproduct_i32_v8_1(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c) {
; CHECK-LABEL: @sub_feeding_dotproduct_i32_v8_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i32> [[B:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP0:%.*]] = sub <8 x i32> [[SPLIT]], [[SPLIT1]]
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i32> [[C:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT9:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i32> [[SPLIT2]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = extractelement <8 x i32> [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP1]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK10:%.*]] = shufflevector <1 x i32> [[SPLIT3]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x i32> [[TMP0]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT11:%.*]] = insertelement <1 x i32> poison, i32 [[TMP3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT12:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT11]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP4:%.*]] = mul <1 x i32> [[SPLAT_SPLAT12]], [[BLOCK10]]
; CHECK-NEXT:    [[TMP5:%.*]] = add <1 x i32> [[TMP2]], [[TMP4]]
; CHECK-NEXT:    [[BLOCK13:%.*]] = shufflevector <1 x i32> [[SPLIT4]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x i32> [[TMP0]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT14:%.*]] = insertelement <1 x i32> poison, i32 [[TMP6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT15:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT14]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP7:%.*]] = mul <1 x i32> [[SPLAT_SPLAT15]], [[BLOCK13]]
; CHECK-NEXT:    [[TMP8:%.*]] = add <1 x i32> [[TMP5]], [[TMP7]]
; CHECK-NEXT:    [[BLOCK16:%.*]] = shufflevector <1 x i32> [[SPLIT5]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x i32> [[TMP0]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT17:%.*]] = insertelement <1 x i32> poison, i32 [[TMP9]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT18:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT17]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = mul <1 x i32> [[SPLAT_SPLAT18]], [[BLOCK16]]
; CHECK-NEXT:    [[TMP11:%.*]] = add <1 x i32> [[TMP8]], [[TMP10]]
; CHECK-NEXT:    [[BLOCK19:%.*]] = shufflevector <1 x i32> [[SPLIT6]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <8 x i32> [[TMP0]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT20:%.*]] = insertelement <1 x i32> poison, i32 [[TMP12]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT21:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT20]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = mul <1 x i32> [[SPLAT_SPLAT21]], [[BLOCK19]]
; CHECK-NEXT:    [[TMP14:%.*]] = add <1 x i32> [[TMP11]], [[TMP13]]
; CHECK-NEXT:    [[BLOCK22:%.*]] = shufflevector <1 x i32> [[SPLIT7]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <8 x i32> [[TMP0]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT23:%.*]] = insertelement <1 x i32> poison, i32 [[TMP15]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT24:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT23]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = mul <1 x i32> [[SPLAT_SPLAT24]], [[BLOCK22]]
; CHECK-NEXT:    [[TMP17:%.*]] = add <1 x i32> [[TMP14]], [[TMP16]]
; CHECK-NEXT:    [[BLOCK25:%.*]] = shufflevector <1 x i32> [[SPLIT8]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <8 x i32> [[TMP0]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT26:%.*]] = insertelement <1 x i32> poison, i32 [[TMP18]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT27:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT26]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = mul <1 x i32> [[SPLAT_SPLAT27]], [[BLOCK25]]
; CHECK-NEXT:    [[TMP20:%.*]] = add <1 x i32> [[TMP17]], [[TMP19]]
; CHECK-NEXT:    [[BLOCK28:%.*]] = shufflevector <1 x i32> [[SPLIT9]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = extractelement <8 x i32> [[TMP0]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT29:%.*]] = insertelement <1 x i32> poison, i32 [[TMP21]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT30:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT29]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP22:%.*]] = mul <1 x i32> [[SPLAT_SPLAT30]], [[BLOCK28]]
; CHECK-NEXT:    [[TMP23:%.*]] = add <1 x i32> [[TMP20]], [[TMP22]]
; CHECK-NEXT:    [[TMP24:%.*]] = shufflevector <1 x i32> [[TMP23]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP24]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i32> [[TMP25]]
;
entry:
  %sub = sub <8 x i32> %a, %b
  %res = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %sub, <8 x i32> %c, i32 1, i32 8, i32 1)
  ret <1 x i32> %res
}

define <1 x i32> @sub_feeding_dotproduct_i32_v8_2(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c) {
; CHECK-LABEL: @sub_feeding_dotproduct_i32_v8_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i32> [[B:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT9:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT10:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT11:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT12:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT13:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT14:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT15:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[TMP0:%.*]] = sub <1 x i32> [[SPLIT]], [[SPLIT8]]
; CHECK-NEXT:    [[TMP1:%.*]] = sub <1 x i32> [[SPLIT1]], [[SPLIT9]]
; CHECK-NEXT:    [[TMP2:%.*]] = sub <1 x i32> [[SPLIT2]], [[SPLIT10]]
; CHECK-NEXT:    [[TMP3:%.*]] = sub <1 x i32> [[SPLIT3]], [[SPLIT11]]
; CHECK-NEXT:    [[TMP4:%.*]] = sub <1 x i32> [[SPLIT4]], [[SPLIT12]]
; CHECK-NEXT:    [[TMP5:%.*]] = sub <1 x i32> [[SPLIT5]], [[SPLIT13]]
; CHECK-NEXT:    [[TMP6:%.*]] = sub <1 x i32> [[SPLIT6]], [[SPLIT14]]
; CHECK-NEXT:    [[TMP7:%.*]] = sub <1 x i32> [[SPLIT7]], [[SPLIT15]]
; CHECK-NEXT:    [[SPLIT16:%.*]] = shufflevector <8 x i32> [[C:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i32> [[TMP0]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK17:%.*]] = shufflevector <1 x i32> [[TMP1]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT18:%.*]] = insertelement <1 x i32> poison, i32 [[TMP10]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT19:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT18]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = mul <1 x i32> [[SPLAT_SPLAT19]], [[BLOCK17]]
; CHECK-NEXT:    [[TMP12:%.*]] = add <1 x i32> [[TMP9]], [[TMP11]]
; CHECK-NEXT:    [[BLOCK20:%.*]] = shufflevector <1 x i32> [[TMP2]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT21:%.*]] = insertelement <1 x i32> poison, i32 [[TMP13]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT22:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT21]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = mul <1 x i32> [[SPLAT_SPLAT22]], [[BLOCK20]]
; CHECK-NEXT:    [[TMP15:%.*]] = add <1 x i32> [[TMP12]], [[TMP14]]
; CHECK-NEXT:    [[BLOCK23:%.*]] = shufflevector <1 x i32> [[TMP3]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT24:%.*]] = insertelement <1 x i32> poison, i32 [[TMP16]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT25:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT24]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = mul <1 x i32> [[SPLAT_SPLAT25]], [[BLOCK23]]
; CHECK-NEXT:    [[TMP18:%.*]] = add <1 x i32> [[TMP15]], [[TMP17]]
; CHECK-NEXT:    [[BLOCK26:%.*]] = shufflevector <1 x i32> [[TMP4]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <1 x i32> poison, i32 [[TMP19]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT27]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP20:%.*]] = mul <1 x i32> [[SPLAT_SPLAT28]], [[BLOCK26]]
; CHECK-NEXT:    [[TMP21:%.*]] = add <1 x i32> [[TMP18]], [[TMP20]]
; CHECK-NEXT:    [[BLOCK29:%.*]] = shufflevector <1 x i32> [[TMP5]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT30:%.*]] = insertelement <1 x i32> poison, i32 [[TMP22]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT31:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT30]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP23:%.*]] = mul <1 x i32> [[SPLAT_SPLAT31]], [[BLOCK29]]
; CHECK-NEXT:    [[TMP24:%.*]] = add <1 x i32> [[TMP21]], [[TMP23]]
; CHECK-NEXT:    [[BLOCK32:%.*]] = shufflevector <1 x i32> [[TMP6]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <1 x i32> poison, i32 [[TMP25]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT33]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP26:%.*]] = mul <1 x i32> [[SPLAT_SPLAT34]], [[BLOCK32]]
; CHECK-NEXT:    [[TMP27:%.*]] = add <1 x i32> [[TMP24]], [[TMP26]]
; CHECK-NEXT:    [[BLOCK35:%.*]] = shufflevector <1 x i32> [[TMP7]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <8 x i32> [[SPLIT16]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT36:%.*]] = insertelement <1 x i32> poison, i32 [[TMP28]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT37:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT36]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP29:%.*]] = mul <1 x i32> [[SPLAT_SPLAT37]], [[BLOCK35]]
; CHECK-NEXT:    [[TMP30:%.*]] = add <1 x i32> [[TMP27]], [[TMP29]]
; CHECK-NEXT:    [[TMP31:%.*]] = shufflevector <1 x i32> [[TMP30]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP32:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP31]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i32> [[TMP32]]
;
entry:
  %sub = sub <8 x i32> %a, %b
  %res = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %c, <8 x i32> %sub, i32 1, i32 8, i32 1)
  ret <1 x i32> %res
}

define <1 x i32> @add_chain_feeding_dotproduct_i32_v8_1(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c, <8 x i32> %d) {
; CHECK-LABEL: @add_chain_feeding_dotproduct_i32_v8_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i32> [[B:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP0:%.*]] = add <8 x i32> [[SPLIT]], [[SPLIT1]]
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i32> [[C:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP1:%.*]] = add <8 x i32> [[TMP0]], [[SPLIT2]]
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i32> [[D:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i32> [[D]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i32> [[D]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i32> [[D]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i32> [[D]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i32> [[D]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT9:%.*]] = shufflevector <8 x i32> [[D]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT10:%.*]] = shufflevector <8 x i32> [[D]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i32> [[SPLIT3]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[TMP1]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK11:%.*]] = shufflevector <1 x i32> [[SPLIT4]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x i32> [[TMP1]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT12:%.*]] = insertelement <1 x i32> poison, i32 [[TMP4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT13:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT12]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP5:%.*]] = mul <1 x i32> [[SPLAT_SPLAT13]], [[BLOCK11]]
; CHECK-NEXT:    [[TMP6:%.*]] = add <1 x i32> [[TMP3]], [[TMP5]]
; CHECK-NEXT:    [[BLOCK14:%.*]] = shufflevector <1 x i32> [[SPLIT5]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x i32> [[TMP1]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT15:%.*]] = insertelement <1 x i32> poison, i32 [[TMP7]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT16:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT15]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = mul <1 x i32> [[SPLAT_SPLAT16]], [[BLOCK14]]
; CHECK-NEXT:    [[TMP9:%.*]] = add <1 x i32> [[TMP6]], [[TMP8]]
; CHECK-NEXT:    [[BLOCK17:%.*]] = shufflevector <1 x i32> [[SPLIT6]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <8 x i32> [[TMP1]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT18:%.*]] = insertelement <1 x i32> poison, i32 [[TMP10]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT19:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT18]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = mul <1 x i32> [[SPLAT_SPLAT19]], [[BLOCK17]]
; CHECK-NEXT:    [[TMP12:%.*]] = add <1 x i32> [[TMP9]], [[TMP11]]
; CHECK-NEXT:    [[BLOCK20:%.*]] = shufflevector <1 x i32> [[SPLIT7]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <8 x i32> [[TMP1]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT21:%.*]] = insertelement <1 x i32> poison, i32 [[TMP13]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT22:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT21]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = mul <1 x i32> [[SPLAT_SPLAT22]], [[BLOCK20]]
; CHECK-NEXT:    [[TMP15:%.*]] = add <1 x i32> [[TMP12]], [[TMP14]]
; CHECK-NEXT:    [[BLOCK23:%.*]] = shufflevector <1 x i32> [[SPLIT8]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i32> [[TMP1]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT24:%.*]] = insertelement <1 x i32> poison, i32 [[TMP16]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT25:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT24]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = mul <1 x i32> [[SPLAT_SPLAT25]], [[BLOCK23]]
; CHECK-NEXT:    [[TMP18:%.*]] = add <1 x i32> [[TMP15]], [[TMP17]]
; CHECK-NEXT:    [[BLOCK26:%.*]] = shufflevector <1 x i32> [[SPLIT9]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i32> [[TMP1]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <1 x i32> poison, i32 [[TMP19]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT27]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP20:%.*]] = mul <1 x i32> [[SPLAT_SPLAT28]], [[BLOCK26]]
; CHECK-NEXT:    [[TMP21:%.*]] = add <1 x i32> [[TMP18]], [[TMP20]]
; CHECK-NEXT:    [[BLOCK29:%.*]] = shufflevector <1 x i32> [[SPLIT10]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <8 x i32> [[TMP1]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT30:%.*]] = insertelement <1 x i32> poison, i32 [[TMP22]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT31:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT30]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP23:%.*]] = mul <1 x i32> [[SPLAT_SPLAT31]], [[BLOCK29]]
; CHECK-NEXT:    [[TMP24:%.*]] = add <1 x i32> [[TMP21]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = shufflevector <1 x i32> [[TMP24]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP26:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP25]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i32> [[TMP26]]
;
entry:
  %add.1 = add <8 x i32> %a, %b
  %add.2 = add <8 x i32> %add.1, %c
  %res = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %add.2, <8 x i32> %d, i32 1, i32 8, i32 1)
  ret <1 x i32> %res
}

define <1 x i32> @add_chain_feeding_dotproduct_i32_v8_2(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c, <8 x i32> %d) {
; CHECK-LABEL: @add_chain_feeding_dotproduct_i32_v8_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i32> [[A:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i32> [[A]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i32> [[B:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT9:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT10:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT11:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT12:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT13:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT14:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT15:%.*]] = shufflevector <8 x i32> [[B]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[TMP0:%.*]] = add <1 x i32> [[SPLIT]], [[SPLIT8]]
; CHECK-NEXT:    [[TMP1:%.*]] = add <1 x i32> [[SPLIT1]], [[SPLIT9]]
; CHECK-NEXT:    [[TMP2:%.*]] = add <1 x i32> [[SPLIT2]], [[SPLIT10]]
; CHECK-NEXT:    [[TMP3:%.*]] = add <1 x i32> [[SPLIT3]], [[SPLIT11]]
; CHECK-NEXT:    [[TMP4:%.*]] = add <1 x i32> [[SPLIT4]], [[SPLIT12]]
; CHECK-NEXT:    [[TMP5:%.*]] = add <1 x i32> [[SPLIT5]], [[SPLIT13]]
; CHECK-NEXT:    [[TMP6:%.*]] = add <1 x i32> [[SPLIT6]], [[SPLIT14]]
; CHECK-NEXT:    [[TMP7:%.*]] = add <1 x i32> [[SPLIT7]], [[SPLIT15]]
; CHECK-NEXT:    [[SPLIT16:%.*]] = shufflevector <8 x i32> [[C:%.*]], <8 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT17:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT18:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT19:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT20:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT21:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT22:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT23:%.*]] = shufflevector <8 x i32> [[C]], <8 x i32> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[TMP8:%.*]] = add <1 x i32> [[TMP0]], [[SPLIT16]]
; CHECK-NEXT:    [[TMP9:%.*]] = add <1 x i32> [[TMP1]], [[SPLIT17]]
; CHECK-NEXT:    [[TMP10:%.*]] = add <1 x i32> [[TMP2]], [[SPLIT18]]
; CHECK-NEXT:    [[TMP11:%.*]] = add <1 x i32> [[TMP3]], [[SPLIT19]]
; CHECK-NEXT:    [[TMP12:%.*]] = add <1 x i32> [[TMP4]], [[SPLIT20]]
; CHECK-NEXT:    [[TMP13:%.*]] = add <1 x i32> [[TMP5]], [[SPLIT21]]
; CHECK-NEXT:    [[TMP14:%.*]] = add <1 x i32> [[TMP6]], [[SPLIT22]]
; CHECK-NEXT:    [[TMP15:%.*]] = add <1 x i32> [[TMP7]], [[SPLIT23]]
; CHECK-NEXT:    [[SPLIT24:%.*]] = shufflevector <8 x i32> [[D:%.*]], <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i32> [[TMP8]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i32> [[SPLIT24]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i32> poison, i32 [[TMP16]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = mul <1 x i32> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK25:%.*]] = shufflevector <1 x i32> [[TMP9]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <8 x i32> [[SPLIT24]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT26:%.*]] = insertelement <1 x i32> poison, i32 [[TMP18]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT27:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT26]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = mul <1 x i32> [[SPLAT_SPLAT27]], [[BLOCK25]]
; CHECK-NEXT:    [[TMP20:%.*]] = add <1 x i32> [[TMP17]], [[TMP19]]
; CHECK-NEXT:    [[BLOCK28:%.*]] = shufflevector <1 x i32> [[TMP10]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = extractelement <8 x i32> [[SPLIT24]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT29:%.*]] = insertelement <1 x i32> poison, i32 [[TMP21]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT30:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT29]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP22:%.*]] = mul <1 x i32> [[SPLAT_SPLAT30]], [[BLOCK28]]
; CHECK-NEXT:    [[TMP23:%.*]] = add <1 x i32> [[TMP20]], [[TMP22]]
; CHECK-NEXT:    [[BLOCK31:%.*]] = shufflevector <1 x i32> [[TMP11]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP24:%.*]] = extractelement <8 x i32> [[SPLIT24]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT32:%.*]] = insertelement <1 x i32> poison, i32 [[TMP24]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT33:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT32]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = mul <1 x i32> [[SPLAT_SPLAT33]], [[BLOCK31]]
; CHECK-NEXT:    [[TMP26:%.*]] = add <1 x i32> [[TMP23]], [[TMP25]]
; CHECK-NEXT:    [[BLOCK34:%.*]] = shufflevector <1 x i32> [[TMP12]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP27:%.*]] = extractelement <8 x i32> [[SPLIT24]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT35:%.*]] = insertelement <1 x i32> poison, i32 [[TMP27]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT36:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT35]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP28:%.*]] = mul <1 x i32> [[SPLAT_SPLAT36]], [[BLOCK34]]
; CHECK-NEXT:    [[TMP29:%.*]] = add <1 x i32> [[TMP26]], [[TMP28]]
; CHECK-NEXT:    [[BLOCK37:%.*]] = shufflevector <1 x i32> [[TMP13]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP30:%.*]] = extractelement <8 x i32> [[SPLIT24]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT38:%.*]] = insertelement <1 x i32> poison, i32 [[TMP30]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT39:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT38]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP31:%.*]] = mul <1 x i32> [[SPLAT_SPLAT39]], [[BLOCK37]]
; CHECK-NEXT:    [[TMP32:%.*]] = add <1 x i32> [[TMP29]], [[TMP31]]
; CHECK-NEXT:    [[BLOCK40:%.*]] = shufflevector <1 x i32> [[TMP14]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <8 x i32> [[SPLIT24]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT41:%.*]] = insertelement <1 x i32> poison, i32 [[TMP33]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT42:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT41]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP34:%.*]] = mul <1 x i32> [[SPLAT_SPLAT42]], [[BLOCK40]]
; CHECK-NEXT:    [[TMP35:%.*]] = add <1 x i32> [[TMP32]], [[TMP34]]
; CHECK-NEXT:    [[BLOCK43:%.*]] = shufflevector <1 x i32> [[TMP15]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <8 x i32> [[SPLIT24]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT44:%.*]] = insertelement <1 x i32> poison, i32 [[TMP36]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT45:%.*]] = shufflevector <1 x i32> [[SPLAT_SPLATINSERT44]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP37:%.*]] = mul <1 x i32> [[SPLAT_SPLAT45]], [[BLOCK43]]
; CHECK-NEXT:    [[TMP38:%.*]] = add <1 x i32> [[TMP35]], [[TMP37]]
; CHECK-NEXT:    [[TMP39:%.*]] = shufflevector <1 x i32> [[TMP38]], <1 x i32> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP40:%.*]] = shufflevector <1 x i32> poison, <1 x i32> [[TMP39]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i32> [[TMP40]]
;
entry:
  %add.1 = add <8 x i32> %a, %b
  %add.2 = add <8 x i32> %add.1, %c
  %res = tail call <1 x i32> @llvm.matrix.multiply.v1i32.v8i32.v8i32(<8 x i32> %d, <8 x i32> %add.2, i32 1, i32 8, i32 1)
  ret <1 x i32> %res
}

define <1 x i64> @dotproduct_i64_v8(<8 x i64> %a, <8 x i64> %b) {
; CHECK-LABEL: @dotproduct_i64_v8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x i64> [[A:%.*]], <8 x i64> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x i64> [[B:%.*]], <8 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <8 x i64> [[B]], <8 x i64> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <8 x i64> [[B]], <8 x i64> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <8 x i64> [[B]], <8 x i64> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <8 x i64> [[B]], <8 x i64> poison, <1 x i32> <i32 4>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <8 x i64> [[B]], <8 x i64> poison, <1 x i32> <i32 5>
; CHECK-NEXT:    [[SPLIT7:%.*]] = shufflevector <8 x i64> [[B]], <8 x i64> poison, <1 x i32> <i32 6>
; CHECK-NEXT:    [[SPLIT8:%.*]] = shufflevector <8 x i64> [[B]], <8 x i64> poison, <1 x i32> <i32 7>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i64> [[SPLIT1]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <8 x i64> [[SPLIT]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i64> poison, i64 [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i64> [[SPLAT_SPLATINSERT]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = mul <1 x i64> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK9:%.*]] = shufflevector <1 x i64> [[SPLIT2]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x i64> [[SPLIT]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT10:%.*]] = insertelement <1 x i64> poison, i64 [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT11:%.*]] = shufflevector <1 x i64> [[SPLAT_SPLATINSERT10]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = mul <1 x i64> [[SPLAT_SPLAT11]], [[BLOCK9]]
; CHECK-NEXT:    [[TMP4:%.*]] = add <1 x i64> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[BLOCK12:%.*]] = shufflevector <1 x i64> [[SPLIT3]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x i64> [[SPLIT]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <1 x i64> poison, i64 [[TMP5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <1 x i64> [[SPLAT_SPLATINSERT13]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = mul <1 x i64> [[SPLAT_SPLAT14]], [[BLOCK12]]
; CHECK-NEXT:    [[TMP7:%.*]] = add <1 x i64> [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[BLOCK15:%.*]] = shufflevector <1 x i64> [[SPLIT4]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x i64> [[SPLIT]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT16:%.*]] = insertelement <1 x i64> poison, i64 [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT17:%.*]] = shufflevector <1 x i64> [[SPLAT_SPLATINSERT16]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = mul <1 x i64> [[SPLAT_SPLAT17]], [[BLOCK15]]
; CHECK-NEXT:    [[TMP10:%.*]] = add <1 x i64> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[BLOCK18:%.*]] = shufflevector <1 x i64> [[SPLIT5]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i64> [[SPLIT]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT19:%.*]] = insertelement <1 x i64> poison, i64 [[TMP11]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT20:%.*]] = shufflevector <1 x i64> [[SPLAT_SPLATINSERT19]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = mul <1 x i64> [[SPLAT_SPLAT20]], [[BLOCK18]]
; CHECK-NEXT:    [[TMP13:%.*]] = add <1 x i64> [[TMP10]], [[TMP12]]
; CHECK-NEXT:    [[BLOCK21:%.*]] = shufflevector <1 x i64> [[SPLIT6]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <8 x i64> [[SPLIT]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT22:%.*]] = insertelement <1 x i64> poison, i64 [[TMP14]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT23:%.*]] = shufflevector <1 x i64> [[SPLAT_SPLATINSERT22]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = mul <1 x i64> [[SPLAT_SPLAT23]], [[BLOCK21]]
; CHECK-NEXT:    [[TMP16:%.*]] = add <1 x i64> [[TMP13]], [[TMP15]]
; CHECK-NEXT:    [[BLOCK24:%.*]] = shufflevector <1 x i64> [[SPLIT7]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i64> [[SPLIT]], i64 6
; CHECK-NEXT:    [[SPLAT_SPLATINSERT25:%.*]] = insertelement <1 x i64> poison, i64 [[TMP17]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT26:%.*]] = shufflevector <1 x i64> [[SPLAT_SPLATINSERT25]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = mul <1 x i64> [[SPLAT_SPLAT26]], [[BLOCK24]]
; CHECK-NEXT:    [[TMP19:%.*]] = add <1 x i64> [[TMP16]], [[TMP18]]
; CHECK-NEXT:    [[BLOCK27:%.*]] = shufflevector <1 x i64> [[SPLIT8]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i64> [[SPLIT]], i64 7
; CHECK-NEXT:    [[SPLAT_SPLATINSERT28:%.*]] = insertelement <1 x i64> poison, i64 [[TMP20]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT29:%.*]] = shufflevector <1 x i64> [[SPLAT_SPLATINSERT28]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = mul <1 x i64> [[SPLAT_SPLAT29]], [[BLOCK27]]
; CHECK-NEXT:    [[TMP22:%.*]] = add <1 x i64> [[TMP19]], [[TMP21]]
; CHECK-NEXT:    [[TMP23:%.*]] = shufflevector <1 x i64> [[TMP22]], <1 x i64> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP24:%.*]] = shufflevector <1 x i64> poison, <1 x i64> [[TMP23]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i64> [[TMP24]]
;
entry:
  %c = tail call <1 x i64> @llvm.matrix.multiply.v1i64.v8i64.v8i64(<8 x i64> %a, <8 x i64> %b, i32 1, i32 8, i32 1)
  ret <1 x i64> %c
}

declare <1 x i64> @llvm.matrix.multiply.v1i64.v8i64.v8i64(<8 x i64>, <8 x i64>, i32, i32, i32)

define <1 x i16> @LoadInst_dot_product_i16_v6(ptr %lhs_address, ptr %rhs_address) {
; CHECK-LABEL: @LoadInst_dot_product_i16_v6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <6 x i16>, ptr [[LHS_ADDRESS:%.*]], align 16
; CHECK-NEXT:    [[COL_LOAD1:%.*]] = load <1 x i16>, ptr [[RHS_ADDRESS:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr i16, ptr [[RHS_ADDRESS]], i64 1
; CHECK-NEXT:    [[COL_LOAD2:%.*]] = load <1 x i16>, ptr [[VEC_GEP]], align 2
; CHECK-NEXT:    [[VEC_GEP3:%.*]] = getelementptr i16, ptr [[RHS_ADDRESS]], i64 2
; CHECK-NEXT:    [[COL_LOAD4:%.*]] = load <1 x i16>, ptr [[VEC_GEP3]], align 4
; CHECK-NEXT:    [[VEC_GEP5:%.*]] = getelementptr i16, ptr [[RHS_ADDRESS]], i64 3
; CHECK-NEXT:    [[COL_LOAD6:%.*]] = load <1 x i16>, ptr [[VEC_GEP5]], align 2
; CHECK-NEXT:    [[VEC_GEP7:%.*]] = getelementptr i16, ptr [[RHS_ADDRESS]], i64 4
; CHECK-NEXT:    [[COL_LOAD8:%.*]] = load <1 x i16>, ptr [[VEC_GEP7]], align 8
; CHECK-NEXT:    [[VEC_GEP9:%.*]] = getelementptr i16, ptr [[RHS_ADDRESS]], i64 5
; CHECK-NEXT:    [[COL_LOAD10:%.*]] = load <1 x i16>, ptr [[VEC_GEP9]], align 2
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <1 x i16> [[COL_LOAD1]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <6 x i16> [[COL_LOAD]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <1 x i16> poison, i16 [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <1 x i16> [[SPLAT_SPLATINSERT]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = mul <1 x i16> [[SPLAT_SPLAT]], [[BLOCK]]
; CHECK-NEXT:    [[BLOCK11:%.*]] = shufflevector <1 x i16> [[COL_LOAD2]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <6 x i16> [[COL_LOAD]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT12:%.*]] = insertelement <1 x i16> poison, i16 [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT13:%.*]] = shufflevector <1 x i16> [[SPLAT_SPLATINSERT12]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = mul <1 x i16> [[SPLAT_SPLAT13]], [[BLOCK11]]
; CHECK-NEXT:    [[TMP4:%.*]] = add <1 x i16> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[BLOCK14:%.*]] = shufflevector <1 x i16> [[COL_LOAD4]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <6 x i16> [[COL_LOAD]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT15:%.*]] = insertelement <1 x i16> poison, i16 [[TMP5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT16:%.*]] = shufflevector <1 x i16> [[SPLAT_SPLATINSERT15]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = mul <1 x i16> [[SPLAT_SPLAT16]], [[BLOCK14]]
; CHECK-NEXT:    [[TMP7:%.*]] = add <1 x i16> [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[BLOCK17:%.*]] = shufflevector <1 x i16> [[COL_LOAD6]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <6 x i16> [[COL_LOAD]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT18:%.*]] = insertelement <1 x i16> poison, i16 [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT19:%.*]] = shufflevector <1 x i16> [[SPLAT_SPLATINSERT18]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = mul <1 x i16> [[SPLAT_SPLAT19]], [[BLOCK17]]
; CHECK-NEXT:    [[TMP10:%.*]] = add <1 x i16> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[BLOCK20:%.*]] = shufflevector <1 x i16> [[COL_LOAD8]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <6 x i16> [[COL_LOAD]], i64 4
; CHECK-NEXT:    [[SPLAT_SPLATINSERT21:%.*]] = insertelement <1 x i16> poison, i16 [[TMP11]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT22:%.*]] = shufflevector <1 x i16> [[SPLAT_SPLATINSERT21]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = mul <1 x i16> [[SPLAT_SPLAT22]], [[BLOCK20]]
; CHECK-NEXT:    [[TMP13:%.*]] = add <1 x i16> [[TMP10]], [[TMP12]]
; CHECK-NEXT:    [[BLOCK23:%.*]] = shufflevector <1 x i16> [[COL_LOAD10]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <6 x i16> [[COL_LOAD]], i64 5
; CHECK-NEXT:    [[SPLAT_SPLATINSERT24:%.*]] = insertelement <1 x i16> poison, i16 [[TMP14]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT25:%.*]] = shufflevector <1 x i16> [[SPLAT_SPLATINSERT24]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = mul <1 x i16> [[SPLAT_SPLAT25]], [[BLOCK23]]
; CHECK-NEXT:    [[TMP16:%.*]] = add <1 x i16> [[TMP13]], [[TMP15]]
; CHECK-NEXT:    [[TMP17:%.*]] = shufflevector <1 x i16> [[TMP16]], <1 x i16> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = shufflevector <1 x i16> poison, <1 x i16> [[TMP17]], <1 x i32> <i32 1>
; CHECK-NEXT:    ret <1 x i16> [[TMP18]]
;
entry:
  %lhs = load <6 x i16>, ptr %lhs_address
  %rhs = load <6 x i16>, ptr %rhs_address
  %result = tail call <1 x i16> @llvm.matrix.multiply.v1i16.v6i16.v6i16(<6 x i16> %lhs, <6 x i16> %rhs, i32 1, i32 6, i32 1)
  ret <1 x i16> %result
}

declare <1 x i16> @llvm.matrix.multiply.v1i16.v6i16.v6i16(<6 x i16>, <6 x i16>, i32, i32, i32)
