; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i8 @llvm.fshl.i8(i8, i8, i8)
declare i8 @llvm.fshr.i8(i8, i8, i8)
declare void @use.i8(i8)
define i1 @cmpeq_rorr_to_rorl(i8 %x, i8 %C) {
; CHECK-LABEL: @cmpeq_rorr_to_rorl(
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.fshl.i8(i8 [[X:%.*]], i8 [[X]], i8 [[C:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP1]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C)
  %r = icmp eq i8 %x_rorr, %x
  ret i1 %r
}

define i1 @cmpeq_rorr_to_rorl_non_equality_fail(i8 %x, i8 %C) {
; CHECK-LABEL: @cmpeq_rorr_to_rorl_non_equality_fail(
; CHECK-NEXT:    [[X_RORR:%.*]] = call i8 @llvm.fshr.i8(i8 [[X:%.*]], i8 [[X]], i8 [[C:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp ult i8 [[X_RORR]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C)
  %r = icmp ult i8 %x_rorr, %x
  ret i1 %r
}

define i1 @cmpeq_rorr_to_rorl_cmp_against_wrong_val_fail(i8 %x, i8 %C) {
; CHECK-LABEL: @cmpeq_rorr_to_rorl_cmp_against_wrong_val_fail(
; CHECK-NEXT:    [[X_RORR:%.*]] = call i8 @llvm.fshr.i8(i8 [[X:%.*]], i8 [[X]], i8 [[C:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp ult i8 [[X_RORR]], [[C]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C)
  %r = icmp ult i8 %x_rorr, %C
  ret i1 %r
}

define i1 @cmpeq_rorr_to_rorl_non_ror_fail(i8 %x, i8 %C) {
; CHECK-LABEL: @cmpeq_rorr_to_rorl_non_ror_fail(
; CHECK-NEXT:    [[X_RORR:%.*]] = call i8 @llvm.fshr.i8(i8 [[X:%.*]], i8 [[C:%.*]], i8 [[C]])
; CHECK-NEXT:    [[R:%.*]] = icmp ult i8 [[X_RORR]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr = call i8 @llvm.fshr.i8(i8 %x, i8 %C, i8 %C)
  %r = icmp ult i8 %x_rorr, %x
  ret i1 %r
}

define i1 @cmpeq_rorr_to_rorl_multiuse_fail(i8 %x, i8 %C) {
; CHECK-LABEL: @cmpeq_rorr_to_rorl_multiuse_fail(
; CHECK-NEXT:    [[X_RORR:%.*]] = call i8 @llvm.fshr.i8(i8 [[X:%.*]], i8 [[X]], i8 [[C:%.*]])
; CHECK-NEXT:    call void @use.i8(i8 [[X_RORR]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[X_RORR]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C)
  call void @use.i8(i8 %x_rorr)
  %r = icmp eq i8 %x_rorr, %x
  ret i1 %r
}

define i1 @cmpne_rorr_rorr(i8 %x, i8 %C0, i8 %C1) {
; CHECK-LABEL: @cmpne_rorr_rorr(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i8 [[C0:%.*]], [[C1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = call i8 @llvm.fshl.i8(i8 [[X:%.*]], i8 [[X]], i8 [[TMP1]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[TMP2]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr0 = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C0)
  %x_rorr1 = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C1)
  %r = icmp ne i8 %x_rorr0, %x_rorr1
  ret i1 %r
}

define i1 @cmpne_rorrX_rorrY(i8 %x, i8 %y, i8 %C0, i8 %C1) {
; CHECK-LABEL: @cmpne_rorrX_rorrY(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i8 [[C0:%.*]], [[C1:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = call i8 @llvm.fshr.i8(i8 [[X:%.*]], i8 [[X]], i8 [[TMP1]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[TMP2]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr0 = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C0)
  %y_rorr1 = call i8 @llvm.fshr.i8(i8 %y, i8 %y, i8 %C1)
  %r = icmp ne i8 %x_rorr0, %y_rorr1
  ret i1 %r
}


define i1 @cmpne_rorr_rorr_non_equality_fail(i8 %x, i8 %C0, i8 %C1) {
; CHECK-LABEL: @cmpne_rorr_rorr_non_equality_fail(
; CHECK-NEXT:    [[X_RORR0:%.*]] = call i8 @llvm.fshr.i8(i8 [[X:%.*]], i8 [[X]], i8 [[C0:%.*]])
; CHECK-NEXT:    [[X_RORR1:%.*]] = call i8 @llvm.fshr.i8(i8 [[X]], i8 [[X]], i8 [[C1:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp sge i8 [[X_RORR0]], [[X_RORR1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr0 = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C0)
  %x_rorr1 = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C1)
  %r = icmp sge i8 %x_rorr0, %x_rorr1
  ret i1 %r
}


define i1 @cmpne_rorr_rorl_todo_mismatch_C(i8 %x, i8 %C0, i8 %C1) {
; CHECK-LABEL: @cmpne_rorr_rorl_todo_mismatch_C(
; CHECK-NEXT:    [[X_RORR0:%.*]] = call i8 @llvm.fshr.i8(i8 [[X:%.*]], i8 [[X]], i8 [[C0:%.*]])
; CHECK-NEXT:    [[X_RORL1:%.*]] = call i8 @llvm.fshl.i8(i8 [[X]], i8 [[X]], i8 3)
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X_RORR0]], [[X_RORL1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorr0 = call i8 @llvm.fshr.i8(i8 %x, i8 %x, i8 %C0)
  %x_rorl1 = call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 3)
  %r = icmp ne i8 %x_rorr0, %x_rorl1
  ret i1 %r
}

define i1 @cmpne_rorl_rorl_multiuse1_fail(i8 %x, i8 %C0) {
; CHECK-LABEL: @cmpne_rorl_rorl_multiuse1_fail(
; CHECK-NEXT:    [[X_RORL0:%.*]] = call i8 @llvm.fshl.i8(i8 [[X:%.*]], i8 [[X]], i8 [[C0:%.*]])
; CHECK-NEXT:    [[X_RORL1:%.*]] = call i8 @llvm.fshl.i8(i8 [[X]], i8 [[X]], i8 3)
; CHECK-NEXT:    call void @use.i8(i8 [[X_RORL1]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X_RORL0]], [[X_RORL1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorl0 = call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 %C0)
  %x_rorl1 = call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 3)
  call void @use.i8(i8 %x_rorl1)
  %r = icmp ne i8 %x_rorl0, %x_rorl1
  ret i1 %r
}

define i1 @cmpeq_rorlXC_rorlYC_multiuse1(i8 %x, i8 %y) {
; CHECK-LABEL: @cmpeq_rorlXC_rorlYC_multiuse1(
; CHECK-NEXT:    [[Y_RORL1:%.*]] = call i8 @llvm.fshl.i8(i8 [[Y:%.*]], i8 [[Y]], i8 3)
; CHECK-NEXT:    call void @use.i8(i8 [[Y_RORL1]])
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.fshl.i8(i8 [[X:%.*]], i8 [[X]], i8 3)
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorl0 = call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 6)
  %y_rorl1 = call i8 @llvm.fshl.i8(i8 %y, i8 %y, i8 3)
  call void @use.i8(i8 %y_rorl1)
  %r = icmp eq i8 %x_rorl0, %y_rorl1
  ret i1 %r
}

define i1 @cmpeq_rorlC_rorlC_multiuse2_fail(i8 %x) {
; CHECK-LABEL: @cmpeq_rorlC_rorlC_multiuse2_fail(
; CHECK-NEXT:    [[X_RORL0:%.*]] = call i8 @llvm.fshl.i8(i8 [[X:%.*]], i8 [[X]], i8 6)
; CHECK-NEXT:    [[X_RORL1:%.*]] = call i8 @llvm.fshl.i8(i8 [[X]], i8 [[X]], i8 3)
; CHECK-NEXT:    call void @use.i8(i8 [[X_RORL0]])
; CHECK-NEXT:    call void @use.i8(i8 [[X_RORL1]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[X_RORL0]], [[X_RORL1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_rorl0 = call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 6)
  %x_rorl1 = call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 3)
  call void @use.i8(i8 %x_rorl0)
  call void @use.i8(i8 %x_rorl1)
  %r = icmp eq i8 %x_rorl0, %x_rorl1
  ret i1 %r
}
