; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

define i32 @ctlz_true_freeze(i32 %arg) {
; CHECK-LABEL: @ctlz_true_freeze(
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.ctlz.i32(i32 [[ARG:%.*]], i1 true), !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[CALL]]
; CHECK-NEXT:    ret i32 [[FREEZE]]
;
  %call = call i32 @llvm.ctlz.i32(i32 %arg, i1 true)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @ctlz_false_freeze(i32 %arg) {
; CHECK-LABEL: @ctlz_false_freeze(
; CHECK-NEXT:    [[ARG_FR:%.*]] = freeze i32 [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.ctlz.i32(i32 [[ARG_FR]], i1 false), !range [[RNG0]]
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.ctlz.i32(i32 %arg, i1 false)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @ctlz_true_noundef_freeze(i32 %arg) {
; CHECK-LABEL: @ctlz_true_noundef_freeze(
; CHECK-NEXT:    [[CALL:%.*]] = call noundef i32 @llvm.ctlz.i32(i32 [[ARG:%.*]], i1 true), !range [[RNG0]]
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call noundef i32 @llvm.ctlz.i32(i32 %arg, i1 true)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @cttz_true_freeze(i32 %arg) {
; CHECK-LABEL: @cttz_true_freeze(
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.cttz.i32(i32 [[ARG:%.*]], i1 true), !range [[RNG0]]
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[CALL]]
; CHECK-NEXT:    ret i32 [[FREEZE]]
;
  %call = call i32 @llvm.cttz.i32(i32 %arg, i1 true)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @cttz_true_noundef_freeze(i32 %arg) {
; CHECK-LABEL: @cttz_true_noundef_freeze(
; CHECK-NEXT:    [[CALL:%.*]] = call noundef i32 @llvm.cttz.i32(i32 [[ARG:%.*]], i1 true), !range [[RNG0]]
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call noundef i32 @llvm.cttz.i32(i32 %arg, i1 true)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @freeze_cttz_true(i32 %arg) {
; CHECK-LABEL: @freeze_cttz_true(
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.cttz.i32(i32 [[FREEZE]], i1 true), !range [[RNG0]]
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %freeze = freeze i32 %arg
  %call = call i32 @llvm.cttz.i32(i32 %freeze, i1 true)
  ret i32 %call
}

define i32 @cttz_false_freeze(i32 %arg) {
; CHECK-LABEL: @cttz_false_freeze(
; CHECK-NEXT:    [[ARG_FR:%.*]] = freeze i32 [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.cttz.i32(i32 [[ARG_FR]], i1 false), !range [[RNG0]]
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.cttz.i32(i32 %arg, i1 false)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @freeze_cttz_false(i32 %arg) {
; CHECK-LABEL: @freeze_cttz_false(
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.cttz.i32(i32 [[FREEZE]], i1 false), !range [[RNG0]]
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %freeze = freeze i32 %arg
  %call = call i32 @llvm.cttz.i32(i32 %freeze, i1 false)
  ret i32 %call
}

define i32 @abs_true_i32(i32 %arg) {
; CHECK-LABEL: @abs_true_i32(
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.abs.i32(i32 [[ARG:%.*]], i1 true)
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[CALL]]
; CHECK-NEXT:    ret i32 [[FREEZE]]
;
  %call = call i32 @llvm.abs.i32(i32 %arg, i1 true)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @abs_false_i32(i32 %arg) {
; CHECK-LABEL: @abs_false_i32(
; CHECK-NEXT:    [[ARG_FR:%.*]] = freeze i32 [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.abs.i32(i32 [[ARG_FR]], i1 false)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @noundef_abs_true_i32(i32 %arg) {
; CHECK-LABEL: @noundef_abs_true_i32(
; CHECK-NEXT:    [[CALL:%.*]] = call noundef i32 @llvm.abs.i32(i32 [[ARG:%.*]], i1 true)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call noundef i32 @llvm.abs.i32(i32 %arg, i1 true)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @bswap_i32(i32 %arg) {
; CHECK-LABEL: @bswap_i32(
; CHECK-NEXT:    [[ARG_FR:%.*]] = freeze i32 [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.bswap.i32(i32 [[ARG_FR]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.bswap.i32(i32 %arg)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @bitreverse_i32(i32 %arg) {
; CHECK-LABEL: @bitreverse_i32(
; CHECK-NEXT:    [[ARG_FR:%.*]] = freeze i32 [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.bitreverse.i32(i32 [[ARG_FR]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.bitreverse.i32(i32 %arg)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @fshl_i32(i32 %arg0, i32 noundef %arg1, i32 noundef %arg2) {
; CHECK-LABEL: @fshl_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.fshl.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]], i32 [[ARG2:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.fshl.i32(i32 %arg0, i32 %arg1, i32 %arg2)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @fshr_i32(i32 %arg0, i32 noundef %arg1, i32 noundef %arg2) {
; CHECK-LABEL: @fshr_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.fshr.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]], i32 [[ARG2:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.fshr.i32(i32 %arg0, i32 %arg1, i32 %arg2)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @smax_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @smax_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.smax.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.smax.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @smin_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @smin_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.smin.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.smin.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @umax_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @umax_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.umax.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.umax.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @umin_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @umin_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.umin.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.umin.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define ptr @ptrmask_p0(ptr %arg0, i64 noundef %arg1) {
; CHECK-LABEL: @ptrmask_p0(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze ptr [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[ARG0_FR]], i64 [[ARG1:%.*]])
; CHECK-NEXT:    ret ptr [[CALL]]
;
  %call = call ptr @llvm.ptrmask.p0.i64(ptr %arg0, i64 %arg1)
  %freeze = freeze ptr %call
  ret ptr %freeze
}

define i32 @fptoui_sat(float %arg) {
; CHECK-LABEL: @fptoui_sat(
; CHECK-NEXT:    [[ARG_FR:%.*]] = freeze float [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.fptoui.sat.i32.f32(float [[ARG_FR]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.fptoui.sat.i32.f32(float %arg)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @fptosi_sat(float %arg) {
; CHECK-LABEL: @fptosi_sat(
; CHECK-NEXT:    [[ARG_FR:%.*]] = freeze float [[ARG:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.fptosi.sat.i32.f32(float [[ARG_FR]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.fptosi.sat.i32.f32(float %arg)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @sadd_sat_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @sadd_sat_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.sadd.sat.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.sadd.sat.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @uadd_sat_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @uadd_sat_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.uadd.sat.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.uadd.sat.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @ssub_sat_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @ssub_sat_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.ssub.sat.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.ssub.sat.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @usub_sat_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @usub_sat_i32(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.usub.sat.i32(i32 [[ARG0_FR]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.usub.sat.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @sshl_sat_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @sshl_sat_i32(
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.sshl.sat.i32(i32 [[ARG0:%.*]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[CALL]]
; CHECK-NEXT:    ret i32 [[FREEZE]]
;
  %call = call i32 @llvm.sshl.sat.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @ushl_sat_i32(i32 %arg0, i32 noundef %arg1) {
; CHECK-LABEL: @ushl_sat_i32(
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.ushl.sat.i32(i32 [[ARG0:%.*]], i32 [[ARG1:%.*]])
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[CALL]]
; CHECK-NEXT:    ret i32 [[FREEZE]]
;
  %call = call i32 @llvm.ushl.sat.i32(i32 %arg0, i32 %arg1)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @sshl_sat_i32_safe_constant(i32 %arg0) {
; CHECK-LABEL: @sshl_sat_i32_safe_constant(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.sshl.sat.i32(i32 [[ARG0_FR]], i32 8)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.sshl.sat.i32(i32 %arg0, i32 8)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @ushl_sat_i32_safe_constant(i32 %arg0) {
; CHECK-LABEL: @ushl_sat_i32_safe_constant(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze i32 [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.ushl.sat.i32(i32 [[ARG0_FR]], i32 8)
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %call = call i32 @llvm.ushl.sat.i32(i32 %arg0, i32 8)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @sshl_sat_i32_unsafe_constant(i32 %arg0) {
; CHECK-LABEL: @sshl_sat_i32_unsafe_constant(
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.sshl.sat.i32(i32 [[ARG0:%.*]], i32 32)
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[CALL]]
; CHECK-NEXT:    ret i32 [[FREEZE]]
;
  %call = call i32 @llvm.sshl.sat.i32(i32 %arg0, i32 32)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define i32 @ushl_sat_i32_unsafe_constant(i32 %arg0) {
; CHECK-LABEL: @ushl_sat_i32_unsafe_constant(
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @llvm.ushl.sat.i32(i32 [[ARG0:%.*]], i32 32)
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze i32 [[CALL]]
; CHECK-NEXT:    ret i32 [[FREEZE]]
;
  %call = call i32 @llvm.ushl.sat.i32(i32 %arg0, i32 32)
  %freeze = freeze i32 %call
  ret i32 %freeze
}

define <2 x i32> @sshl_sat_v2i32_safe_constant(<2 x i32> %arg0) {
; CHECK-LABEL: @sshl_sat_v2i32_safe_constant(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze <2 x i32> [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x i32> @llvm.sshl.sat.v2i32(<2 x i32> [[ARG0_FR]], <2 x i32> <i32 8, i32 9>)
; CHECK-NEXT:    ret <2 x i32> [[CALL]]
;
  %call = call <2 x i32> @llvm.sshl.sat.v2i32(<2 x i32> %arg0, <2 x i32> <i32 8, i32 9>)
  %freeze = freeze <2 x i32> %call
  ret <2 x i32> %freeze
}

define <2 x i32> @ushl_sat_v2i32_safe_constant_vector(<2 x i32> %arg0) {
; CHECK-LABEL: @ushl_sat_v2i32_safe_constant_vector(
; CHECK-NEXT:    [[ARG0_FR:%.*]] = freeze <2 x i32> [[ARG0:%.*]]
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x i32> @llvm.ushl.sat.v2i32(<2 x i32> [[ARG0_FR]], <2 x i32> <i32 8, i32 9>)
; CHECK-NEXT:    ret <2 x i32> [[CALL]]
;
  %call = call <2 x i32> @llvm.ushl.sat.v2i32(<2 x i32> %arg0, <2 x i32> <i32 8, i32 9>)
  %freeze = freeze <2 x i32> %call
  ret <2 x i32> %freeze
}

define <2 x i32> @ushl_sat_v2i32_unsafe_constant_vector(<2 x i32> %arg0) {
; CHECK-LABEL: @ushl_sat_v2i32_unsafe_constant_vector(
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x i32> @llvm.ushl.sat.v2i32(<2 x i32> [[ARG0:%.*]], <2 x i32> <i32 undef, i32 9>)
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze <2 x i32> [[CALL]]
; CHECK-NEXT:    ret <2 x i32> [[FREEZE]]
;
  %call = call <2 x i32> @llvm.ushl.sat.v2i32(<2 x i32> %arg0, <2 x i32> <i32 undef, i32 9>)
  %freeze = freeze <2 x i32> %call
  ret <2 x i32> %freeze
}

define <2 x i32> @sshl_sat_v2i32_unsafe_constant_vector(<2 x i32> %arg0) {
; CHECK-LABEL: @sshl_sat_v2i32_unsafe_constant_vector(
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x i32> @llvm.sshl.sat.v2i32(<2 x i32> [[ARG0:%.*]], <2 x i32> <i32 undef, i32 9>)
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze <2 x i32> [[CALL]]
; CHECK-NEXT:    ret <2 x i32> [[FREEZE]]
;
  %call = call <2 x i32> @llvm.sshl.sat.v2i32(<2 x i32> %arg0, <2 x i32> <i32 undef, i32 9>)
  %freeze = freeze <2 x i32> %call
  ret <2 x i32> %freeze
}

define <vscale x 2 x i32> @ushl_sat_v2i32_scalable_zeroinitializer(<vscale x 2 x i32> %arg0) {
; CHECK-LABEL: @ushl_sat_v2i32_scalable_zeroinitializer(
; CHECK-NEXT:    [[CALL:%.*]] = call <vscale x 2 x i32> @llvm.ushl.sat.nxv2i32(<vscale x 2 x i32> [[ARG0:%.*]], <vscale x 2 x i32> zeroinitializer)
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze <vscale x 2 x i32> [[CALL]]
; CHECK-NEXT:    ret <vscale x 2 x i32> [[FREEZE]]
;
  %call = call <vscale x 2 x i32> @llvm.ushl.sat.nxv2i32(<vscale x 2 x i32> %arg0, <vscale x 2 x i32> zeroinitializer)
  %freeze = freeze <vscale x 2 x i32> %call
  ret <vscale x 2 x i32> %freeze
}

define <vscale x 2 x i32> @sshl_sat_v2i32_scalable_zeroinitializer(<vscale x 2 x i32> %arg0) {
; CHECK-LABEL: @sshl_sat_v2i32_scalable_zeroinitializer(
; CHECK-NEXT:    [[CALL:%.*]] = call <vscale x 2 x i32> @llvm.sshl.sat.nxv2i32(<vscale x 2 x i32> [[ARG0:%.*]], <vscale x 2 x i32> zeroinitializer)
; CHECK-NEXT:    [[FREEZE:%.*]] = freeze <vscale x 2 x i32> [[CALL]]
; CHECK-NEXT:    ret <vscale x 2 x i32> [[FREEZE]]
;
  %call = call <vscale x 2 x i32> @llvm.sshl.sat.nxv2i32(<vscale x 2 x i32> %arg0, <vscale x 2 x i32> zeroinitializer)
  %freeze = freeze <vscale x 2 x i32> %call
  ret <vscale x 2 x i32> %freeze
}

define i1 @widenable_condition() {
; CHECK-LABEL: @widenable_condition(
; CHECK-NEXT:    [[WC:%.*]] = call i1 @llvm.experimental.widenable.condition()
; CHECK-NEXT:    ret i1 [[WC]]
;
  %wc = call i1 @llvm.experimental.widenable.condition()
  %freeze = freeze i1 %wc
  ret i1 %freeze
}

declare i32 @llvm.ctlz.i32(i32, i1 immarg)
declare i32 @llvm.cttz.i32(i32, i1 immarg)
declare i32 @llvm.abs.i32(i32, i1 immarg)
declare i32 @llvm.bswap.i32(i32)
declare i32 @llvm.bitreverse.i32(i32)
declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i32 @llvm.fshr.i32(i32, i32, i32)
declare i32 @llvm.smax.i32(i32, i32)
declare i32 @llvm.smin.i32(i32, i32)
declare i32 @llvm.umax.i32(i32, i32)
declare i32 @llvm.umin.i32(i32, i32)
declare ptr @llvm.ptrmask.p0.i64(ptr, i64)
declare i32 @llvm.fptoui.sat.i32.f32(float)
declare i32 @llvm.fptosi.sat.i32.f32(float)
declare i32 @llvm.sadd.sat.i32(i32, i32)
declare i32 @llvm.uadd.sat.i32(i32, i32)
declare i32 @llvm.ssub.sat.i32(i32, i32)
declare i32 @llvm.usub.sat.i32(i32, i32)
declare i32 @llvm.sshl.sat.i32(i32, i32)
declare i32 @llvm.ushl.sat.i32(i32, i32)
declare <2 x i32> @llvm.sshl.sat.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.ushl.sat.v2i32(<2 x i32>, <2 x i32>)
declare <vscale x 2 x i32> @llvm.sshl.sat.nxv2i32(<vscale x 2 x i32>, <vscale x 2 x i32>)
declare <vscale x 2 x i32> @llvm.ushl.sat.nxv2i32(<vscale x 2 x i32>, <vscale x 2 x i32>)
declare i1 @llvm.experimental.widenable.condition()
