; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

declare void @llvm.assume(i1)

define i1 @test(i8 %x, i8 %y) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    [[ADD:%.*]] = add nuw nsw i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[CMP_0:%.*]] = icmp uge i8 [[ADD]], 10
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[CMP_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[X]] to i16
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge i16 [[EXT]], 0
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge i16 [[EXT]], 1
; CHECK-NEXT:    [[RES:%.*]] = xor i1 true, [[C_1]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %add = add nuw nsw i8 %x, %y
  %cmp.0 = icmp uge i8 %add, 10
  tail call void @llvm.assume(i1 %cmp.0)
  %ext = zext i8 %x to i16
  %t.1 = icmp uge i16 %ext, 0
  %c.1 = icmp uge i16 %ext, 1
  %res = xor i1 %t.1, %c.1
  ret i1 %res
}

define i1 @test2(i8 %x, i8 %y) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[ADD:%.*]] = add nuw nsw i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[CMP_0:%.*]] = icmp uge i8 [[ADD]], 0
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[CMP_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[X]] to i16
; CHECK-NEXT:    [[ADD_1:%.*]] = add nuw nsw i16 [[EXT]], 1
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge i16 [[ADD_1]], 1
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge i16 [[ADD_1]], 2
; CHECK-NEXT:    [[F_1:%.*]] = icmp ult i16 [[ADD_1]], 1
; CHECK-NEXT:    [[RES_1:%.*]] = xor i1 true, [[C_1]]
; CHECK-NEXT:    [[RES_2:%.*]] = xor i1 [[RES_1]], false
; CHECK-NEXT:    [[C_2:%.*]] = icmp sge i16 [[ADD_1]], 1
; CHECK-NEXT:    [[RES_3:%.*]] = xor i1 [[RES_2]], [[C_2]]
; CHECK-NEXT:    ret i1 [[RES_3]]
;
  %add = add nuw nsw i8 %x, %y
  %cmp.0 = icmp uge i8 %add, 0
  tail call void @llvm.assume(i1 %cmp.0)
  %ext = zext i8 %x to i16
  %add.1 = add nuw nsw i16 %ext, 1
  %t.1 = icmp uge i16 %add.1, 1
  %c.1 = icmp uge i16 %add.1, 2
  %f.1 = icmp ult i16 %add.1, 1
  %res.1 = xor i1 %t.1, %c.1
  %res.2 = xor i1 %res.1, %f.1
  %c.2 = icmp sge i16 %add.1, 1
  %res.3 = xor i1 %res.2, %c.2
  ret i1 %res.3
}

define i1 @gep_zext_idx(ptr %p, i8 %cnt, i8 %off) {
; CHECK-LABEL: @gep_zext_idx(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw nsw i8 [[CNT:%.*]], [[OFF:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[ADD]], 10
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[CNT]] to i16
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, ptr [[P:%.*]], i16 [[EXT]]
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[ADD_PTR]], [[P]]
; CHECK-NEXT:    [[F_1:%.*]] = icmp ult ptr [[ADD_PTR]], [[P]]
; CHECK-NEXT:    [[GEP_11:%.*]] = getelementptr inbounds i32, ptr [[P]], i16 11
; CHECK-NEXT:    [[C_1:%.*]] = icmp ugt ptr [[ADD_PTR]], [[GEP_11]]
; CHECK-NEXT:    [[RES_1:%.*]] = xor i1 true, false
; CHECK-NEXT:    [[RES_2:%.*]] = xor i1 [[RES_1]], [[C_1]]
; CHECK-NEXT:    ret i1 [[RES_2]]
;
entry:
  %add = add nuw nsw i8 %cnt, %off
  %cmp = icmp ugt i8 %add, 10
  tail call void @llvm.assume(i1 %cmp)
  %ext = zext i8 %cnt to i16
  %add.ptr = getelementptr inbounds i32, ptr %p, i16 %ext
  %t.1 = icmp uge ptr %add.ptr, %p
  %f.1 = icmp ult ptr %add.ptr, %p
  %gep.11 = getelementptr inbounds i32, ptr %p, i16 11
  %c.1 = icmp ugt ptr %add.ptr, %gep.11
  %res.1 = xor i1 %t.1, %f.1
  %res.2 = xor i1 %res.1, %c.1
  ret i1 %res.2
}

define i1 @gep_zext_idx_adds(ptr %p, i8 %cnt, i8 %off) {
; CHECK-LABEL: @gep_zext_idx_adds(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw nsw i8 [[CNT:%.*]], [[OFF:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[ADD]], 10
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[CNT]] to i16
; CHECK-NEXT:    [[EXT_1:%.*]] = add nuw nsw i16 [[EXT]], 1
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, ptr [[P:%.*]], i16 [[EXT_1]]
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[ADD_PTR]], [[P]]
; CHECK-NEXT:    [[F_1:%.*]] = icmp ult ptr [[ADD_PTR]], [[P]]
; CHECK-NEXT:    [[GEP_11:%.*]] = getelementptr inbounds i32, ptr [[P]], i16 11
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge ptr [[ADD_PTR]], [[GEP_11]]
; CHECK-NEXT:    [[RES_1:%.*]] = xor i1 [[T_1]], [[F_1]]
; CHECK-NEXT:    [[RES_2:%.*]] = xor i1 [[RES_1]], [[C_1]]
; CHECK-NEXT:    ret i1 [[RES_2]]
;
entry:
  %add = add nuw nsw i8 %cnt, %off
  %cmp = icmp uge i8 %add, 10
  tail call void @llvm.assume(i1 %cmp)
  %ext = zext i8 %cnt to i16
  %ext.1 = add nuw nsw i16 %ext, 1
  %add.ptr = getelementptr inbounds i32, ptr %p, i16 %ext.1
  %t.1 = icmp uge ptr %add.ptr, %p
  %f.1 = icmp ult ptr %add.ptr, %p
  %gep.11 = getelementptr inbounds i32, ptr %p, i16 11
  %c.1 = icmp uge ptr %add.ptr, %gep.11
  %res.1 = xor i1 %t.1, %f.1
  %res.2 = xor i1 %res.1, %c.1
  ret i1 %res.2
}
